/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugin.importer;

import docking.DialogComponentProvider;
import docking.widgets.OptionDialog;
import ghidra.app.plugin.core.help.AboutDomainObjectUtils;
import ghidra.app.services.FileSystemBrowserService;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MemoryConflictHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderService;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemProgramProvider;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectDataUtils;
import ghidra.framework.options.Options;
import ghidra.framework.plugintool.PluginTool;
import ghidra.plugin.importer.AddToProgramDialog;
import ghidra.plugin.importer.ImporterDialog;
import ghidra.plugin.importer.ProgramMappingService;
import ghidra.plugins.importer.batch.BatchImportDialog;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DefaultLanguageService;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import util.CollectionUtils;

public class ImporterUtilities {
    public static final GhidraFileFilter LOADABLE_FILES_FILTER = ExtensionFileFilter.forExtensions((String)"Loadable files", (String[])new String[]{"exe", "dll", "obj", "drv", "bin", "o", "a", "so", "class", "lib"});
    public static final GhidraFileFilter CONTAINER_FILES_FILTER = ExtensionFileFilter.forExtensions((String)"Container files", (String[])new String[]{"zip", "tar", "tgz", "jar", "gz", "ipsw", "img3", "dmg", "apk", "cpio", "rpm", "lib"});

    static List<LanguageCompilerSpecPair> getPairs(Collection<LoadSpec> loadSpecs) {
        HashSet<LanguageCompilerSpecPair> pairs = new HashSet<LanguageCompilerSpecPair>();
        for (LoadSpec loadSpec : loadSpecs) {
            LanguageCompilerSpecPair pair = loadSpec.getLanguageCompilerSpec();
            if (pair == null) continue;
            pairs.add(pair);
        }
        return CollectionUtils.asList(pairs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProgramProperties(Program program, FSRL fsrl, TaskMonitor monitor) throws CancelledException, IOException {
        int id = program.startTransaction("setImportProperties");
        try {
            fsrl = FileSystemService.getInstance().getFullyQualifiedFSRL(fsrl, monitor);
            Options propertyList = program.getOptions("Program Information");
            propertyList.setString("FSRL", fsrl.toString());
            if ((program.getExecutableMD5() == null || program.getExecutableMD5().isEmpty()) && fsrl.getMD5() != null) {
                program.setExecutableMD5(fsrl.getMD5());
            }
        }
        finally {
            program.endTransaction(id, true);
        }
        if (program.canSave()) {
            program.save("Added import properties", monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void showImportDialog(FSRL fsrl, DomainFolder destFolder, String suggestedDestinationPath, PluginTool tool, ProgramManager programManager) {
        Window parent = tool.getActiveWindow();
        AtomicReference refdFile = new AtomicReference();
        AtomicReference fqFSRL = new AtomicReference();
        AtomicBoolean isFSContainer = new AtomicBoolean();
        AtomicBoolean success = new AtomicBoolean();
        try {
            TaskLauncher.launchModal((String)"Import", monitor -> {
                try {
                    RefdFile tmpRefdFile = FileSystemService.getInstance().getRefdFile(fsrl, monitor);
                    refdFile.set(tmpRefdFile);
                    FSRL tmpFQFSRL = FileSystemService.getInstance().getFullyQualifiedFSRL(fsrl, monitor);
                    fqFSRL.set(tmpFQFSRL);
                    isFSContainer.set(FileSystemService.getInstance().isFileFilesystemContainer(tmpFQFSRL, monitor));
                    success.set(true);
                }
                catch (IOException ioe) {
                    Msg.showError(ImporterUtilities.class, (Component)parent, (String)"Import Error", (Object)("Unable to import file " + fsrl.getName() + (String)(ioe.getMessage() != null ? "\n\nCause: " + ioe.getMessage() : "")), (Throwable)ioe);
                }
                catch (CancelledException e) {
                    Msg.info(ImporterUtilities.class, (Object)"ShowImportDialog canceled");
                }
            });
            if (!success.get()) {
                return;
            }
            if (((RefdFile)refdFile.get()).file.getLength() == 0L) {
                Msg.showError(ImporterUtilities.class, (Component)parent, (String)"File is empty", (Object)("File " + fsrl.getPath() + " is empty, nothing to import"));
                return;
            }
            GFileSystem fs = ((RefdFile)refdFile.get()).fsRef.getFilesystem();
            if (fs instanceof GFileSystemProgramProvider) {
                ImporterUtilities.doFSImport((RefdFile)refdFile.get(), (FSRL)fqFSRL.get(), destFolder, programManager, tool);
                return;
            }
            if (isFSContainer.get()) {
                FileSystemBrowserService fsbService = (FileSystemBrowserService)tool.getService(FileSystemBrowserService.class);
                String fsbChoice = fsbService != null ? "File system" : null;
                int choice = OptionDialog.showOptionDialog((Component)parent, (String)"Container file detected", (String)("The file " + ((RefdFile)refdFile.get()).file.getName() + " seems to have nested files in it.  Select an import mode:"), (String)"Single file", (String)"Batch", (String)fsbChoice, (int)3);
                if (choice == 1) {
                    ImporterUtilities.importSingleFile((FSRL)fqFSRL.get(), destFolder, suggestedDestinationPath, tool, programManager);
                    return;
                }
                if (choice == 2) {
                    BatchImportDialog.showAndImport(tool, null, Arrays.asList((FSRL)fqFSRL.get()), destFolder, programManager);
                    return;
                }
                if (choice != 3) return;
                fsbService.openFileSystem((FSRL)fqFSRL.get());
                return;
            }
            ImporterUtilities.importSingleFile((FSRL)fqFSRL.get(), destFolder, suggestedDestinationPath, tool, programManager);
            return;
        }
        finally {
            if (refdFile.get() != null) {
                try {
                    ((RefdFile)refdFile.get()).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void showAddToProgramDialog(FSRL fsrl, Program program, PluginTool tool, TaskMonitor monitor) {
        try {
            ByteProvider provider = FileSystemService.getInstance().getByteProvider(fsrl, monitor);
            if (provider.length() == 0L) {
                Msg.showWarn(null, null, (String)("Error opening " + fsrl.getName()), (Object)"The item does not correspond to a valid file.");
                return;
            }
            Map<Loader, Collection<LoadSpec>> loadMap = LoaderService.getAllSupportedLoadSpecs(provider);
            SystemUtilities.runSwingLater(() -> {
                AddToProgramDialog dialog = new AddToProgramDialog(tool, fsrl, loadMap, provider, program);
                tool.showDialog((DialogComponentProvider)dialog);
            });
        }
        catch (IOException e) {
            Msg.showError(ImporterUtilities.class, null, (String)"Error reading data", (Object)("I/O error reading " + fsrl.getName()), (Throwable)e);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    private static void importSingleFile(FSRL fsrl, DomainFolder defaultFolder, String suggestedDestinationPath, PluginTool tool, ProgramManager programManager) {
        TaskLauncher.launchNonModal((String)"Import File", monitor -> {
            try {
                ByteProvider provider = FileSystemService.getInstance().getByteProvider(fsrl, monitor);
                Map<Loader, Collection<LoadSpec>> loadMap = LoaderService.getAllSupportedLoadSpecs(provider);
                SystemUtilities.runSwingLater(() -> {
                    ImporterDialog importerDialog = new ImporterDialog(tool, programManager, loadMap, provider, suggestedDestinationPath);
                    if (defaultFolder != null) {
                        importerDialog.setDestinationFolder(defaultFolder);
                    }
                    tool.showDialog((DialogComponentProvider)importerDialog);
                });
            }
            catch (IOException ioe) {
                Msg.showError(ImporterUtilities.class, (Component)tool.getActiveWindow(), (String)"Error Importing File", (Object)("Error when importing file " + fsrl), (Throwable)ioe);
            }
            catch (CancelledException e) {
                Msg.info(ImporterUtilities.class, (Object)("Import single file " + fsrl + " cancelled"));
            }
        });
    }

    private static void doFSImport(RefdFile refdFile, FSRL fsrl, DomainFolder destFolderParam, ProgramManager programManager, PluginTool tool) {
        TaskLauncher.launchNonModal((String)"Import File (FileSystem specific)", monitor -> {
            GFile gfile = refdFile.file;
            try {
                Object consumer = new Object();
                DomainFolder destFolder = destFolderParam == null ? AppInfo.getActiveProject().getProjectData().getRootFolder() : destFolderParam;
                Program program = ImporterUtilities.doFSImportHelper((GFileSystemProgramProvider)((Object)refdFile.fsRef.getFilesystem()), gfile, destFolder, consumer, monitor);
                if (program != null) {
                    ImporterUtilities.doPostImportProcessing(tool, programManager, fsrl, Arrays.asList(program), consumer, "", monitor);
                }
            }
            catch (Exception e) {
                FSUtilities.displayException(ImporterUtilities.class, tool.getActiveWindow(), "Problem Encountered During Import", "Unable to import file " + refdFile.file.getName() + " using special purpose loader built into the " + gfile.getFilesystem().getDescription() + " filesystem.", e);
            }
        });
    }

    private static Program doFSImportHelper(GFileSystemProgramProvider pfs, GFile gfile, DomainFolder destFolder, Object consumer, TaskMonitor monitor) throws Exception {
        Program program = pfs.getProgram(gfile, DefaultLanguageService.getLanguageService(), monitor, consumer);
        if (program != null) {
            String importFilename = ProjectDataUtils.getUniqueName((DomainFolder)destFolder, (String)program.getName());
            if (importFilename == null) {
                program.release(consumer);
                throw new IOException("Unable to find unique name for " + program.getName());
            }
            destFolder.createFile(importFilename, (DomainObject)program, monitor);
        }
        return program;
    }

    public static void doSingleImport(FSRL fsrl, DomainFolder destFolder, LoadSpec loadSpec, String programName, List<Option> options, PluginTool tool, ProgramManager programManager, TaskMonitor monitor) {
        try (ByteProvider bp2 = FileSystemService.getInstance().getByteProvider(fsrl, monitor);){
            Object consumer = new Object();
            MessageLog messageLog = new MessageLog();
            List<DomainObject> importedObjects = loadSpec.getLoader().load(bp2, programName, destFolder, loadSpec, options, messageLog, consumer, monitor);
            if (importedObjects == null) {
                return;
            }
            ImporterUtilities.doPostImportProcessing(tool, programManager, fsrl, importedObjects, consumer, messageLog.toString(), monitor);
        }
        catch (CancelledException bp2) {
        }
        catch (Exception e) {
            Msg.showError(ImporterUtilities.class, (Component)tool.getActiveWindow(), (String)"Error Importing File", (Object)("Error importing file: " + fsrl.getName()), (Throwable)e);
        }
    }

    private static Set<DomainFile> doPostImportProcessing(PluginTool pluginTool, ProgramManager programManager, FSRL fsrl, List<DomainObject> importedObjects, Object consumer, String importMessages, TaskMonitor monitor) throws CancelledException, IOException {
        boolean firstProgram = true;
        HashSet<DomainFile> importedFilesSet = new HashSet<DomainFile>();
        for (DomainObject importedObject : importedObjects) {
            monitor.checkCanceled();
            if (importedObject instanceof Program) {
                Program program = (Program)importedObject;
                if (programManager != null) {
                    int openState = firstProgram ? 1 : 2;
                    programManager.openProgram(program, openState);
                }
                ImporterUtilities.setProgramProperties(program, fsrl, monitor);
                ProgramMappingService.createAssociation(fsrl, program);
                importedFilesSet.add(program.getDomainFile());
            }
            if (firstProgram) {
                ImporterUtilities.displayResults(pluginTool, importedObject, importedObject.getDomainFile(), importMessages);
            }
            importedObject.release(consumer);
            firstProgram = false;
        }
        ImporterUtilities.selectFiles(importedFilesSet);
        return importedFilesSet;
    }

    private static void selectFiles(Set<DomainFile> importedFilesSet) {
        FrontEndTool frontEndTool = AppInfo.getFrontEndTool();
        if (frontEndTool != null) {
            frontEndTool.selectFiles(importedFilesSet);
        }
    }

    public static void doAddToProgram(FSRL fsrl, LoadSpec loadSpec, List<Option> options, Program program, TaskMonitor monitor, PluginTool tool) {
        MessageLog messageLog = new MessageLog();
        try (ByteProvider bp = FileSystemService.getInstance().getByteProvider(fsrl, monitor);){
            loadSpec.getLoader().loadInto(bp, loadSpec, options, messageLog, program, monitor, MemoryConflictHandler.ALWAYS_OVERWRITE);
            ImporterUtilities.displayResults(tool, (DomainObject)program, program.getDomainFile(), messageLog.toString());
        }
        catch (CancelledException e) {
            return;
        }
        catch (IOException e) {
            Msg.showError(ImporterUtilities.class, null, (String)"Error Importing File", (Object)("Error importing file " + fsrl.getName()), (Throwable)e);
        }
    }

    private static void displayResults(PluginTool tool, DomainObject obj, DomainFile df, String info) {
        DomainFile domainFile = obj.getDomainFile();
        Map metadata = obj.getMetadata();
        if (df != null) {
            domainFile = df;
            metadata = df.getMetadata();
        }
        HelpLocation helpLocation = new HelpLocation("About", "About_Program");
        AboutDomainObjectUtils.displayInformation((PluginTool)tool, (DomainFile)domainFile, (Map)metadata, (String)"Import Results Summary", (String)info, (HelpLocation)helpLocation);
    }
}

