/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.util.AddressTranslator;

public class AddressTranslationException
extends RuntimeException {
    Address address;
    AddressTranslator translator;

    public AddressTranslationException() {
    }

    public AddressTranslationException(String msg) {
        super(msg);
    }

    public AddressTranslationException(Address address, AddressTranslator translator) {
        super("Cannot translate address \"" + address.toString() + "\" in program \"" + translator.getSourceProgram().getDomainFile().getName() + "\" to address in program \"" + translator.getDestinationProgram().getDomainFile().getName() + "\".\n");
        this.address = address;
        this.translator = translator;
    }

    public Address getAddress() {
        return this.address;
    }

    public AddressTranslator getTranslator() {
        return this.translator;
    }
}

