/*
 * Decompiled with CFR 0.152.
 */
package ghidra.test;

import docking.DockingTool;
import ghidra.app.plugin.core.codebrowser.CodeBrowserPlugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.test.AbstractGhidraHeadedIntegrationTest;
import ghidra.test.TestEnv;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import util.CollectionUtils;

public abstract class AbstractProgramBasedTest
extends AbstractGhidraHeadedIntegrationTest {
    protected TestEnv env;
    protected PluginTool tool;
    protected Program program;
    protected CodeBrowserPlugin codeBrowser;

    protected String getProgramName() {
        throw new AssertException("You must override getProgramName() if you are not building your own program manually");
    }

    protected void initialize() throws Exception {
        this.env = new TestEnv();
        this.program = this.getProgram();
        this.tool = this.env.launchDefaultTool(this.program);
        this.codeBrowser = AbstractProgramBasedTest.getPlugin(this.tool, CodeBrowserPlugin.class);
    }

    protected Program getProgram() throws Exception {
        return this.env.getProgram(this.getProgramName());
    }

    @After
    public void tearDown() throws Exception {
        this.env.release(this.program);
        this.env.dispose();
    }

    public void assertCurrentAddress(Address expected) {
        this.codeBrowser.updateNow();
        AbstractProgramBasedTest.waitForSwing();
        ProgramLocation loc = this.codeBrowser.getCurrentLocation();
        Address actual = loc.getAddress();
        Assert.assertEquals((String)"Listing is not at the expected address", (Object)expected, (Object)actual);
    }

    public Address addr(long offset) {
        return this.addr(this.program, offset);
    }

    public Address addr(String offset) {
        return this.addr(this.program, offset);
    }

    public Address addr(Program p, long offset) {
        AddressFactory addrMap = this.program.getAddressFactory();
        AddressSpace space = addrMap.getDefaultAddressSpace();
        return space.getAddress(offset);
    }

    public Address addr(Program p, String offset) {
        AddressFactory addrMap = p.getAddressFactory();
        AddressSpace space = addrMap.getDefaultAddressSpace();
        try {
            return space.getAddress(offset);
        }
        catch (AddressFormatException e) {
            throw new AssertException("Unable to create address from String '" + offset + "'", (Throwable)e);
        }
    }

    public void goTo(long offset) {
        this.goTo(this.tool, this.program, this.addr(offset));
    }

    public void goTo(String offset) {
        this.goTo(this.tool, this.program, this.addr(offset));
    }

    public AddressRange range(long from, long to) {
        AddressRangeImpl range = new AddressRangeImpl(this.addr(from), this.addr(to));
        return range;
    }

    public void showProvider(String name) {
        this.showProvider((DockingTool)this.tool, name);
    }

    public Function function(Address addr) {
        FunctionManager fm = this.program.getFunctionManager();
        Function f = fm.getFunctionContaining(addr);
        return f;
    }

    public List<Address> addrs(long ... offsets) {
        ArrayList<Address> result = new ArrayList<Address>();
        for (long offset : offsets) {
            result.add(this.addr(offset));
        }
        return result;
    }

    public AddressSet toAddressSet(long ... offsets) {
        List<Address> list = this.addrs(offsets);
        AddressSet addrs = this.toAddressSet(list);
        return addrs;
    }

    public List<Address> addrs(Address ... addrs) {
        return CollectionUtils.asList((Object[])addrs);
    }

    public void goTo(Address a) {
        this.goTo(this.tool, this.program, a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyProgram(ExceptionalCallback<Program> callback) {
        Assert.assertNotNull((String)"Program cannot be null", (Object)this.program);
        boolean commit = false;
        int tx = this.program.startTransaction("Test");
        try {
            callback.call(this.program);
            commit = true;
        }
        catch (Exception e) {
            AbstractProgramBasedTest.failWithException((String)("Exception modifying program '" + this.program.getName() + "'"), (Throwable)e);
        }
        finally {
            this.program.endTransaction(tx, commit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R createInProgram(ExceptionalFunction<Program, R> f) {
        Assert.assertNotNull((String)"Program cannot be null", (Object)this.program);
        R result = null;
        boolean commit = false;
        int tx = this.program.startTransaction("Test");
        try {
            result = f.apply(this.program);
            commit = true;
        }
        catch (Exception e) {
            AbstractProgramBasedTest.failWithException((String)("Exception modifying program '" + this.program.getName() + "'"), (Throwable)e);
        }
        finally {
            this.program.endTransaction(tx, commit);
        }
        return result;
    }

    public static interface ExceptionalFunction<T, R> {
        public R apply(T var1) throws Exception;
    }

    public static interface ExceptionalCallback<T> {
        public void call(T var1) throws Exception;
    }
}

