/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.query.lucene.ExcerptProvider;
import org.apache.jackrabbit.core.query.lucene.HighlightingExcerptProvider;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.ScoreNodeIterator;
import org.apache.jackrabbit.core.query.lucene.SpellSuggestion;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RowIteratorImpl
implements RowIterator {
    private static final Logger log = LoggerFactory.getLogger((Class)RowIteratorImpl.class);
    private static final ValueFactory VALUE_FACTORY = ValueFactoryImpl.getInstance();
    private static final String EXCERPT_FUNC_LPAR = "excerpt(";
    private static final String SPELLCHECK_FUNC_LPAR = "spellcheck(";
    private static final Name REP_EXCERPT_LPAR = NameFactoryImpl.getInstance().create("internal", "excerpt(");
    private final ScoreNodeIterator nodes;
    private final Name[] properties;
    private final List selectorNames = new ArrayList();
    private final ItemManager itemMgr;
    private final NamePathResolver resolver;
    private final ExcerptProvider excerptProvider;
    private final SpellSuggestion spellSuggestion;

    RowIteratorImpl(ScoreNodeIterator nodes, Name[] properties, Name[] selectorNames, ItemManager itemMgr, NamePathResolver resolver, ExcerptProvider exProvider, SpellSuggestion spellSuggestion) {
        this.nodes = nodes;
        this.properties = properties;
        this.selectorNames.addAll(Arrays.asList(selectorNames));
        this.itemMgr = itemMgr;
        this.resolver = resolver;
        this.excerptProvider = exProvider;
        this.spellSuggestion = spellSuggestion;
    }

    public Row nextRow() throws NoSuchElementException {
        return new RowImpl(this.nodes.getScore(), this.nodes.getScoreNodes(), this.nodes.nextNodeImpl());
    }

    public void skip(long skipNum) throws NoSuchElementException {
        this.nodes.skip(skipNum);
    }

    public long getSize() {
        return this.nodes.getSize();
    }

    public long getPosition() {
        return this.nodes.getPosition();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public boolean hasNext() {
        return this.nodes.hasNext();
    }

    public Object next() throws NoSuchElementException {
        return this.nextRow();
    }

    class RowImpl
    implements Row {
        private final float score;
        private final NodeImpl node;
        private final ScoreNode[] sn;
        private Value[] values;
        private Set propertySet;

        RowImpl(float score, ScoreNode[] sn, NodeImpl node) {
            this.score = score;
            this.sn = sn;
            this.node = node;
        }

        public Value[] getValues() throws RepositoryException {
            if (this.values == null) {
                Value[] tmp = new Value[RowIteratorImpl.this.properties.length];
                for (int i = 0; i < RowIteratorImpl.this.properties.length; ++i) {
                    if (this.node.hasProperty(RowIteratorImpl.this.properties[i])) {
                        PropertyImpl prop = this.node.getProperty(RowIteratorImpl.this.properties[i]);
                        if (!prop.getDefinition().isMultiple()) {
                            if (prop.getDefinition().getRequiredType() == 0) {
                                tmp[i] = VALUE_FACTORY.createValue(prop.getString());
                                continue;
                            }
                            tmp[i] = prop.getValue();
                            continue;
                        }
                        tmp[i] = null;
                        continue;
                    }
                    tmp[i] = NameConstants.JCR_PATH.equals(RowIteratorImpl.this.properties[i]) ? VALUE_FACTORY.createValue(this.node.getPath(), 8) : (NameConstants.JCR_SCORE.equals(RowIteratorImpl.this.properties[i]) ? VALUE_FACTORY.createValue((long)Math.round(this.score * 1000.0f)) : (this.isExcerptFunction(RowIteratorImpl.this.properties[i]) ? this.getExcerpt() : (this.isSpellCheckFunction(RowIteratorImpl.this.properties[i]) ? this.getSpellCheckedStatement() : null)));
                }
                this.values = tmp;
            }
            Value[] ret = new Value[this.values.length];
            System.arraycopy(this.values, 0, ret, 0, this.values.length);
            return ret;
        }

        public Value getValue(String propertyName) throws ItemNotFoundException, RepositoryException {
            if (this.propertySet == null) {
                HashSet<Name> tmp = new HashSet<Name>();
                tmp.addAll(Arrays.asList(RowIteratorImpl.this.properties));
                this.propertySet = tmp;
            }
            try {
                Name prop = RowIteratorImpl.this.resolver.getQName(propertyName);
                if (!this.propertySet.contains(prop)) {
                    if (this.isExcerptFunction(propertyName)) {
                        return this.getExcerpt(propertyName);
                    }
                    throw new ItemNotFoundException(propertyName);
                }
                if (this.node.hasProperty(prop)) {
                    PropertyImpl p = this.node.getProperty(prop);
                    if (p.getDefinition().getRequiredType() == 0) {
                        return VALUE_FACTORY.createValue(p.getString());
                    }
                    return p.getValue();
                }
                if (NameConstants.JCR_PATH.equals(prop)) {
                    return VALUE_FACTORY.createValue(this.node.getPath(), 8);
                }
                if (NameConstants.JCR_SCORE.equals(prop)) {
                    return VALUE_FACTORY.createValue((long)Math.round(this.score * 1000.0f));
                }
                if (this.isExcerptFunction(prop)) {
                    return this.getExcerpt();
                }
                if (this.isSpellCheckFunction(prop)) {
                    return this.getSpellCheckedStatement();
                }
                return null;
            }
            catch (NameException e) {
                if (this.isExcerptFunction(propertyName)) {
                    return this.getExcerpt(propertyName);
                }
                throw new RepositoryException(e.getMessage(), (Throwable)((Object)e));
            }
        }

        public Node getNode() throws RepositoryException {
            this.checkSingleSelector("Use getNode(String) instead.");
            return this.node;
        }

        public Node getNode(String selectorName) throws RepositoryException {
            ScoreNode s = this.sn[this.getSelectorIndex(selectorName)];
            if (s == null) {
                return null;
            }
            return (Node)RowIteratorImpl.this.itemMgr.getItem(s.getNodeId());
        }

        public String getPath() throws RepositoryException {
            this.checkSingleSelector("Use getPath(String) instead.");
            return this.node.getPath();
        }

        public String getPath(String selectorName) throws RepositoryException {
            Node n = this.getNode(selectorName);
            if (n != null) {
                return n.getPath();
            }
            return null;
        }

        public double getScore() throws RepositoryException {
            this.checkSingleSelector("Use getScore(String) instead.");
            return this.score;
        }

        public double getScore(String selectorName) throws RepositoryException {
            ScoreNode s = this.sn[this.getSelectorIndex(selectorName)];
            if (s == null) {
                return Double.NaN;
            }
            return s.getScore();
        }

        private void checkSingleSelector(String useInstead) throws RepositoryException {
            if (this.sn.length > 1) {
                String msg = "More than one selector. " + useInstead;
                throw new RepositoryException(msg);
            }
        }

        private int getSelectorIndex(String selectorName) throws RepositoryException {
            int idx = RowIteratorImpl.this.selectorNames.indexOf(RowIteratorImpl.this.resolver.getQName(selectorName));
            if (idx == -1) {
                throw new RepositoryException("Unknown selector name: " + selectorName);
            }
            return idx;
        }

        private boolean isExcerptFunction(Name name) {
            return name.getNamespaceURI().equals("internal") && name.getLocalName().startsWith(RowIteratorImpl.EXCERPT_FUNC_LPAR);
        }

        private boolean isExcerptFunction(String name) {
            try {
                return name.startsWith(RowIteratorImpl.this.resolver.getJCRName(REP_EXCERPT_LPAR));
            }
            catch (NamespaceException e) {
                return false;
            }
        }

        private Value getExcerpt() {
            return this.createExcerpt(this.node.getNodeId());
        }

        private Value getExcerpt(String excerptCall) throws RepositoryException {
            int idx = excerptCall.indexOf(RowIteratorImpl.EXCERPT_FUNC_LPAR);
            int end = excerptCall.lastIndexOf(41);
            if (end == -1) {
                throw new RepositoryException("Missing right parenthesis");
            }
            String pathStr = excerptCall.substring(idx + RowIteratorImpl.EXCERPT_FUNC_LPAR.length(), end).trim();
            String decodedPath = ISO9075.decode(pathStr);
            try {
                NodeImpl n = (NodeImpl)this.node.getNode(decodedPath);
                return this.createExcerpt(n.getNodeId());
            }
            catch (PathNotFoundException e) {
                try {
                    Property p = this.node.getProperty(decodedPath);
                    return this.highlight(p.getValue().getString());
                }
                catch (PathNotFoundException e1) {
                    return null;
                }
            }
        }

        private Value createExcerpt(NodeId id) {
            if (RowIteratorImpl.this.excerptProvider == null) {
                return null;
            }
            try {
                long time = System.currentTimeMillis();
                String excerpt = RowIteratorImpl.this.excerptProvider.getExcerpt(id, 3, 150);
                time = System.currentTimeMillis() - time;
                log.debug("Created excerpt in {} ms.", (Object)new Long(time));
                if (excerpt != null) {
                    return VALUE_FACTORY.createValue(excerpt);
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }

        private Value highlight(String text) {
            if (!(RowIteratorImpl.this.excerptProvider instanceof HighlightingExcerptProvider)) {
                return null;
            }
            HighlightingExcerptProvider hep = (HighlightingExcerptProvider)RowIteratorImpl.this.excerptProvider;
            try {
                long time = System.currentTimeMillis();
                text = hep.highlight(text);
                time = System.currentTimeMillis() - time;
                log.debug("Highlighted text in {} ms.", (Object)new Long(time));
                return VALUE_FACTORY.createValue(text);
            }
            catch (IOException e) {
                return null;
            }
        }

        private boolean isSpellCheckFunction(Name name) {
            return name.getNamespaceURI().equals("internal") && name.getLocalName().startsWith(RowIteratorImpl.SPELLCHECK_FUNC_LPAR);
        }

        private Value getSpellCheckedStatement() {
            String v = null;
            if (RowIteratorImpl.this.spellSuggestion != null) {
                try {
                    v = RowIteratorImpl.this.spellSuggestion.getSuggestion();
                }
                catch (IOException e) {
                    log.warn("Spell checking failed", (Throwable)e);
                }
            }
            if (v != null) {
                return VALUE_FACTORY.createValue(v);
            }
            return null;
        }
    }
}

