/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.server.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.server.io.DefaultHandler;
import org.apache.jackrabbit.server.io.PropertyExportContext;
import org.apache.jackrabbit.server.io.PropertyHandler;
import org.apache.jackrabbit.server.io.PropertyImportContext;
import org.apache.jackrabbit.server.io.PropertyManager;
import org.apache.jackrabbit.server.io.XmlHandler;
import org.apache.jackrabbit.server.io.ZipHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyManagerImpl
implements PropertyManager {
    private static Logger log = LoggerFactory.getLogger((Class)PropertyManagerImpl.class);
    private static PropertyManager DEFAULT_MANAGER;
    private final List propertyHandlers = new ArrayList();

    public boolean exportProperties(PropertyExportContext context, boolean isCollection) throws RepositoryException {
        boolean success = false;
        PropertyHandler[] propertyHandlers = this.getPropertyHandlers();
        for (int i = 0; i < propertyHandlers.length && !success; ++i) {
            PropertyHandler ph = propertyHandlers[i];
            if (!ph.canExport(context, isCollection)) continue;
            success = ph.exportProperties(context, isCollection);
        }
        context.informCompleted(success);
        return success;
    }

    public Map alterProperties(PropertyImportContext context, boolean isCollection) throws RepositoryException {
        boolean foundHandler = false;
        Map failures = new HashMap(0);
        PropertyHandler[] propertyHandlers = this.getPropertyHandlers();
        for (int i = 0; i < propertyHandlers.length && !foundHandler; ++i) {
            PropertyHandler ph = propertyHandlers[i];
            foundHandler = ph.canImport(context, isCollection);
            if (!foundHandler) continue;
            failures = ph.importProperties(context, isCollection);
        }
        if (!foundHandler) {
            throw new RepositoryException("Unable to alter properties: No matching handler found.");
        }
        context.informCompleted(failures.isEmpty());
        return failures;
    }

    public void addPropertyHandler(PropertyHandler propertyHandler) {
        if (propertyHandler == null) {
            throw new IllegalArgumentException("'null' is not a valid IOHandler.");
        }
        this.propertyHandlers.add(propertyHandler);
    }

    public PropertyHandler[] getPropertyHandlers() {
        return this.propertyHandlers.toArray(new PropertyHandler[this.propertyHandlers.size()]);
    }

    public static PropertyManager getDefaultManager() {
        if (DEFAULT_MANAGER == null) {
            DEFAULT_MANAGER = new PropertyManagerImpl();
            DEFAULT_MANAGER.addPropertyHandler(new ZipHandler());
            DEFAULT_MANAGER.addPropertyHandler(new XmlHandler());
            DEFAULT_MANAGER.addPropertyHandler(new DefaultHandler());
        }
        return DEFAULT_MANAGER;
    }
}

