/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.conversion;

import javax.jcr.NamespaceException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.GenerationalCache;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;

public class CachingNameResolver
implements NameResolver {
    private final NameResolver resolver;
    private final GenerationalCache cache;

    public CachingNameResolver(NameResolver resolver, GenerationalCache cache) {
        this.resolver = resolver;
        this.cache = cache;
    }

    public CachingNameResolver(NameResolver resolver) {
        this(resolver, new GenerationalCache());
    }

    public Name getQName(String name) throws IllegalNameException, NamespaceException {
        Name qname = (Name)this.cache.get(name);
        if (qname == null) {
            qname = this.resolver.getQName(name);
            this.cache.put(name, qname);
        }
        return qname;
    }

    public String getJCRName(Name qname) throws NamespaceException {
        String name = (String)this.cache.get(qname);
        if (name == null) {
            name = this.resolver.getJCRName(qname);
            this.cache.put(qname, name);
        }
        return name;
    }
}

