/*
 * Decompiled with CFR 0.152.
 */
package util.demangler;

public final class GenericDemangledConstants {
    public static final String VISIBILITY_public = "public";
    public static final String VISIBILITY_protected = "protected";
    public static final String VISIBILITY_private = "private";
    public static final String VISIBILITY_static = "static";
    public static final String VISIBILITY_global = "global";
    public static final String VISIBILITY_virtual = "virtual";
    public static final String[] VISIBILITY_ARR = new String[]{"public", "protected", "private", "static", "global", "virtual"};
    public static final String STORAGE_CLASS_const = "const";
    public static final String STORAGE_CLASS_volatile = "volatile";
    public static final String STORAGE_CLASS_far = "far";
    public static final String STORAGE_CLASS_restrict = "restrict";
    public static final String[] STORAGE_CLASS_ARR = new String[]{"const", "volatile", "far", "restrict"};

    public static final boolean isVisibility(String visibility) {
        return GenericDemangledConstants.contains(VISIBILITY_ARR, visibility);
    }

    public static final boolean isStorageClass(String storageClass) {
        return GenericDemangledConstants.contains(STORAGE_CLASS_ARR, storageClass);
    }

    private static final boolean contains(String[] array, String target) {
        for (String element : array) {
            if (!element.equals(target)) continue;
            return true;
        }
        return false;
    }
}

