/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data;

import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.app.util.opinion.PeLoader;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;

public abstract class AbstractCreateDataTypeModel {
    protected static final String STRUCT_PREFIX = "_s_";
    protected static String CATEGORY_PATH = "/";
    protected static final String NEW_LINE = "\n";
    protected static final String INDENT = "    ";
    private Program program;
    private int count;
    private Address address;
    private MemBuffer memBuffer;
    private boolean dataTypeAlreadyBasedOnCount = false;
    private boolean isValidAddress;
    private boolean isInitializedAddress;
    private boolean isExecutableAddress;
    private boolean isLoadedAndInitialized;
    private boolean is64Bit;
    private boolean isRelative;
    private int defaultPointerSize;
    private DataTypeManager dataTypeManager;
    protected Address imageBaseAddress;
    private boolean alreadyValidated;
    private boolean isValid;
    private String exceptionMessage;
    protected DataValidationOptions validationOptions;

    public AbstractCreateDataTypeModel(Program program, Address address, DataValidationOptions validationOptions) {
        this(program, 1, address, validationOptions);
    }

    public AbstractCreateDataTypeModel(Program program, int count, Address address, DataValidationOptions validationOptions) {
        this.program = program;
        this.count = count;
        if (address == Address.NO_ADDRESS) {
            throw new IllegalArgumentException("Can't create a " + this.getName() + " exception handling model at NO_ADDRESS.");
        }
        if (address == null) {
            throw new IllegalArgumentException("Null isn't a valid address for creating a " + this.getName() + " exception handling model.");
        }
        this.address = address;
        this.validationOptions = validationOptions;
        this.init();
    }

    private void init() {
        this.is64Bit = MSDataTypeUtils.is64Bit((Program)this.program);
        this.isRelative = AbstractCreateDataTypeModel.isRelative(this.program);
        this.defaultPointerSize = this.program.getDefaultPointerSize();
        Memory memory = this.program.getMemory();
        this.isValidAddress = memory.contains(this.address);
        MemoryBlock block = memory.getBlock(this.address);
        this.isInitializedAddress = block != null ? block.isInitialized() : false;
        this.isExecutableAddress = block != null ? block.isExecute() : false;
        AddressSetView loadedAndInitializedSet = memory.getLoadedAndInitializedAddressSet();
        this.isLoadedAndInitialized = loadedAndInitializedSet.contains(this.address);
        this.memBuffer = new DumbMemBufferImpl(memory, this.address);
        this.dataTypeManager = this.program.getDataTypeManager();
        this.imageBaseAddress = this.getProgram().getImageBase();
    }

    protected final boolean isWindows() {
        CompilerSpecID compilerSpecID = this.program.getCompilerSpec().getCompilerSpecID();
        return compilerSpecID.getIdAsString().equals("windows") && this.program.getExecutableFormat().equals("Portable Executable (PE)") && this.program.getCompiler().equals(PeLoader.CompilerOpinion.CompilerEnum.VisualStudio.toString());
    }

    protected final boolean isValidAddress() {
        return this.isValidAddress;
    }

    protected final boolean isInitializedAddress() {
        return this.isInitializedAddress;
    }

    protected final boolean isExecutableAddress() {
        return this.isExecutableAddress;
    }

    public final boolean isLoadedAndInitializedAddress() {
        return this.isLoadedAndInitialized;
    }

    protected final boolean is64Bit() {
        return this.is64Bit;
    }

    protected static boolean isRelative(Program program) {
        return MSDataTypeUtils.is64Bit((Program)program);
    }

    protected final boolean isRelative() {
        return this.isRelative;
    }

    protected final int getDefaultPointerSize() {
        return this.defaultPointerSize;
    }

    protected final DataTypeManager getDataTypeManager() {
        return this.dataTypeManager;
    }

    protected final MemBuffer getMemBuffer() {
        return this.memBuffer;
    }

    protected abstract int getDataTypeLength();

    protected boolean fitsInSingleMemoryBlock() {
        int dataTypeLength = this.getDataTypeLength();
        if (dataTypeLength < 0) {
            return false;
        }
        try {
            long totalSize = dataTypeLength * this.count;
            Address start = this.getAddress();
            Address end = start.add(totalSize - 1L);
            Memory memory = this.getProgram().getMemory();
            MemoryBlock startBlock = memory.getBlock(start);
            return startBlock != null && startBlock.contains(end);
        }
        catch (AddressOutOfBoundsException e) {
            return false;
        }
    }

    protected int getAlignment() {
        DataType dt = this.getDataType();
        if (dt != null) {
            return dt.getAlignment();
        }
        return 4;
    }

    public void validate() throws InvalidDataTypeException {
        if (this.alreadyValidated) {
            if (this.exceptionMessage != null) {
                throw new InvalidDataTypeException(this.exceptionMessage);
            }
            return;
        }
        try {
            this.alreadyValidated = true;
            this.isValid = true;
            this.doValidate();
            this.validateModelSpecificInfo();
        }
        catch (InvalidDataTypeException e) {
            this.isValid = false;
            this.exceptionMessage = e.getMessage();
            throw e;
        }
    }

    protected abstract void validateModelSpecificInfo() throws InvalidDataTypeException;

    private void doValidate() throws InvalidDataTypeException {
        if (!this.isWindows()) {
            throw new InvalidDataTypeException(this.getName() + " data type model is only valid for Visual Studio windows PE.");
        }
        if (!this.isValidAddress()) {
            throw new InvalidDataTypeException(this.getName() + " data type isn't at a valid address " + this.getAddress() + ".");
        }
        if (!this.isLoadedAndInitializedAddress()) {
            throw new InvalidDataTypeException(this.getName() + " data type isn't on a loaded and initialized address " + this.getAddress() + ".");
        }
        this.checkDataType();
        if (!this.fitsInSingleMemoryBlock()) {
            throw new InvalidDataTypeException(this.getName() + " data type doesn't fit in a single memory block when placed at " + this.getAddress() + ".");
        }
        if (this.getAddress().getOffset() % (long)this.getAlignment() != 0L) {
            throw new InvalidDataTypeException(this.getName() + " data type is not properly aligned at " + this.getAddress() + ".");
        }
        Listing listing = this.program.getListing();
        Address startAddress = this.address;
        int dtLength = this.getDataTypeLength();
        long numBytes = dtLength * this.count;
        if (numBytes <= 0L) {
            throw new InvalidDataTypeException("Cannot determine length for " + this.getName() + " data type at " + this.getAddress() + ".");
        }
        Address endAddress = this.address.add(numBytes - 1L);
        if (!this.getValidationOptions().shouldIgnoreInstructions() && this.containsInstruction(listing, startAddress, endAddress)) {
            throw new InvalidDataTypeException("Instructions are in the way of " + this.count + " " + this.getName() + " data type(s) at " + this.getAddress() + ".");
        }
        if (!this.getValidationOptions().shouldIgnoreDefinedData() && this.containsDefinedData(listing, startAddress, endAddress)) {
            throw new InvalidDataTypeException("Defined data is in the way of " + this.count + " " + this.getName() + " data type(s) at " + this.getAddress() + ".");
        }
    }

    protected void checkDataType() throws InvalidDataTypeException {
    }

    protected void checkValidity() throws InvalidDataTypeException {
        if (!this.isValid()) {
            throw new InvalidDataTypeException(this.getName() + " data type isn't valid at " + this.getAddress() + " in " + this.getProgram() + ".");
        }
    }

    protected void checkValidity(int ordinal) throws InvalidDataTypeException {
        this.checkValidity();
        if (ordinal < 0 || ordinal >= this.getCount()) {
            throw new IllegalArgumentException(ordinal + " is not a valid ordinal for " + this.getName() + " data type at " + this.getAddress() + " in " + this.getProgram() + ".");
        }
    }

    private boolean isValid() {
        if (!this.alreadyValidated) {
            try {
                this.validate();
            }
            catch (InvalidDataTypeException e) {
                return false;
            }
        }
        return this.isValid;
    }

    public final Program getProgram() {
        return this.program;
    }

    public final int getCount() {
        return this.count;
    }

    public final Address getAddress() {
        return this.address;
    }

    protected Address getAdjustedAddress(Address mapAddress, int numEntries) {
        if (mapAddress == null) {
            return null;
        }
        if (numEntries == 0 && (this.isRelative ? mapAddress.equals((Object)this.imageBaseAddress) : mapAddress.getOffset() == 0L)) {
            return null;
        }
        return mapAddress;
    }

    Address getEndAddress() throws InvalidDataTypeException {
        int dtLength = this.getDataTypeLength();
        if (dtLength == 0) {
            throw new InvalidDataTypeException("Couldn't determine data type length for " + this.getName() + ".");
        }
        try {
            return this.address.add((long)(dtLength - 1));
        }
        catch (AddressOutOfBoundsException e) {
            throw new InvalidDataTypeException(this.getName() + " data type doesn't fit in memory at " + this.getAddress() + ".");
        }
    }

    public abstract String getName();

    public abstract DataType getDataType();

    protected boolean isValidMap(int numEntries, Address mapAddress) {
        if (numEntries == 0) {
            if (mapAddress == null) {
                return true;
            }
            if (this.isRelative) {
                return this.imageBaseAddress.equals((Object)mapAddress);
            }
            return false;
        }
        if (mapAddress == null) {
            return false;
        }
        Memory memory = this.getProgram().getMemory();
        return memory.getLoadedAndInitializedAddressSet().contains(mapAddress);
    }

    public boolean isBlockedByInstructions() throws InvalidDataTypeException {
        Address start = this.getAddress();
        Address end = this.getEndAddress();
        AddressSet addrSet = new AddressSet(start, end);
        Listing listing = this.program.getListing();
        Instruction inst = listing.getInstructionContaining(start);
        if (inst != null) {
            return true;
        }
        InstructionIterator instIter = listing.getInstructions((AddressSetView)addrSet, true);
        return instIter.hasNext();
    }

    protected MemBuffer getSpecificMemBuffer(int ordinal, DataType dt) {
        int size = dt.getLength();
        MemBuffer baseMemBuffer = this.getMemBuffer();
        long offset = size * ordinal;
        Address specificAddress = baseMemBuffer.getAddress().add(offset);
        DumbMemBufferImpl specificMemBuffer = new DumbMemBufferImpl(this.getProgram().getMemory(), specificAddress);
        return specificMemBuffer;
    }

    public void checkEntryCount(String countType, int actualCount, int maxValidCount) throws InvalidDataTypeException {
        this.checkNonNegative(countType, actualCount);
        this.checkAgainstMaxCount(countType, actualCount, maxValidCount);
    }

    public void checkNonNegative(String countType, int actualCount) throws InvalidDataTypeException {
        if (actualCount < 0) {
            throw new InvalidDataTypeException(this.getName() + " data type at " + this.getAddress() + " has a " + countType + " count of " + actualCount + ", which seems incorrect.");
        }
    }

    public void checkAgainstMaxCount(String countType, int actualCount, int maxValidCount) throws InvalidDataTypeException {
        if (actualCount > maxValidCount) {
            throw new InvalidDataTypeException(this.getName() + " data type at " + this.getAddress() + " has a " + countType + " count of " + actualCount + ", which exceeds the expected maximum of " + maxValidCount + ".");
        }
    }

    boolean containsDefinedData(Listing listing, Address startAddress, Address endAddress) {
        Data data = listing.getDefinedDataContaining(startAddress);
        if (data != null) {
            return true;
        }
        data = listing.getDefinedDataAfter(startAddress);
        return data != null && data.getMinAddress().compareTo((Object)endAddress) <= 0;
    }

    boolean containsInstruction(Listing listing, Address startAddress, Address endAddress) {
        Instruction instruction = listing.getInstructionContaining(startAddress);
        if (instruction != null) {
            return true;
        }
        instruction = listing.getInstructionAfter(startAddress);
        return instruction != null && instruction.getMinAddress().compareTo((Object)endAddress) <= 0;
    }

    protected DataValidationOptions getValidationOptions() {
        return this.validationOptions;
    }

    protected final DataOrganization getDataOrganization() {
        return this.dataTypeManager.getDataOrganization();
    }

    public boolean isDataTypeAlreadyBasedOnCount() {
        return this.dataTypeAlreadyBasedOnCount;
    }

    protected void setIsDataTypeAlreadyBasedOnCount(boolean dataTypeAlreadyBasedOnCount) {
        this.dataTypeAlreadyBasedOnCount = dataTypeAlreadyBasedOnCount;
    }

    protected final String getDefaultInvalidMessage() {
        return this.getName() + " data type at " + this.getAddress() + " isn't valid.";
    }

    protected void invalid() throws InvalidDataTypeException {
        throw new InvalidDataTypeException(this.getDefaultInvalidMessage());
    }

    protected void invalid(Exception e) throws InvalidDataTypeException {
        Object message = this.getDefaultInvalidMessage();
        String excMessage = e.getMessage();
        if (excMessage != null && !excMessage.isEmpty()) {
            message = (String)message + " " + excMessage;
        }
        throw new InvalidDataTypeException((String)message);
    }

    protected void invalid(String suffixMessage) throws InvalidDataTypeException {
        Object message = this.getDefaultInvalidMessage();
        if (suffixMessage != null && !suffixMessage.isEmpty()) {
            message = (String)message + " " + suffixMessage;
        }
        throw new InvalidDataTypeException((String)message);
    }
}

