/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.shape;

import edu.uci.ics.jung.visualization.decorators.ParallelEdgeShapeTransformer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ArticulatedEdgeTransformer<V extends VisualVertex, E extends VisualEdge<V>>
extends ParallelEdgeShapeTransformer<V, E> {
    protected static final int OVERLAPPING_EDGE_OFFSET = 10;

    public int getOverlapOffset(E edge) {
        return 10;
    }

    public Shape apply(E e) {
        VisualVertex end;
        VisualVertex start = (VisualVertex)e.getStart();
        boolean isLoop = start.equals(end = (VisualVertex)e.getEnd());
        if (isLoop) {
            return GraphViewerUtils.createHollowEgdeLoop();
        }
        Point2D p1 = start.getLocation();
        if (p1 == null) {
            this.logMissingLocation(e, start);
            return null;
        }
        Point2D p2 = end.getLocation();
        if (p2 == null) {
            this.logMissingLocation(e, end);
            return null;
        }
        List<Point2D> articulations = e.getArticulationPoints();
        double originX = p1.getX();
        double originY = p1.getY();
        int offset = this.getOverlapOffset(e);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        for (Point2D point2D : articulations) {
            generalPath.lineTo((float)(point2D.getX() - originX) + (float)offset, (float)(point2D.getY() - originY) + (float)offset);
        }
        generalPath.lineTo((float)(p2.getX() - originX), (float)(p2.getY() - originY));
        ArrayList<Point2D> reverse = new ArrayList<Point2D>(articulations);
        Collections.reverse(reverse);
        for (Point2D pt : reverse) {
            generalPath.lineTo((float)(pt.getX() - originX) + (float)offset, (float)(pt.getY() - originY) + (float)offset);
        }
        AffineTransform affineTransform = new AffineTransform();
        double deltaY = p2.getY() - originY;
        double deltaX = p2.getX() - originX;
        if (deltaX == 0.0 && deltaY == 0.0) {
            return affineTransform.createTransformedShape(generalPath);
        }
        double theta = StrictMath.atan2(deltaY, deltaX);
        affineTransform.rotate(theta);
        double scale = StrictMath.sqrt(deltaY * deltaY + deltaX * deltaX);
        affineTransform.scale(scale, 1.0);
        try {
            AffineTransform inverse = affineTransform.createInverse();
            Shape transformedShape = inverse.createTransformedShape(generalPath);
            return transformedShape;
        }
        catch (NoninvertibleTransformException e1) {
            Msg.error((Object)((Object)this), (Object)"Unexpected exception transforming an edge", (Throwable)e1);
            return null;
        }
    }

    private void logMissingLocation(E e, V v) {
        boolean isStart = e.getStart() == v;
        String type = isStart ? "start" : "end";
        Msg.debug((Object)((Object)this), (Object)("no location defined for " + type + " vertex: " + v + " " + System.identityHashCode(v)));
        if (SystemUtilities.isInTestingMode()) {
            throw new IllegalStateException("Edge vertex is missing a location");
        }
    }
}

