/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.list;

import com.jeta.forms.store.properties.ListItemProperty;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class ListItemRenderer
extends JLabel
implements ListCellRenderer {
    private Color m_sel_bg;
    private Color m_sel_fg;
    private Color m_bg;
    private Color m_fg;
    private LookAndFeel m_laf;

    public ListItemRenderer() {
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel != this.m_laf) {
            this.m_laf = lookAndFeel;
            this.updateColorCache();
        }
        if (bl) {
            this.setBackground(this.m_sel_bg);
            this.setForeground(this.m_sel_fg);
        } else {
            this.setBackground(this.m_bg);
            this.setForeground(this.m_fg);
        }
        if (object instanceof ListItemProperty) {
            ListItemProperty listItemProperty = (ListItemProperty)object;
            this.setIcon(listItemProperty.icon());
            String string = listItemProperty.getLabel();
            if (string == null) {
                string = "";
            }
            this.setText(string);
        } else {
            if (object == null) {
                object = "";
            }
            this.setText(object.toString());
        }
        return this;
    }

    private void updateColorCache() {
        this.m_sel_fg = UIManager.getColor("List.selectionForeground");
        this.m_sel_bg = UIManager.getColor("List.selectionBackground");
        this.m_bg = UIManager.getColor("List.background");
        this.m_fg = UIManager.getColor("List.foreground");
        this.setOpaque(true);
    }
}

