/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.Option;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MemoryConflictHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractLibrarySupportLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.file.formats.android.dex.format.ClassDataItem;
import ghidra.file.formats.android.dex.format.ClassDefItem;
import ghidra.file.formats.android.dex.format.CodeItem;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.format.EncodedMethod;
import ghidra.file.formats.android.dex.util.DexUtil;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DexLoader
extends AbstractLibrarySupportLoader {
    public String getName() {
        return "Dalvik Executable (DEX)";
    }

    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        BinaryReader reader = new BinaryReader(provider, true);
        try {
            DexHeader header = new DexHeader(reader);
            if ("dex\n".equals(new String(header.getMagic()))) {
                List queries = QueryOpinionService.query((String)this.getName(), (String)"1", null);
                for (QueryResult result : queries) {
                    loadSpecs.add(new LoadSpec((Loader)this, 0L, result));
                }
                if (loadSpecs.isEmpty()) {
                    loadSpecs.add(new LoadSpec((Loader)this, 0L, true));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return loadSpecs;
    }

    public void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, MemoryConflictHandler handler, TaskMonitor monitor, MessageLog log) throws IOException {
        monitor.setMessage("DEX Loader: creating dex memory");
        try {
            Address start = program.getAddressFactory().getDefaultAddressSpace().getAddress(0L);
            long length = provider.length();
            try (InputStream inputStream = provider.getInputStream(0L);){
                program.getMemory().createInitializedBlock(".dex", start, inputStream, length, monitor, false);
            }
            BinaryReader reader = new BinaryReader(provider, true);
            DexHeader header = new DexHeader(reader);
            monitor.setMessage("DEX Loader: creating method byte code");
            this.createMethodLookupMemoryBlock(program, monitor);
            this.createMethodByteCodeBlock(program, length, monitor);
            for (ClassDefItem item : header.getClassDefs()) {
                monitor.checkCanceled();
                ClassDataItem classDataItem = item.getClassDataItem();
                if (classDataItem == null) continue;
                this.createMethods(program, header, item, classDataItem.getDirectMethods(), monitor, log);
                this.createMethods(program, header, item, classDataItem.getVirtualMethods(), monitor, log);
            }
        }
        catch (Exception e) {
            log.appendException((Throwable)e);
        }
    }

    private void createMethodByteCodeBlock(Program program, long length, TaskMonitor monitor) throws Exception {
        Address address = this.toAddr(program, 0x50000000L);
        MemoryBlock block = program.getMemory().createInitializedBlock("method_bytecode", address, length, (byte)-1, monitor, false);
        block.setRead(true);
        block.setWrite(false);
        block.setExecute(true);
    }

    private void createMethodLookupMemoryBlock(Program program, TaskMonitor monitor) throws Exception {
        Address address = this.toAddr(program, -536870912L);
        MemoryBlock block = program.getMemory().createInitializedBlock("method_lookup", address, DexUtil.MAX_METHOD_LENGTH, (byte)-1, monitor, false);
        block.setRead(true);
        block.setWrite(false);
        block.setExecute(false);
    }

    private void createMethods(Program program, DexHeader header, ClassDefItem item, List<EncodedMethod> methods, TaskMonitor monitor, MessageLog log) throws Exception {
        for (int i = 0; i < methods.size(); ++i) {
            monitor.checkCanceled();
            EncodedMethod encodedMethod = methods.get(i);
            CodeItem codeItem = encodedMethod.getCodeItem();
            Address methodIndexAddress = DexUtil.toLookupAddress(program, encodedMethod.getMethodIndex());
            if (codeItem == null) continue;
            Address methodAddress = this.toAddr(program, 0x50000000L + (long)encodedMethod.getCodeOffset());
            byte[] instructionBytes = codeItem.getInstructionBytes();
            program.getMemory().setBytes(methodAddress, instructionBytes);
            program.getMemory().setInt(methodIndexAddress, (int)methodAddress.getOffset());
        }
    }

    private Address toAddr(Program program, long offset) {
        return program.getAddressFactory().getDefaultAddressSpace().getAddress(offset);
    }
}

