/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.dex.format.DebugInfoItem;
import ghidra.file.formats.android.dex.format.EncodedCatchHandlerList;
import ghidra.file.formats.android.dex.format.TryItem;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CodeItem
implements StructConverter {
    private short registersSize;
    private short incomingSize;
    private short outgoingSize;
    private short triesSize;
    private int debugInfoOffset;
    private int instructionSize;
    private short[] instructions;
    private byte[] instructionBytes;
    private short padding;
    private List<TryItem> tries = new ArrayList<TryItem>();
    private EncodedCatchHandlerList handlers;
    private DebugInfoItem debugInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeItem(BinaryReader reader) throws IOException {
        this.registersSize = reader.readNextShort();
        this.incomingSize = reader.readNextShort();
        this.outgoingSize = reader.readNextShort();
        this.triesSize = reader.readNextShort();
        this.debugInfoOffset = reader.readNextInt();
        this.instructionSize = reader.readNextInt();
        if (this.instructionSize == 0) {
            this.instructionBytes = new byte[0];
            this.instructions = new short[0];
        } else {
            this.instructionBytes = reader.readByteArray(reader.getPointerIndex(), this.instructionSize * 2);
            this.instructions = reader.readNextShortArray(this.instructionSize);
        }
        if (this.hasPadding()) {
            this.padding = reader.readNextShort();
        }
        for (int i = 0; i < this.triesSize; ++i) {
            this.tries.add(new TryItem(reader));
        }
        if (this.triesSize > 0) {
            this.handlers = new EncodedCatchHandlerList(reader);
        }
        if (this.debugInfoOffset > 0) {
            long oldIndex = reader.getPointerIndex();
            try {
                reader.setPointerIndex(this.debugInfoOffset);
                this.debugInfo = new DebugInfoItem(reader);
            }
            finally {
                reader.setPointerIndex(oldIndex);
            }
        }
    }

    public short getRegistersSize() {
        return this.registersSize;
    }

    public short getIncomingSize() {
        return this.incomingSize;
    }

    public short getOutgoingSize() {
        return this.outgoingSize;
    }

    public short getTriesSize() {
        return this.triesSize;
    }

    public int getDebugInfoOffset() {
        return this.debugInfoOffset;
    }

    public int getInstructionSize() {
        return this.instructionSize;
    }

    public short[] getInstructions() {
        return this.instructions;
    }

    public byte[] getInstructionBytes() {
        return this.instructionBytes;
    }

    public short getPadding() {
        return this.padding;
    }

    public List<TryItem> getTries() {
        return Collections.unmodifiableList(this.tries);
    }

    public EncodedCatchHandlerList getHandlerList() {
        return this.handlers;
    }

    public DebugInfoItem getDebugInfo() {
        return this.debugInfo;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String suffix = this.hasPadding() ? "_p" : "";
        String name = "code_item_" + this.instructionSize * 2 + suffix;
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add(WORD, "registers_size", null);
        structure.add(WORD, "ins_size", null);
        structure.add(WORD, "outs_size", null);
        structure.add(WORD, "tries_size", null);
        structure.add(DWORD, "debug_info_off", null);
        structure.add(DWORD, "insns_size", null);
        structure.add((DataType)new ArrayDataType(WORD, this.instructionSize, WORD.getLength()), "insns", null);
        if (this.hasPadding()) {
            structure.add(WORD, "padding", null);
        }
        structure.setCategoryPath(new CategoryPath("/dex/code_item"));
        return structure;
    }

    private boolean hasPadding() {
        return this.instructionSize % 2 != 0;
    }
}

