/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.dex.format.AnnotationElement;
import ghidra.file.formats.android.dex.util.Leb128;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EncodedAnnotation
implements StructConverter {
    private int typeIndex;
    private int typeIndexLength;
    private int size;
    private int sizeLength;
    private List<AnnotationElement> elements = new ArrayList<AnnotationElement>();

    public EncodedAnnotation(BinaryReader reader) throws IOException {
        this.typeIndex = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
        this.typeIndexLength = Leb128.unsignedLeb128Size(this.typeIndex);
        reader.readNextByteArray(this.typeIndexLength);
        this.size = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
        this.sizeLength = Leb128.unsignedLeb128Size(this.size);
        reader.readNextByteArray(this.sizeLength);
        for (int i = 0; i < this.size; ++i) {
            this.elements.add(new AnnotationElement(reader));
        }
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public int getSize() {
        return this.size;
    }

    public List<AnnotationElement> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("encoded_annotation_");
        builder.append(this.typeIndexLength + "_");
        builder.append(this.sizeLength + "_");
        builder.append(this.elements.size() + "_");
        StructureDataType structure = new StructureDataType(builder.toString(), 0);
        structure.add((DataType)new ArrayDataType(BYTE, this.typeIndexLength, BYTE.getLength()), "typeIndex", null);
        structure.add((DataType)new ArrayDataType(BYTE, this.sizeLength, BYTE.getLength()), "size", null);
        int index = 0;
        for (AnnotationElement element : this.elements) {
            DataType dataType = element.toDataType();
            structure.add(dataType, "element" + index, null);
            ++index;
            builder.append(dataType.getName());
        }
        structure.setCategoryPath(new CategoryPath("/dex/encoded_annotation"));
        try {
            structure.setName(builder.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return structure;
    }
}

