/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dyldcache;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.file.formats.ios.dyldcache.DyldArchitecture;
import ghidra.file.formats.ios.dyldcache.DyldCacheData;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DyldCacheHeader
implements StructConverter {
    private byte[] version;
    private int baseAddressOffset;
    private int unknown;
    private int startAddress;
    private int libraryCount;
    private long dyldAddress;
    private BinaryReader _reader;
    private long _baseAddress;
    private List<DyldCacheData> _list = new ArrayList<DyldCacheData>();
    private DyldArchitecture _architecture;

    public DyldCacheHeader(BinaryReader reader) throws IOException {
        this._reader = reader;
        this.version = reader.readNextByteArray(16);
        this.baseAddressOffset = reader.readNextInt();
        this.unknown = reader.readNextInt();
        this.startAddress = reader.readNextInt();
        this.libraryCount = reader.readNextInt();
        this.dyldAddress = reader.readNextLong();
        this._baseAddress = reader.readLong((long)this.baseAddressOffset & 0xFFFFFFFFL);
        this._architecture = DyldArchitecture.getArchitecture(new String(this.version).trim());
    }

    public void parse(TaskMonitor monitor) throws IOException {
        this._reader.setPointerIndex(this.startAddress);
        for (int i = 0; i < this.libraryCount && !monitor.isCancelled(); ++i) {
            DyldCacheData data = new DyldCacheData(this._reader);
            this._list.add(data);
        }
    }

    public byte[] getVersion() {
        return this.version;
    }

    public int getBaseAddressOffset() {
        return this.baseAddressOffset;
    }

    public long getBaseAddress() {
        return this._baseAddress;
    }

    public int getUnknown() {
        return this.unknown;
    }

    public int getStartAddress() {
        return this.startAddress;
    }

    public int getLibraryCount() {
        return this.libraryCount;
    }

    public long getDyldAddress() {
        return this.dyldAddress;
    }

    public List<DyldCacheData> getDataList() {
        return this._list;
    }

    public DyldArchitecture getArchitecture() {
        return this._architecture;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType((Object)this);
    }
}

