/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.java;

import ghidra.file.formats.java.JavaClassDecompilerFileSystemFactory;
import ghidra.file.jad.JadProcessController;
import ghidra.file.jad.JadProcessWrapper;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileCacheEntry;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.SingleFileSystemIndexHelper;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import utilities.util.FileUtilities;

@FileSystemInfo(type="javaclass", description="Java Class Decompiler", factory=JavaClassDecompilerFileSystemFactory.class, priority=-10)
public class JavaClassDecompilerFileSystem
implements GFileSystem {
    private FSRLRoot fsFSRL;
    private FileSystemRefManager refManager = new FileSystemRefManager((GFileSystem)this);
    private SingleFileSystemIndexHelper fsIndexHelper;
    private FSRL containerFSRL;
    private String className;
    private String javaSrcFilename;
    private FileSystemService fsService;

    public JavaClassDecompilerFileSystem(FSRLRoot fsFSRL, FileSystemService fsService, TaskMonitor monitor) throws CancelledException, IOException {
        this.fsService = fsService;
        this.fsFSRL = fsFSRL;
        this.containerFSRL = fsFSRL.getContainer();
        this.className = FilenameUtils.removeExtension((String)this.containerFSRL.getName());
        this.javaSrcFilename = this.className + ".java";
        FileCacheEntry fce = this.getDecompiledJavaSrcFileEntry(monitor);
        this.fsIndexHelper = new SingleFileSystemIndexHelper((GFileSystem)this, fsFSRL, this.javaSrcFilename, fce.file.length(), fce.md5);
    }

    private FileCacheEntry getDecompiledJavaSrcFileEntry(TaskMonitor monitor) throws CancelledException, IOException {
        FileCacheEntry derivedFileInfo = this.fsService.getDerivedFilePush(this.containerFSRL, this.javaSrcFilename, os -> {
            File tempDir = null;
            try {
                tempDir = FileUtilities.createTempDirectory((String)"JavaClassDecompilerFileSystem");
                File srcClassFile = this.fsService.getFile(this.containerFSRL, monitor);
                File tempClassFile = new File(tempDir, this.containerFSRL.getName());
                FileUtilities.copyFile((File)srcClassFile, (File)tempClassFile, (boolean)false, (TaskMonitor)monitor);
                File tempDestJavaSrcFile = new File(tempDir, this.javaSrcFilename);
                JadProcessWrapper wrapper = new JadProcessWrapper(tempClassFile);
                JadProcessController controller = new JadProcessController(wrapper, this.className);
                controller.decompile(5, monitor);
                FileUtilities.copyFileToStream((File)tempDestJavaSrcFile, (OutputStream)os, (TaskMonitor)monitor);
            }
            finally {
                FileUtilities.deleteDir((File)tempDir, (TaskMonitor)monitor);
            }
        }, monitor);
        return derivedFileInfo;
    }

    public GFile getPayloadFile() {
        return this.fsIndexHelper.getPayloadFile();
    }

    public String getName() {
        return this.containerFSRL.getName();
    }

    public void close() throws IOException {
        this.refManager.onClose();
        this.fsIndexHelper.clear();
    }

    public boolean isClosed() {
        return this.fsIndexHelper.isClosed();
    }

    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    public int getFileCount() {
        return this.fsIndexHelper.getFileCount();
    }

    public GFile lookup(String path) throws IOException {
        return this.fsIndexHelper.lookup(path);
    }

    public InputStream getInputStream(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        if (this.fsIndexHelper.getPayloadFile().equals(file)) {
            FileCacheEntry fce = this.getDecompiledJavaSrcFileEntry(monitor);
            return new FileInputStream(fce.file);
        }
        return null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return this.fsIndexHelper.getListing(directory);
    }

    public String getInfo(GFile file, TaskMonitor monitor) throws IOException {
        if (this.fsIndexHelper.getPayloadFile().equals(file)) {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("Class name", this.className);
            return FSUtilities.infoMapToString(info);
        }
        return null;
    }

    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }
}

