/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.matchtable.VTMatchContext;
import ghidra.feature.vt.gui.task.ApplyBlockedMatchTask;
import ghidra.util.HelpLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import resources.Icons;

public class ApplyBlockedMatchAction
extends DockingAction {
    public static String NAME = "Apply Blocked Match";
    private static final String MENU_GROUP = "A_VT_Edit_1";
    private final VTController controller;

    public ApplyBlockedMatchAction(VTController controller) {
        super(NAME, VTPlugin.OWNER);
        this.controller = controller;
        this.setPopupMenuData(new MenuData(new String[]{"Apply Blocked Match"}, (Icon)Icons.APPLY_BLOCKED_MATCH_ICON, MENU_GROUP));
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Apply_Blocked_Match"));
    }

    public void actionPerformed(ActionContext context) {
        VTMatchContext matchContext = (VTMatchContext)context;
        List<VTMatch> matches = matchContext.getSelectedMatches();
        if (matches.size() != 1) {
            return;
        }
        VTMatch match = matches.get(0);
        VTAssociation association = match.getAssociation();
        VTAssociationStatus status = association.getStatus();
        if (status != VTAssociationStatus.BLOCKED) {
            return;
        }
        List<VTAssociation> conflicts = this.getConflictingMatches(match);
        String conflictMessage = this.getConflictingMatchesDisplayString(match, conflicts);
        int response = OptionDialog.showOptionDialog(null, (String)"Clear Conflicting Matches and Apply?", (String)conflictMessage, (String)"Clear and Apply", (int)3);
        if (response == 1) {
            ApplyBlockedMatchTask task = new ApplyBlockedMatchTask(this.controller, match, conflicts);
            this.controller.runVTTask(task);
        }
    }

    private List<VTAssociation> getConflictingMatches(VTMatch match) {
        ArrayList<VTAssociation> list = new ArrayList<VTAssociation>();
        VTAssociation association = match.getAssociation();
        Collection<VTAssociation> relatedAssociations = association.getRelatedAssociations();
        for (VTAssociation relatedAssociation : relatedAssociations) {
            if (relatedAssociation.getStatus() != VTAssociationStatus.ACCEPTED) continue;
            list.add(relatedAssociation);
        }
        return list;
    }

    private String getConflictingMatchesDisplayString(VTMatch match, List<VTAssociation> conflicts) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        int count = 0;
        for (VTAssociation conflictingAssociation : conflicts) {
            if (conflictingAssociation.getStatus() != VTAssociationStatus.ACCEPTED) continue;
            buffer.append("    Conflicting ");
            buffer.append(this.getAssociationDisplayString(conflictingAssociation));
            buffer.append(".<br>");
            ++count;
        }
        buffer.append(" <br>");
        buffer.append("Do you want to clear the conflicting accepted match");
        if (count > 1) {
            buffer.append("es");
        }
        buffer.append(" and all ");
        buffer.append(count > 1 ? "their" : "its");
        buffer.append(" applied markup items<br>");
        buffer.append("and then apply the ");
        buffer.append(this.getAssociationDisplayString(match.getAssociation()));
        buffer.append(".");
        buffer.append("</html>");
        return buffer.toString();
    }

    private String getAssociationDisplayString(VTAssociation association) {
        return association.getType().toString() + " match with source of <b>" + association.getSourceAddress().toString() + "</b> and destination of <b>" + association.getDestinationAddress().toString() + "</b>";
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof VTMatchContext)) {
            return false;
        }
        VTMatchContext matchContext = (VTMatchContext)context;
        List<VTMatch> matches = matchContext.getSelectedMatches();
        if (matches.size() != 1) {
            return false;
        }
        VTMatch match = matches.get(0);
        VTAssociation association = match.getAssociation();
        VTAssociationStatus status = association.getStatus();
        return status == VTAssociationStatus.BLOCKED;
    }

    public boolean isAddToPopup(ActionContext context) {
        return true;
    }
}

