/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.DBHandle;
import db.DbLargeTableModel;
import db.DbSmallTableModel;
import db.Table;
import db.TableStatistics;
import db.buffers.BufferFile;
import db.buffers.LocalBufferFile;
import docking.framework.DockingApplicationConfiguration;
import docking.framework.DockingApplicationLayout;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.store.db.PackedDatabase;
import ghidra.util.Msg;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.layout.PairLayout;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.TableModel;
import utility.application.ApplicationLayout;

public class DbViewer
extends JFrame {
    private GhidraFileChooser fileChooser;
    private File dbFile;
    private DBHandle dbh;
    private JMenuItem openItem;
    private JMenuItem closeItem;
    private JPanel mainPanel;
    private JPanel southPanel;
    private JComboBox<String> combo;
    private Table[] tables;
    private Hashtable<String, TableStatistics[]> tableStats = new Hashtable();

    DbViewer() {
        super("Database Viewer");
        this.setDefaultCloseOperation(3);
        this.buildGui();
    }

    void buildGui() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        this.openItem = new JMenuItem("Open Database...");
        menu.add(this.openItem);
        this.openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DbViewer.this.openDb();
            }
        });
        this.closeItem = new JMenuItem("Close Database");
        menu.add(this.closeItem);
        this.closeItem.setEnabled(false);
        this.closeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DbViewer.this.closeDb();
            }
        });
        JMenuItem exitItem = new JMenuItem("Exit");
        menu.add(exitItem);
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.setJMenuBar(menuBar);
    }

    private void openDb() {
        File selectedFile;
        if (this.fileChooser == null) {
            this.fileChooser = new GhidraFileChooser((Component)this);
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setFileFilter((GhidraFileFilter)new ExtensionFileFilter("gbf", "Ghidra Buffer File"));
            this.fileChooser.setCurrentDirectory(new File("C:\\"));
        }
        if ((selectedFile = this.fileChooser.getSelectedFile(true)) == null) {
            return;
        }
        if (this.dbh != null) {
            this.closeDb();
        }
        Msg.debug((Object)this, (Object)("Buffer file = " + selectedFile.getName()));
        this.tables = new Table[0];
        try {
            this.dbFile = selectedFile;
            LocalBufferFile bf = new LocalBufferFile(selectedFile, true);
            this.dbh = new DBHandle((BufferFile)bf);
            this.tables = this.dbh.getTables();
            Arrays.sort(this.tables, new TableNameComparator());
        }
        catch (IOException e) {
            try {
                PackedDatabase pdb = PackedDatabase.getPackedDatabase((File)selectedFile, (TaskMonitor)TaskMonitorAdapter.DUMMY_MONITOR);
                this.dbh = pdb.open(TaskMonitorAdapter.DUMMY_MONITOR);
                this.tables = this.dbh.getTables();
                Arrays.sort(this.tables, new TableNameComparator());
            }
            catch (Exception e1) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e1.getMessage()), (Throwable)e1);
                return;
            }
        }
        this.createMainPanel();
        this.closeItem.setEnabled(true);
    }

    private void closeDb() {
        this.dbh.close();
        this.dbh = null;
        this.getContentPane().remove(this.mainPanel);
        this.closeItem.setEnabled(false);
    }

    private void createMainPanel() {
        this.mainPanel = new JPanel(new BorderLayout());
        JPanel northPanel = new JPanel(new FlowLayout(0));
        JPanel subNorthPanel = new JPanel((LayoutManager)new PairLayout(4, 10));
        subNorthPanel.add(new JLabel("Database:"));
        subNorthPanel.add(new JLabel(this.dbFile.getName()));
        subNorthPanel.add(new JLabel("Tables:"));
        String[] names = new String[this.tables.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.tables[i].getName() + " (" + Integer.toString(this.tables[i].getRecordCount()) + ")";
        }
        this.combo = new JComboBox<String>(names);
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DbViewer.this.updateTable();
            }
        });
        subNorthPanel.add(this.combo);
        northPanel.add(subNorthPanel);
        this.mainPanel.add((Component)northPanel, "North");
        this.getContentPane().add(this.mainPanel);
        this.southPanel = this.createSouthPanel(this.tables[0]);
        this.mainPanel.add((Component)this.southPanel, "Center");
        this.validate();
    }

    private void updateTable() {
        Table table = this.tables[this.combo.getSelectedIndex()];
        this.mainPanel.remove(this.southPanel);
        this.southPanel = this.createSouthPanel(table);
        this.mainPanel.add((Component)this.southPanel, "Center");
        this.validate();
    }

    private JPanel createSouthPanel(Table table) {
        JPanel panel = new JPanel(new BorderLayout());
        TableModel model = null;
        model = table.getRecordCount() <= 10000 ? new DbSmallTableModel(table) : new DbLargeTableModel(table);
        JTable jtable = new JTable(model);
        JScrollPane scroll = new JScrollPane(jtable);
        panel.add((Component)scroll, "Center");
        TableStatistics[] stats = this.getStats(table);
        String recCnt = "Records: " + Integer.toString(table.getRecordCount());
        Object intNodeCnt = "";
        Object recNodeCnt = "";
        Object chainBufCnt = "";
        Object size = "";
        if (stats != null) {
            intNodeCnt = "Interior Nodes: " + Integer.toString(stats[0].interiorNodeCnt);
            recNodeCnt = "Record Nodes: " + Integer.toString(stats[0].recordNodeCnt);
            chainBufCnt = "Chained Buffers: " + Integer.toString(stats[0].chainedBufferCnt);
            size = "Size (KB): " + Integer.toString(stats[0].size / 1024);
            if (stats.length > 1) {
                intNodeCnt = (String)intNodeCnt + " / " + Integer.toString(stats[1].interiorNodeCnt);
                recNodeCnt = (String)recNodeCnt + " / " + Integer.toString(stats[1].recordNodeCnt);
                chainBufCnt = (String)chainBufCnt + " / " + Integer.toString(stats[1].chainedBufferCnt);
                size = (String)size + " / " + Integer.toString(stats[1].size / 1024);
            }
        }
        JLabel statsLabel = new JLabel(recCnt + "   " + (String)intNodeCnt + "   " + (String)recNodeCnt + "   " + (String)chainBufCnt + "   " + (String)size);
        panel.add((Component)statsLabel, "South");
        return panel;
    }

    private TableStatistics[] getStats(Table table) {
        TableStatistics[] stats = this.tableStats.get(table.getName());
        if (stats == null) {
            try {
                stats = table.getAllStatistics();
                for (int i = 2; i < stats.length; ++i) {
                    stats[1].bufferCount += stats[i].bufferCount;
                    stats[1].chainedBufferCnt += stats[i].chainedBufferCnt;
                    stats[1].interiorNodeCnt += stats[i].interiorNodeCnt;
                    stats[1].recordNodeCnt += stats[i].recordNodeCnt;
                    stats[1].size += stats[i].size;
                }
                this.tableStats.put(table.getName(), stats);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return stats;
    }

    public static void main(String[] args) throws IOException {
        DockingApplicationLayout layout = new DockingApplicationLayout("DB Viewer", "1.0");
        DockingApplicationConfiguration configuration = new DockingApplicationConfiguration();
        configuration.setShowSplashScreen(false);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)configuration);
        DbViewer viewer = new DbViewer();
        viewer.setSize(new Dimension(500, 400));
        viewer.setVisible(true);
    }

    private class TableNameComparator
    implements Comparator<Table> {
        private TableNameComparator() {
        }

        @Override
        public int compare(Table t1, Table t2) {
            return t1.getName().compareTo(t2.getName());
        }
    }
}

