/*
 * Decompiled with CFR 0.152.
 */
package generic.io;

import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import utilities.util.FileUtilities;

public class JarReader {
    protected JarInputStream jarIn;

    public JarReader(JarInputStream jarIn) {
        this.jarIn = jarIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRecursively(String basePath, TaskMonitor monitor) throws FileNotFoundException, IOException {
        boolean done = false;
        while (!done && !monitor.isCancelled()) {
            JarEntry entry = this.jarIn.getNextJarEntry();
            if (entry == null) {
                done = true;
                break;
            }
            String name = entry.getName();
            long modTime = entry.getTime();
            Object filePath = basePath + name;
            filePath = ((String)filePath).replace('/', File.separatorChar);
            filePath = ((String)filePath).replace('\\', File.separatorChar);
            long lastIndex = ((String)filePath).lastIndexOf(File.separatorChar);
            String dirPath = ((String)filePath).substring(0, (int)lastIndex);
            File dir = new File(dirPath);
            FileUtilities.mkdirs((File)dir);
            File file = new File((String)filePath);
            if (!file.createNewFile() && !file.exists()) {
                throw new IOException("Couldn't create file " + file.getAbsolutePath());
            }
            FileOutputStream out = null;
            out = new FileOutputStream(file);
            byte[] bytes = new byte[4096];
            int numRead = 0;
            try {
                while ((numRead = this.jarIn.read(bytes)) != -1 && !monitor.isCancelled()) {
                    out.write(bytes, 0, numRead);
                }
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException ioe) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + ioe.getMessage()), (Throwable)ioe);
                }
            }
            if (modTime <= 0L || !file.isFile()) continue;
            file.setLastModified(modTime);
        }
        this.fixDirModifiedTimes(new File(basePath));
    }

    private void fixDirModifiedTimes(File dir) {
        File[] files;
        long modTime = 0L;
        for (File f : files = dir.listFiles()) {
            long t;
            if (f.isDirectory()) {
                this.fixDirModifiedTimes(f);
            }
            if ((t = f.lastModified()) <= modTime) continue;
            modTime = t;
        }
        if (modTime > 0L) {
            dir.setLastModified(modTime);
        }
    }

    public JarInputStream getJarInputStream() {
        return this.jarIn;
    }
}

