/*
 * Decompiled with CFR 0.152.
 */
package generic.test;

import generic.test.AbstractGenericTest;
import generic.test.ConcurrentTestExceptionHandler;
import generic.test.TestExceptionTracker;
import generic.test.TestThread;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.timer.GTimer;
import ghidra.util.timer.GTimerMonitor;
import java.util.List;
import java.util.concurrent.TimeUnit;
import junit.framework.AssertionFailedError;
import org.junit.runners.model.Statement;
import util.CollectionUtils;

public class ConcurrentTestExceptionStatement
extends Statement {
    private static long TIMEOUT_MILLIS = 600000L;
    private static Thread lastTestThread = null;
    private final Statement testStatement;
    private final GTimerMonitor timoutMonitor;

    public ConcurrentTestExceptionStatement(Statement originalStatement) {
        this.testStatement = originalStatement;
        ConcurrentTestExceptionHandler.clear();
        this.timoutMonitor = ConcurrentTestExceptionStatement.isRunningFromEclipse() ? null : GTimer.scheduleRunnable(TIMEOUT_MILLIS, () -> {});
    }

    private static boolean isRunningFromEclipse() {
        return System.getProperty("java.class.path").endsWith(".cp");
    }

    public void evaluate() throws Throwable {
        this.waitForPreviousTestToFinish();
        TestThread testThread = new TestThread(this.testStatement);
        lastTestThread = testThread;
        testThread.start();
        this.waitForTestUnlessExceptions(testThread);
        this.printNonTestThreadExceptions();
        if (testThread.exceptionFromTest != null) {
            this.maybePrintConsoleTestThreadExceptionMessage();
            throw testThread.exceptionFromTest;
        }
        TestExceptionTracker nonTestThreadTracker = this.getFirstNonTestThreadExceptionTracker();
        if (nonTestThreadTracker == null) {
            return;
        }
        throw nonTestThreadTracker.getCombinedException();
    }

    private void maybePrintConsoleTestThreadExceptionMessage() {
        if (!ConcurrentTestExceptionHandler.hasException()) {
            return;
        }
        Msg.error((Object)((Object)this), (Object)"The exceptions above may be side effects of test Assert failure messages--see the junit test results");
    }

    private TestExceptionTracker getFirstNonTestThreadExceptionTracker() {
        List<TestExceptionTracker> trackers = ConcurrentTestExceptionHandler.getExceptions();
        return CollectionUtils.any(trackers);
    }

    private void printNonTestThreadExceptions() {
        List<TestExceptionTracker> trackers = ConcurrentTestExceptionHandler.getExceptions();
        if (trackers.isEmpty()) {
            return;
        }
        Msg.error((Object)((Object)this), (Object)("Found unhandled exceptions (" + trackers.size() + "): "));
        for (int i = 0; i < trackers.size(); ++i) {
            TestExceptionTracker tracker = trackers.get(i);
            Throwable combinedException = tracker.getCombinedException();
            Msg.error((Object)((Object)this), (Object)("Exception " + (i + 1) + " of " + trackers.size() + "\n"), (Throwable)combinedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void waitForTestUnlessExceptions(TestThread testThread) {
        while (!testThread.finished) {
            Class<ConcurrentTestExceptionHandler> clazz = ConcurrentTestExceptionHandler.class;
            // MONITORENTER : generic.test.ConcurrentTestExceptionHandler.class
            this.checkForTestTimeout(testThread);
            if (ConcurrentTestExceptionHandler.hasException()) {
                this.interruptTestThread(testThread);
                // MONITOREXIT : clazz
                return;
            }
            try {
                ConcurrentTestExceptionHandler.class.wait(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void checkForTestTimeout(TestThread testThread) {
        if (this.timoutMonitor == null || !this.timoutMonitor.didRun()) {
            return;
        }
        if (SystemUtilities.isInDevelopmentMode()) {
            throw new AssertionFailedError("Test timeout after " + TimeUnit.MINUTES.convert(TIMEOUT_MILLIS, TimeUnit.MILLISECONDS) + " mins");
        }
        String vmTrace = AbstractGenericTest.createStackTraceForAllThreads();
        Msg.error(ConcurrentTestExceptionStatement.class, (Object)("\n\nThreads at time of interrupt:\n" + vmTrace));
        this.interruptTestThread(testThread);
        StackTraceElement[] trace = testThread.getStackTrace();
        testThread.stop();
        lastTestThread = null;
        AssertionFailedError error = new AssertionFailedError("Test locked-up--aborting!  See log for details");
        error.setStackTrace(trace);
        throw error;
    }

    private void interruptTestThread(TestThread testThread) {
        testThread.interrupt();
        try {
            testThread.join(250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void waitForPreviousTestToFinish() {
        if (lastTestThread == null) {
            return;
        }
        long reasonableTimeoutMillis = 15000L;
        try {
            lastTestThread.join(reasonableTimeoutMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

