/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import java.awt.dnd.DropTargetDragEvent;

class DropTargetDragEventWrapper
extends DropTargetDragEvent {
    private boolean isAccepted = false;
    private int dragOperation;
    private DropTargetDragEvent originalEvent;
    private boolean isRejected;

    public DropTargetDragEventWrapper(DropTargetDragEvent ev) {
        super(ev.getDropTargetContext(), ev.getLocation(), ev.getDropAction(), ev.getSourceActions());
        this.originalEvent = ev;
    }

    @Override
    public void acceptDrag(int dragOp) {
        this.isAccepted = true;
        this.dragOperation = dragOp;
    }

    @Override
    public void rejectDrag() {
        this.isRejected = true;
    }

    boolean isAccepted() {
        return this.isAccepted;
    }

    void flush() {
        if (this.isAccepted) {
            this.originalEvent.acceptDrag(this.dragOperation);
        } else if (this.isRejected) {
            this.originalEvent.rejectDrag();
        }
    }
}

