/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.classfinder;

import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.classfinder.ClassDir;
import ghidra.util.classfinder.ClassJar;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.classfinder.ExtensionPoint;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utility.module.ModuleUtilities;

public class ClassFinder {
    static final Logger log = LogManager.getLogger(ClassFinder.class);
    private static List<Class<?>> FILTER_CLASSES = Collections.unmodifiableList(Arrays.asList(ExtensionPoint.class));
    private List<ClassDir> classDirs = new ArrayList<ClassDir>();
    private List<ClassJar> classJars = new ArrayList<ClassJar>();
    private Map<String, List<Class<?>>> classesByName;

    public ClassFinder(List<String> searchPaths, TaskMonitor monitor) throws CancelledException {
        this.initialize(searchPaths, monitor);
    }

    private void initialize(List<String> searchPaths, TaskMonitor monitor) throws CancelledException {
        this.classDirs.clear();
        this.classJars.clear();
        this.reconcileClasses(searchPaths, monitor);
    }

    private void reconcileClasses(List<String> searchPaths, TaskMonitor monitor) throws CancelledException {
        LinkedHashSet<String> pathSet = new LinkedHashSet<String>(searchPaths);
        Iterator<ClassDir> dirs = this.classDirs.iterator();
        while (dirs.hasNext()) {
            monitor.checkCanceled();
            ClassDir classDir = dirs.next();
            String dirPath = classDir.getDirPath();
            if (!pathSet.contains(dirPath)) {
                log.trace(dirPath + " dropped from previous classpath");
                dirs.remove();
                continue;
            }
            classDir.rescan(monitor);
            pathSet.remove(dirPath);
        }
        Iterator<ClassJar> jars = this.classJars.iterator();
        while (jars.hasNext()) {
            monitor.checkCanceled();
            ClassJar classJar = jars.next();
            String jarPath = classJar.getJarPath();
            if (!pathSet.contains(jarPath)) {
                log.trace(jarPath + " dropped from previous classpath");
                jars.remove();
                continue;
            }
            classJar.rescan(monitor);
            pathSet.remove(jarPath);
        }
        Iterator pathIterator = pathSet.iterator();
        while (pathIterator.hasNext()) {
            monitor.checkCanceled();
            String path = (String)pathIterator.next();
            String lcPath = path.toLowerCase();
            File file = new File(path);
            if ((lcPath.endsWith(".jar") || lcPath.endsWith(".zip")) && file.exists()) {
                if (ClassJar.ignoreJar(lcPath)) {
                    log.trace("Ignoring jar file: " + path);
                    continue;
                }
                log.trace("Searching jar file: " + path);
                this.classJars.add(new ClassJar(path, monitor));
                continue;
            }
            if (!file.isDirectory()) continue;
            log.trace("Searching classpath directory: " + path);
            this.classDirs.add(new ClassDir(path, monitor));
        }
    }

    public List<Class<?>> getClasses(Class<?> filterClass, TaskMonitor monitor) throws CancelledException {
        List<Class<?>> classes;
        if (this.classesByName == null) {
            HashMap map = new HashMap();
            HashSet classSet = new HashSet();
            Iterator<ClassDir> classDirIterator = this.classDirs.iterator();
            while (classDirIterator.hasNext()) {
                monitor.checkCanceled();
                ClassDir classDir = classDirIterator.next();
                classDir.getClasses(classSet, monitor);
            }
            Iterator<ClassJar> classJarsIterator = this.classJars.iterator();
            while (classJarsIterator.hasNext()) {
                monitor.checkCanceled();
                ClassJar classJar = classJarsIterator.next();
                classJar.getClasses(classSet, monitor);
            }
            for (Class<?> filterClasse : FILTER_CLASSES) {
                monitor.checkCanceled();
                ArrayList<Class> list = new ArrayList<Class>();
                for (Class clazz : classSet) {
                    if (!filterClasse.isAssignableFrom(clazz)) continue;
                    list.add(clazz);
                }
                map.put(filterClasse.getName(), list);
            }
            this.classesByName = map;
        }
        return (classes = this.classesByName.get(filterClass.getName())) != null ? classes : Collections.emptyList();
    }

    static Class<?> loadExtensionPoint(String path, String fullName) {
        if (!ClassSearcher.isExtensionPointName(fullName)) {
            return null;
        }
        ClassLoader classLoader = ClassSearcher.class.getClassLoader();
        try {
            Class<?> c = Class.forName(fullName, true, classLoader);
            if (ClassFinder.isClassOfInterest(c)) {
                return c;
            }
        }
        catch (Throwable t) {
            ClassFinder.processClassLoadError(path, fullName, t);
        }
        return null;
    }

    private static void processClassLoadError(String path, String name, Throwable t) {
        if (t instanceof LinkageError) {
            Msg.trace(ClassFinder.class, (Object)("LinkageError loading class " + name + "; Incompatible class version? "), (Throwable)t);
            return;
        }
        if (!(t instanceof ClassNotFoundException)) {
            Msg.error(ClassFinder.class, (Object)("Error loading class " + name + " - " + t.getMessage()), (Throwable)t);
            return;
        }
        ClassFinder.processClassNotFoundExcepetion(path, name, (ClassNotFoundException)t);
    }

    private static void processClassNotFoundExcepetion(String path, String name, ClassNotFoundException t) {
        if (!ClassFinder.isModuleEntryMissingFromClasspath(path)) {
            Msg.error(ClassFinder.class, (Object)("Error loading class " + name + " - " + t.getMessage()), (Throwable)t);
            return;
        }
        if (SystemUtilities.isInTestingMode()) {
            return;
        }
        Msg.error(ClassFinder.class, (Object)("Module class is missing from the classpath.\n\tUpdate your launcher accordingly.\n\tModule: '" + path + "'\n\tClass: '" + name + "'"));
    }

    private static boolean isModuleEntryMissingFromClasspath(String path) {
        boolean inModule = ModuleUtilities.isInModule((String)path);
        if (!inModule) {
            return false;
        }
        String classPath = System.getProperty("java.class.path");
        boolean inClassPath = classPath.contains(path);
        return !inClassPath;
    }

    public static boolean isClassOfInterest(Class<?> c) {
        if (Modifier.isAbstract(c.getModifiers())) {
            return false;
        }
        if (c.getEnclosingClass() != null && !Modifier.isStatic(c.getModifiers())) {
            return false;
        }
        if (!Modifier.isPublic(c.getModifiers())) {
            return false;
        }
        if (ExtensionPoint.Util.isExcluded(c)) {
            return false;
        }
        for (Class<?> filterClasse : FILTER_CLASSES) {
            if (!filterClasse.isAssignableFrom(c)) continue;
            return true;
        }
        return false;
    }
}

