/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.ShortListIndexer;
import java.io.Serializable;

public class ShortLongIndexedList
implements Serializable {
    private static final short DEFAULT_CAPACITY = 16;
    private long[] values;
    private ShortListIndexer indexer;
    private int capacity;

    public ShortLongIndexedList(short numLists) {
        this.indexer = new ShortListIndexer(numLists, 16);
        this.capacity = this.indexer.getCapacity();
        this.values = new long[this.capacity];
    }

    public void add(short listID, long value) {
        short index = this.indexer.add(listID);
        if (index >= this.capacity) {
            this.grow(this.indexer.getCapacity());
        }
        this.values[index] = value;
    }

    public void append(short listID, long value) {
        short index = this.indexer.append(listID);
        if (index >= this.capacity) {
            this.grow(this.indexer.getCapacity());
        }
        this.values[index] = value;
    }

    public boolean remove(short listID, long value) {
        short index = this.findIndex(listID, value);
        if (index < 0) {
            return false;
        }
        this.indexer.remove(listID, index);
        return true;
    }

    public void removeAll(short listID) {
        this.indexer.removeAll(listID);
    }

    public boolean contains(short listID, long value) {
        short index = this.findIndex(listID, value);
        return index != -1;
    }

    public int getCount(short listID) {
        return this.indexer.getListSize(listID);
    }

    public long[] get(short listID) {
        int count = this.indexer.getListSize(listID);
        long[] lvalues = new long[count];
        short p = this.indexer.first(listID);
        for (int i = 0; i < count; ++i) {
            lvalues[i] = this.values[p];
            p = this.indexer.next(p);
        }
        return lvalues;
    }

    public short getNumLists() {
        return this.indexer.getNumLists();
    }

    public void growNumLists(short numLists) {
        this.indexer.growNumLists(numLists);
    }

    public void clear() {
        this.indexer.clear();
    }

    private void grow(int newCapacity) {
        this.capacity = newCapacity;
        long[] tempValues = new long[newCapacity];
        System.arraycopy(this.values, 0, tempValues, 0, this.values.length);
        this.values = tempValues;
    }

    private short findIndex(short listID, long value) {
        short p = this.indexer.first(listID);
        while (p != -1) {
            if (this.values[p] == value) {
                return p;
            }
            p = this.indexer.next(p);
        }
        return -1;
    }
}

