/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.info;

import ghidra.bitpatterns.info.ContextRegisterInfo;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContextRegisterFilter {
    private Set<String> contextRegisters = new HashSet<String>();
    private Map<String, BigInteger> values = new HashMap<String, BigInteger>();

    public void addRegAndValueToFilter(String contextRegister, BigInteger value) {
        if (this.contextRegisters.contains(contextRegister)) {
            throw new IllegalStateException("Filter can have only one value per register!");
        }
        this.contextRegisters.add(contextRegister);
        this.values.put(contextRegister, value);
    }

    public boolean allows(List<ContextRegisterInfo> contextRegisterInfos) {
        for (ContextRegisterInfo cInfo : contextRegisterInfos) {
            if (!this.contextRegisters.contains(cInfo.getContextRegister()) || this.values.get(cInfo.getContextRegister()).equals(cInfo.getValueAsBigInteger())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Context Register Filter: \n");
        for (String cReg : this.contextRegisters) {
            sb.append(cReg);
            sb.append(": ");
            sb.append(this.values.get(cReg).toString());
            sb.append("\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    public String getCompactString() {
        StringBuilder sb = new StringBuilder();
        String[] registers = this.contextRegisters.toArray(new String[0]);
        int max = registers.length;
        for (int i = 0; i < max; ++i) {
            sb.append(registers[i]);
            sb.append("=");
            sb.append(this.values.get(registers[i]).toString());
            if (i >= max - 1) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.contextRegisters.hashCode();
        hash = 31 * hash + this.values.hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ContextRegisterFilter)) {
            return false;
        }
        ContextRegisterFilter otherFilter = (ContextRegisterFilter)o;
        if (!otherFilter.contextRegisters.equals(this.contextRegisters)) {
            return false;
        }
        return otherFilter.values.equals(this.values);
    }

    public Map<String, BigInteger> getValueMap() {
        return this.values;
    }
}

