/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.bytesearch;

import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.CRC32;

public class DittedBitSequence {
    public static int[] popcount = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    protected int index;
    private byte[] bits;
    private byte[] dits;

    public DittedBitSequence() {
        this.bits = null;
        this.dits = null;
    }

    public DittedBitSequence(String dittedBitData) {
        this.initFromDittedStringData(dittedBitData);
    }

    public DittedBitSequence(String dittedBitData, boolean hex) {
        if (hex && !((String)dittedBitData).contains(".") && !((String)dittedBitData).startsWith("0x")) {
            dittedBitData = "0x" + (String)dittedBitData;
        }
        this.initFromDittedStringData((String)dittedBitData);
    }

    public DittedBitSequence(DittedBitSequence op2) {
        this.bits = op2.bits;
        this.dits = op2.dits;
    }

    public byte[] getValueBytes() {
        return (byte[])this.bits.clone();
    }

    public byte[] getMaskBytes() {
        return (byte[])this.dits.clone();
    }

    public DittedBitSequence(byte[] bytes) {
        this.bits = bytes;
        this.dits = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            this.dits[i] = -1;
        }
    }

    public DittedBitSequence(byte[] bytes, byte[] mask) {
        this.bits = bytes;
        this.dits = mask;
    }

    public DittedBitSequence(DittedBitSequence s1, DittedBitSequence s2) {
        this.bits = new byte[s1.bits.length];
        this.dits = new byte[s1.bits.length];
        for (int i = 0; i < this.bits.length; ++i) {
            int tempInt = s1.dits[i] & s2.dits[i] & (0xFF ^ s1.bits[i] ^ s2.bits[i]);
            this.dits[i] = (byte)tempInt;
            this.bits[i] = (byte)(s1.bits[i] & s2.bits[i]);
        }
    }

    public int hashCode() {
        CRC32 crc = new CRC32();
        crc.update(this.bits);
        crc.update(this.dits);
        return (int)crc.getValue();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        DittedBitSequence op2 = (DittedBitSequence)obj;
        if (this.bits.length != op2.bits.length) {
            return false;
        }
        for (int i = 0; i < this.bits.length; ++i) {
            if (this.bits[i] != op2.bits[i]) {
                return false;
            }
            if (this.dits[i] == op2.dits[i]) continue;
            return false;
        }
        return true;
    }

    public DittedBitSequence concatenate(DittedBitSequence op2) {
        int i;
        DittedBitSequence res = new DittedBitSequence();
        res.bits = new byte[this.bits.length + op2.bits.length];
        res.dits = new byte[res.bits.length];
        for (i = 0; i < this.bits.length; ++i) {
            res.bits[i] = this.bits[i];
            res.dits[i] = this.dits[i];
        }
        for (i = 0; i < op2.bits.length; ++i) {
            res.bits[this.bits.length + i] = op2.bits[i];
            res.dits[this.bits.length + i] = op2.dits[i];
        }
        return res;
    }

    public boolean isMatch(int pos, int val) {
        if (pos >= this.bits.length) {
            return false;
        }
        return (byte)(val & this.dits[pos]) == this.bits[pos];
    }

    public int getIndex() {
        return this.index;
    }

    public int getSize() {
        return this.bits.length;
    }

    public int getNumFixedBits() {
        int popcnt = 0;
        for (byte dit : this.dits) {
            popcnt += popcount[0xFF & dit];
        }
        return popcnt;
    }

    public int getNumUncertainBits() {
        int popcnt = 0;
        for (byte dit : this.dits) {
            popcnt += popcount[0xFF & dit];
        }
        return 8 * this.dits.length - popcnt;
    }

    public void writeBits(StringBuffer buf) {
        for (int chunk = 0; chunk < this.bits.length; ++chunk) {
            buf.append(' ');
            byte dchomp = this.dits[chunk];
            byte bchomp = this.bits[chunk];
            for (int pos = 128; pos > 0; pos >>>= 1) {
                if ((dchomp & pos) == 0) {
                    buf.append('.');
                    continue;
                }
                buf.append((bchomp & pos) != 0 ? (char)'1' : '0');
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.writeBits(buf);
        return buf.toString();
    }

    public String getHexString() {
        String uncompressed = this.toString();
        String[] parts = uncompressed.trim().split(" ");
        StringBuilder sb = new StringBuilder();
        int max = parts.length;
        for (int i = 0; i < max; ++i) {
            if (parts[i].contains(".")) {
                sb.append(parts[i]);
                if (i == max - 1) continue;
                sb.append(" ");
                continue;
            }
            Object hexByte = Integer.toHexString(Integer.parseUnsignedInt(parts[i].trim(), 2));
            if (((String)hexByte).length() < 2) {
                hexByte = "0" + (String)hexByte;
            }
            sb.append("0x");
            sb.append((String)hexByte);
            if (i == max - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    protected int restoreXmlData(XmlPullParser parser) throws IOException {
        parser.start(new String[]{"data"});
        String text = parser.end().getText();
        try {
            return this.initFromDittedStringData(text);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Bad <data> tag in at line " + parser.getLineNumber() + " : " + text);
        }
    }

    private int initFromDittedStringData(String text) throws IllegalArgumentException {
        int markOffset = -1;
        int mode = -1;
        ArrayList<Byte> ditarray = new ArrayList<Byte>();
        ArrayList<Byte> bitarray = new ArrayList<Byte>();
        int i = 0;
        while (i < text.length()) {
            int mask;
            int val;
            char c2;
            char c1 = text.charAt(i);
            if (mode == -2 && c1 != '\n') {
                ++i;
                continue;
            }
            if (Character.isWhitespace(c1)) {
                mode = -1;
                ++i;
                continue;
            }
            if (c1 == '#') {
                mode = -2;
                ++i;
                continue;
            }
            if (mode == -1) {
                if (c1 == '0') {
                    c2 = text.charAt(i + 1);
                    if (c2 == 'x') {
                        mode = 0;
                        i += 2;
                        continue;
                    }
                } else {
                    if (c1 == '*') {
                        markOffset = ditarray.size();
                        ++i;
                        continue;
                    }
                    if (c1 == '0' || c1 == '1' || c1 == '.') {
                        mode = 1;
                    } else {
                        throw new IllegalArgumentException("Bad ditted bit sequence");
                    }
                }
            }
            if (mode == 0) {
                c2 = text.charAt(i + 1);
                i += 2;
                val = 0;
                mask = 255;
                if (c1 == '.') {
                    mask ^= 0xF0;
                } else {
                    val = Character.getNumericValue(c1) << 4;
                }
                if (c2 == '.') {
                    mask ^= 0xF;
                } else {
                    val |= Character.getNumericValue(c2);
                }
                bitarray.add((byte)val);
                ditarray.add((byte)mask);
                continue;
            }
            val = 0;
            mask = 0;
            for (int j = 0; j < 8; ++j) {
                c1 = text.charAt(i + j);
                if (c1 == '0') {
                    val <<= 1;
                    mask <<= 1;
                    mask |= 1;
                    continue;
                }
                if (c1 == '.') {
                    val <<= 1;
                    mask <<= 1;
                    continue;
                }
                val <<= 1;
                val |= 1;
                mask <<= 1;
                mask |= 1;
            }
            i += 8;
            bitarray.add((byte)val);
            ditarray.add((byte)mask);
        }
        this.bits = new byte[bitarray.size()];
        this.dits = new byte[ditarray.size()];
        for (int k = 0; k < this.bits.length; ++k) {
            this.bits[k] = (Byte)bitarray.get(k);
            this.dits[k] = (Byte)ditarray.get(k);
        }
        return markOffset;
    }

    public int getNumInitialFixedBits(int marked) {
        if (this.dits == null) {
            return 0;
        }
        if (marked <= 0 || marked > this.dits.length) {
            return 0;
        }
        int popcnt = 0;
        for (int i = 0; i < marked; ++i) {
            popcnt += popcount[0xFF & this.dits[i]];
        }
        return popcnt;
    }
}

