/*
 * Decompiled with CFR 0.152.
 */
package docking.help;

import generic.jar.ResourceFile;
import ghidra.util.Msg;
import java.net.MalformedURLException;
import java.net.URL;
import resources.ResourceManager;

public class GHelpClassLoader
extends ClassLoader {
    private final ResourceFile moduleDirectory;

    public GHelpClassLoader(ResourceFile moduleDirectory) {
        super(GHelpClassLoader.class.getClassLoader());
        this.moduleDirectory = moduleDirectory;
    }

    @Override
    protected URL findResource(String name) {
        URL url = super.findResource(name);
        if (url != null) {
            return url;
        }
        url = this.findInModuleDirectory(name);
        if (url != null) {
            return url;
        }
        return this.findInJarFile(name);
    }

    private URL findInJarFile(String name) {
        URL URL2 = ResourceManager.getResource((String)("help/" + name));
        if (URL2 != null) {
            return URL2;
        }
        return null;
    }

    private URL findInModuleDirectory(String name) {
        if (this.moduleDirectory == null) {
            return null;
        }
        ResourceFile helpFile = new ResourceFile(this.moduleDirectory, name);
        if (helpFile.exists()) {
            try {
                return helpFile.toURL();
            }
            catch (MalformedURLException e) {
                Msg.error((Object)this, (Object)("Unexpected exception converting file to URL: " + helpFile), (Throwable)e);
            }
        }
        return null;
    }
}

