/*
 * Decompiled with CFR 0.152.
 */
package docking.util;

import docking.action.ActionContextProvider;
import docking.action.DockingAction;
import docking.util.ActionAdapter;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.preferences.Preferences;
import ghidra.util.Msg;
import ghidra.util.filechooser.GhidraFileChooserModel;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.xml.GenericXMLOutputter;
import ghidra.util.xml.XmlUtilities;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class KeyBindingUtils {
    private static final String LAST_KEY_BINDING_EXPORT_DIRECTORY = "LastKeyBindingExportDirectory";
    private static final Logger log = LogManager.getLogger(KeyBindingUtils.class);
    public static final String PREFERENCES_FILE_EXTENSION = ".kbxml";
    private static final GhidraFileFilter FILE_FILTER = new GhidraFileFilter(){

        public boolean accept(File pathname, GhidraFileChooserModel model) {
            return pathname.isDirectory() || pathname.getName().endsWith(KeyBindingUtils.PREFERENCES_FILE_EXTENSION);
        }

        public String getDescription() {
            return "Key Bindings XML Files";
        }
    };

    private KeyBindingUtils() {
    }

    public static ToolOptions importKeyBindings() {
        InputStream inputStream = KeyBindingUtils.getInputStreamForFile(KeyBindingUtils.getStartingDir());
        return KeyBindingUtils.createOptionsforKeybindings(inputStream);
    }

    public static ToolOptions createOptionsforKeybindings(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        ToolOptions newKeyBindingOptions = null;
        SAXBuilder builder = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
        Element rootElement = null;
        try {
            rootElement = builder.build(inputStream).getRootElement();
        }
        catch (JDOMException e) {
            Msg.showError((Object)log, null, (String)"Error Loading Key Bindings", (Object)"Unable to build XML data.", (Throwable)e);
        }
        catch (IOException e) {
            Msg.showError((Object)log, null, (String)"Error Loading Key Bindings", (Object)"Unable to build XML data.", (Throwable)e);
        }
        if (rootElement != null) {
            newKeyBindingOptions = new ToolOptions(rootElement);
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return newKeyBindingOptions;
    }

    public static void exportKeyBindings(ToolOptions keyBindingOptions) {
        OutputStream outputStream = KeyBindingUtils.getOutputStreamForFile(KeyBindingUtils.getStartingDir());
        if (outputStream == null) {
            return;
        }
        Element rootElement = keyBindingOptions.getXmlRoot(true);
        Document document = new Document(rootElement);
        GenericXMLOutputter xmlOutputter = new GenericXMLOutputter();
        try {
            xmlOutputter.output(document, outputStream);
        }
        catch (IOException ioe) {
            Msg.showError((Object)log, null, (String)"Error Saving Key Bindings", (Object)"Unable to save key bindings as XML data.", (Throwable)ioe);
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void registerAction(JComponent component, DockingAction action) {
        KeyStroke keyBinding = action.getKeyBinding();
        KeyBindingUtils.registerAction(component, keyBinding, new ActionAdapter(action), 0);
    }

    public static void registerAction(JComponent component, DockingAction action, ActionContextProvider contextProvider) {
        KeyStroke keyBinding = action.getKeyBinding();
        KeyBindingUtils.registerAction(component, keyBinding, new ActionAdapter(action, contextProvider), 0);
    }

    public static void registerAction(JComponent component, DockingAction action, ActionContextProvider contextProvider, int focusCondition) {
        KeyStroke keyBinding = action.getKeyBinding();
        KeyBindingUtils.registerAction(component, keyBinding, new ActionAdapter(action, contextProvider), focusCondition);
    }

    public static void registerAction(JComponent component, KeyStroke keyStroke, Action action, int focusCondition) {
        if (keyStroke == null) {
            Msg.debug(KeyBindingUtils.class, (Object)("Attempted to register an action without providing a keystroke - action: " + action.getValue("Name")));
            return;
        }
        InputMap im = component.getInputMap(focusCondition);
        if (im == null) {
            return;
        }
        ActionMap am = component.getActionMap();
        if (am == null) {
            return;
        }
        Object keyText = im.get(keyStroke);
        if (keyText == null) {
            keyText = action.getValue("Name");
            im.put(keyStroke, keyText);
        }
        am.put(keyText, action);
    }

    public static void clearKeyBinding(JComponent component, KeyStroke keyStroke) {
        KeyBindingUtils.clearKeyBinding(component, keyStroke, 0);
    }

    public static void clearKeyBinding(JComponent component, KeyStroke keyStroke, int focusCondition) {
        InputMap inputMap = component.getInputMap(focusCondition);
        ActionMap actionMap = component.getActionMap();
        if (inputMap == null || actionMap == null) {
            return;
        }
        inputMap.put(keyStroke, "none");
    }

    public static Action getAction(JComponent component, KeyStroke keyStroke, int focusCondition) {
        InputMap inputMap = component.getInputMap(focusCondition);
        ActionMap actionMap = component.getActionMap();
        if (inputMap == null || actionMap == null) {
            return null;
        }
        Object binding = inputMap.get(keyStroke);
        return binding == null ? null : actionMap.get(binding);
    }

    public static Action adaptDockingActionToNonContextAction(DockingAction action) {
        return new ActionAdapter(action);
    }

    private static InputStream getInputStreamForFile(File startingDir) {
        File selectedFile = KeyBindingUtils.getFileFromUser(startingDir);
        if (selectedFile == null) {
            return null;
        }
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(selectedFile));
        }
        catch (FileNotFoundException fnfe) {
            Msg.showError((Object)log, null, (String)"File Not Found", (Object)("Cannot find file " + selectedFile.getAbsolutePath()), (Throwable)fnfe);
            return KeyBindingUtils.getInputStreamForFile(selectedFile);
        }
        return inputStream;
    }

    private static OutputStream getOutputStreamForFile(File startingDir) {
        File selectedFile = KeyBindingUtils.getFileFromUser(startingDir);
        if (selectedFile == null) {
            return null;
        }
        BufferedOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(selectedFile));
        }
        catch (FileNotFoundException fnfe) {
            Msg.showError((Object)log, null, (String)"File Not Found", (Object)("Cannot find file " + selectedFile.getAbsolutePath()), (Throwable)fnfe);
            return KeyBindingUtils.getOutputStreamForFile(selectedFile);
        }
        return outputStream;
    }

    private static File getStartingDir() {
        String lastDirectoryPath = Preferences.getProperty((String)LAST_KEY_BINDING_EXPORT_DIRECTORY);
        if (lastDirectoryPath != null) {
            return new File(lastDirectoryPath);
        }
        return new File(System.getProperty("user.home"));
    }

    private static File getFileFromUser(File startingDir) {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window activeComponent = kfm.getActiveWindow();
        GhidraFileChooser fileChooser = new GhidraFileChooser(activeComponent);
        fileChooser.setTitle("Please Select A File");
        fileChooser.setFileFilter(FILE_FILTER);
        fileChooser.setApproveButtonText("OK");
        fileChooser.setCurrentDirectory(startingDir);
        File selectedFile = fileChooser.getSelectedFile();
        if (selectedFile != null && !selectedFile.getName().endsWith(PREFERENCES_FILE_EXTENSION)) {
            selectedFile = new File(selectedFile.getAbsolutePath() + PREFERENCES_FILE_EXTENSION);
        }
        Preferences.setProperty((String)LAST_KEY_BINDING_EXPORT_DIRECTORY, (String)fileChooser.getCurrentDirectory().getAbsolutePath());
        return selectedFile;
    }
}

