/*
 * Decompiled with CFR 0.152.
 */
package docking.wizard;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.help.Help;
import docking.help.HelpService;
import docking.widgets.EmptyBorderButton;
import docking.wizard.IllegalPanelStateException;
import docking.wizard.PanelManager;
import docking.wizard.WizardPanel;
import docking.wizard.WizardPanelListener;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import resources.ResourceManager;

public class WizardManager
extends DialogComponentProvider
implements WizardPanelListener {
    public static final String FINISH = "Finish";
    public static final String NEXT = "Next >>";
    public static final String BACK = "<< Back";
    private static final String INIT_TITLE = "<< untitled >>";
    private PanelManager panelMgr;
    private WizardPanel currWizPanel;
    private JButton backButton;
    private JButton nextButton;
    private JButton finishButton;
    private JLabel titleLabel;
    private JPanel mainJPanel;
    private JScrollPane scrollPane;
    private JPanel currJPanel;

    public WizardManager(String title, boolean modal, PanelManager pmgr) {
        this(title, modal, pmgr, null);
    }

    public WizardManager(String title, boolean modal, PanelManager pmgr, Icon wizardIcon) {
        super(title, modal);
        this.init(pmgr, wizardIcon);
    }

    public void dispose() {
        if (this.currWizPanel != null) {
            this.currWizPanel.removeWizardPanelListener(this);
        }
        this.close();
    }

    @Override
    public void validityChanged() {
        this.clearStatusText();
        this.enableButtons();
    }

    public String getStatusMessage() {
        return this.getStatusText();
    }

    @Override
    public void setStatusMessage(String msg) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setStatusText(msg);
        } else {
            Runnable r = () -> this.setStatusText(msg);
            SwingUtilities.invokeLater(r);
        }
    }

    public void showWizard() {
        this.showWizard(null);
    }

    public void showWizard(Component parent) {
        this.panelMgr.initialize();
        WizardPanel nextPanel = null;
        try {
            nextPanel = this.panelMgr.getNextPanel();
            if (nextPanel == null) {
                Msg.showError((Object)this, (Component)parent, (String)(this.getTitle() + " Error"), (Object)"Failed to render wizard panel");
                return;
            }
        }
        catch (IllegalPanelStateException e) {
            this.handleIllegalStateException(e, true);
            return;
        }
        this.setCurrentPanel(nextPanel);
        DockingWindowManager.showDialog(parent, this);
    }

    public void completed(boolean success) {
        if (!success) {
            return;
        }
        SystemUtilities.runSwingNow(() -> this.close());
    }

    public void enableNavigation() {
        this.enableButtons();
        super.setCancelEnabled(true);
    }

    public void disableNavigation() {
        this.backButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.finishButton.setEnabled(false);
        super.setCancelEnabled(false);
    }

    @Override
    protected void cancelCallback() {
        this.panelMgr.cancel();
        this.close();
    }

    private void init(PanelManager pmgr, Icon wizardIcon) {
        this.panelMgr = pmgr;
        this.panelMgr.setWizardManager(this);
        Dimension panelSize = this.panelMgr.getPanelSize();
        this.currJPanel = new JPanel();
        this.currJPanel.setPreferredSize(panelSize);
        this.currJPanel.setMinimumSize(panelSize);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setPreferredSize(panelSize);
        this.scrollPane.setMinimumSize(panelSize);
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                WizardManager.this.updateScrollPaneBorder(WizardManager.this.currJPanel);
            }
        });
        this.titleLabel = wizardIcon == null ? new JLabel(INIT_TITLE) : new JLabel(INIT_TITLE, wizardIcon, 11);
        EmptyBorderButton helpButton = new EmptyBorderButton(ResourceManager.loadImage((String)"images/information.png"));
        helpButton.setToolTipText("Help (F1)");
        helpButton.addActionListener(e -> DockingWindowManager.getHelpService().showHelp(this.rootPanel, false, this.rootPanel));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        titlePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        titlePanel.add(this.titleLabel);
        titlePanel.add(Box.createHorizontalGlue());
        titlePanel.add(helpButton);
        this.mainJPanel = new JPanel(new BorderLayout());
        this.mainJPanel.add((Component)titlePanel, "North");
        this.mainJPanel.add((Component)this.scrollPane, "Center");
        this.backButton = new JButton(BACK);
        this.backButton.setMnemonic('B');
        this.nextButton = new JButton(NEXT);
        this.nextButton.setMnemonic('N');
        this.finishButton = new JButton(FINISH);
        this.finishButton.setMnemonic('F');
        this.backButton.addActionListener(evt -> this.back());
        this.nextButton.addActionListener(evt -> this.next());
        this.finishButton.addActionListener(evt -> this.finish());
        this.addButton(this.backButton);
        this.addButton(this.nextButton);
        this.addButton(this.finishButton);
        this.addCancelButton();
        this.setDefaultButton(this.nextButton);
        this.addWorkPanel(this.mainJPanel);
        this.setRememberLocation(false);
        this.setRememberSize(false);
    }

    private boolean handleIllegalStateException(IllegalPanelStateException e, boolean alwaysClose) {
        Throwable cause = e.getCause();
        if (cause == null) {
            cause = e;
        }
        boolean closeOnError = true;
        if (!alwaysClose && cause instanceof IOException) {
            closeOnError = false;
            try {
                this.panelMgr.initialize();
                this.setCurrentPanel(this.panelMgr.getInitialPanel());
                Msg.showError((Object)this, null, (String)(this.getTitle() + " Error"), (Object)cause.getMessage());
                this.enableNavigation();
            }
            catch (IllegalPanelStateException e1) {
                closeOnError = true;
            }
        }
        if (closeOnError) {
            if (cause instanceof IOException) {
                Msg.showError((Object)this, null, (String)(this.getTitle() + " Error"), (Object)cause.getMessage());
            } else {
                String message = cause.getMessage();
                message = message != null ? message : cause.getClass().getSimpleName();
                Msg.showError((Object)this, null, (String)(this.getTitle() + " Error"), (Object)message, (Throwable)cause);
            }
            this.close();
            return false;
        }
        return true;
    }

    public boolean back() {
        if (this.backButton.isEnabled()) {
            block4: {
                try {
                    this.setCurrentPanel(this.panelMgr.getPreviousPanel());
                }
                catch (IllegalPanelStateException e) {
                    if (this.handleIllegalStateException(e, false)) break block4;
                    return false;
                }
            }
            String msg = this.panelMgr.getStatusMessage();
            if (msg != null) {
                this.setStatusMessage(msg);
            }
            return true;
        }
        return false;
    }

    public boolean next() {
        if (this.nextButton.isEnabled()) {
            block4: {
                try {
                    this.setCurrentPanel(this.panelMgr.getNextPanel());
                }
                catch (IllegalPanelStateException e) {
                    if (this.handleIllegalStateException(e, false)) break block4;
                    return false;
                }
            }
            String msg = this.panelMgr.getStatusMessage();
            if (msg != null) {
                this.setStatusMessage(msg);
            }
            return true;
        }
        return false;
    }

    public void focusNext() {
        this.nextButton.requestFocus();
    }

    public void focusFinish() {
        this.finishButton.requestFocus();
        this.setDefaultButton(this.finishButton);
    }

    public boolean finish() {
        if (this.finishButton.isEnabled()) {
            block4: {
                try {
                    this.panelMgr.finish();
                }
                catch (IllegalPanelStateException e) {
                    if (this.handleIllegalStateException(e, false)) break block4;
                    return false;
                }
            }
            String msg = this.panelMgr.getStatusMessage();
            if (msg != null) {
                this.setStatusMessage(msg);
            }
            return true;
        }
        return false;
    }

    public WizardPanel getCurrentWizardPanel() {
        return this.currWizPanel;
    }

    private void setCurrentPanel(WizardPanel p) {
        if (this.currWizPanel != null) {
            this.currWizPanel.removeWizardPanelListener(this);
        }
        this.currWizPanel = p;
        this.currWizPanel.addWizardPanelListener(this);
        this.setPanel(this.currWizPanel.getPanel());
        this.setPanelTitle(this.currWizPanel.getTitle());
        this.setHelpLocation(this.currWizPanel.getHelpLocation());
        HelpLocation hLoc = this.currWizPanel.getHelpLocation();
        HelpService help = Help.getHelpService();
        help.registerHelp(this.getComponent(), hLoc);
        help.registerHelp(this.currWizPanel.getPanel(), hLoc);
        this.setStatusMessage("");
        this.enableButtons();
        this.rootPanel.repaint();
        this.requestFocusOnDefaultComponent(this.currWizPanel);
    }

    private void requestFocusOnDefaultComponent(WizardPanel wizardPanel) {
        Component defaultFocusComponent = wizardPanel.getDefaultFocusComponent();
        this.setFocusComponent(defaultFocusComponent);
        if (defaultFocusComponent == null) {
            return;
        }
        defaultFocusComponent.requestFocusInWindow();
    }

    private void setPanel(JPanel panel) {
        if (this.currJPanel != panel) {
            this.scrollPane.setViewportView(panel);
            this.currJPanel = panel;
            JScrollBar verticalBar = this.scrollPane.getVerticalScrollBar();
            verticalBar.setUnitIncrement(25);
            this.scrollPane.validate();
            this.updateScrollPaneBorder(panel);
        }
    }

    private void updateScrollPaneBorder(JPanel panel) {
        if (panel == null) {
            return;
        }
        this.scrollPane.setBackground(panel.getBackground());
        if (this.scrollPane.getVerticalScrollBar().isShowing()) {
            TitledBorder titledBorder = new TitledBorder(BorderFactory.createEmptyBorder(), "(scroll for more options)");
            Font font = titledBorder.getTitleFont();
            if (font == null) {
                font = this.titleLabel.getFont();
            }
            titledBorder.setTitleFont(font.deriveFont(10.0f));
            titledBorder.setTitleColor(Color.BLUE);
            titledBorder.setTitlePosition(5);
            titledBorder.setTitleJustification(5);
            this.scrollPane.setBorder(titledBorder);
        } else {
            this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    private void setPanelTitle(String title) {
        this.titleLabel.setText(title);
    }

    private void enableButtons() {
        boolean isValid = this.currWizPanel.isValidInformation();
        this.backButton.setEnabled(this.panelMgr.hasPreviousPanel());
        if (isValid) {
            this.nextButton.setEnabled(this.panelMgr.hasNextPanel());
            this.finishButton.setEnabled(this.panelMgr.canFinish());
        } else {
            this.nextButton.setEnabled(false);
            this.finishButton.setEnabled(false);
        }
        if (this.nextButton.isEnabled()) {
            this.setDefaultButton(this.nextButton);
        } else if (this.finishButton.isEnabled()) {
            this.setDefaultButton(this.finishButton);
        }
    }
}

