/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.emulation;

import ghidra.pcode.emulate.Emulate;
import ghidra.pcode.emulate.EmulateInstructionStateModifier;
import ghidra.pcode.emulate.callother.CountLeadingZerosOpBehavior;
import ghidra.pcode.emulate.callother.OpBehaviorOther;
import ghidra.pcode.memstate.MemoryState;
import ghidra.pcodeCPort.error.LowlevelError;
import ghidra.program.model.pcode.Varnode;
import java.math.BigInteger;

public class PPCEmulateInstructionStateModifier
extends EmulateInstructionStateModifier {
    public PPCEmulateInstructionStateModifier(Emulate emu) {
        super(emu);
        this.registerPcodeOpBehavior("countLeadingZeros", (OpBehaviorOther)new CountLeadingZerosOpBehavior());
        this.registerPcodeOpBehavior("vectorPermute", new vectorPermuteOpBehavior());
    }

    private class vectorPermuteOpBehavior
    implements OpBehaviorOther {
        private vectorPermuteOpBehavior() {
        }

        public void evaluate(Emulate emu, Varnode out, Varnode[] inputs) {
            byte[] permute;
            byte[] srcarray;
            int i;
            if (out == null) {
                throw new LowlevelError("CALLOTHER: Vector permute op missing required output");
            }
            if (inputs.length != 4) {
                throw new LowlevelError("CALLOTHER: Vector permute op requires three non-constant varnode input");
            }
            for (i = 1; i < 4; ++i) {
                if (inputs[i].getSize() != 0 && !inputs[i].isConstant()) continue;
                throw new LowlevelError("CALLOTHER: Vector permute op requires three non-constant varnode input");
            }
            Varnode in1 = inputs[1];
            Varnode in2 = inputs[2];
            Varnode in3 = inputs[3];
            if (in1.getSize() != 16 || in2.getSize() != 16 || in3.getSize() != 16 || out.getSize() != 16) {
                throw new LowlevelError("CALLOTHER: Vector permute op inputs/output must be 16bytes long");
            }
            MemoryState memoryState = emu.getMemoryState();
            BigInteger src = memoryState.getBigInteger(in1, false);
            src = src.shiftLeft(128);
            byte[] srcin = (src = src.or(memoryState.getBigInteger(in2, false))).toByteArray();
            if (srcin.length != 32) {
                i = 32 - srcin.length;
                srcarray = new byte[32];
                System.arraycopy(srcin, 0, srcarray, i, srcin.length);
            } else {
                srcarray = srcin;
            }
            byte[] pin = memoryState.getBigInteger(in3, false).toByteArray();
            if (pin.length != 16) {
                i = 16 - pin.length;
                permute = new byte[16];
                System.arraycopy(pin, 0, permute, i, pin.length);
            } else {
                permute = pin;
            }
            byte[] outarray = new byte[16];
            for (i = 0; i < 16; ++i) {
                outarray[i] = srcarray[permute[i] & 0x1F];
            }
            memoryState.setValue(out, new BigInteger(outarray));
        }
    }
}

