/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.format.FieldHeader;
import ghidra.app.util.viewer.format.FieldHeaderLocation;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;

public class SetFormatDialogComponentProvider
extends DialogComponentProvider {
    private final FormatManager currentFormatManager;
    private final FormatManager defaultFormatManager;
    private FormatManager newFormatManager;
    private ListingPanel listingPanel;
    private final Program program;
    private final AddressSetView view;

    public SetFormatDialogComponentProvider(FormatManager defaultManager, FormatManager currentFormatManager, ServiceProvider serviceProvider, Program program, AddressSetView view) {
        super("Edit Code Layout", true, false, true, false);
        this.defaultFormatManager = defaultManager;
        this.currentFormatManager = currentFormatManager;
        this.program = program;
        this.view = view;
        this.setPreferredSize(600, 500);
        this.addWorkPanel(this.createWorkPanel());
        this.addOKButton();
        this.addCancelButton();
        List headerActions = this.listingPanel.getHeaderActions(this.getTitle());
        for (DockingActionIf action : headerActions) {
            if ("Reset All Formats".equals(action.getName()) || "Reset Format".equals(action.getName())) continue;
            this.addAction(action);
        }
        this.addAction((DockingActionIf)new CustomResetFormatAction());
        this.addAction((DockingActionIf)new CustomResetAllFormatAction());
    }

    private JComponent createWorkPanel() {
        JPanel container = new JPanel(new BorderLayout());
        this.listingPanel = this.createListingPanel();
        this.listingPanel.showHeader(true);
        container.add((Component)this.listingPanel);
        return container;
    }

    private ListingPanel createListingPanel() {
        FormatManager formatManagerCopy = this.currentFormatManager.createClone();
        ListingPanel panel = new ListingPanel(formatManagerCopy, this.program);
        panel.setView(this.view);
        return panel;
    }

    public FormatManager getNewFormatManager() {
        return this.newFormatManager;
    }

    protected void okCallback() {
        this.newFormatManager = this.listingPanel.getFormatManager();
        this.close();
    }

    protected void cancelCallback() {
        this.newFormatManager = null;
        super.cancelCallback();
    }

    public void close() {
        super.close();
        this.listingPanel.dispose();
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (event == null) {
            return null;
        }
        FieldHeader headerPanel = this.listingPanel.getFieldHeader();
        if (headerPanel != null && headerPanel.isAncestorOf(event.getComponent())) {
            FieldHeaderLocation fhLoc = headerPanel.getFieldHeaderLocation(event.getPoint());
            return new ActionContext(null, (Object)fhLoc);
        }
        return null;
    }

    FieldHeader getFieldHeader() {
        return this.listingPanel.getFieldHeader();
    }

    private class CustomResetFormatAction
    extends DockingAction {
        public CustomResetFormatAction() {
            super("Reset Format", SetFormatDialogComponentProvider.this.getTitle(), false);
            this.setPopupMenuData(new MenuData(new String[]{"Reset Format"}, null, "format"));
            this.setEnabled(true);
        }

        public boolean isEnabledForContext(ActionContext context) {
            return context.getContextObject() instanceof FieldHeaderLocation;
        }

        public void actionPerformed(ActionContext context) {
            FieldHeader fieldHeader = SetFormatDialogComponentProvider.this.listingPanel.getFieldHeader();
            int index = fieldHeader.getSelectedIndex();
            FieldFormatModel originalModel = SetFormatDialogComponentProvider.this.defaultFormatManager.getModel(index);
            Element originalXML = originalModel.saveToXml();
            FormatManager listingFormatManager = SetFormatDialogComponentProvider.this.listingPanel.getFormatManager();
            FieldFormatModel currentModel = listingFormatManager.getModel(index);
            currentModel.restoreFromXml(originalXML);
        }
    }

    private class CustomResetAllFormatAction
    extends DockingAction {
        public CustomResetAllFormatAction() {
            super("Reset All Formats", SetFormatDialogComponentProvider.this.getTitle(), false);
            this.setPopupMenuData(new MenuData(new String[]{"Reset All Formats"}, null, "format"));
            this.setEnabled(true);
        }

        public boolean isEnabledForContext(ActionContext context) {
            return context.getContextObject() instanceof FieldHeaderLocation;
        }

        public void actionPerformed(ActionContext context) {
            int userChoice = OptionDialog.showOptionDialog((Component)SetFormatDialogComponentProvider.this.listingPanel, (String)"Reset All Formats?", (String)"There is no undo for this action.\nAre you sure you want to reset all formats?", (String)"Continue", (int)2);
            if (userChoice == 0) {
                return;
            }
            FormatManager listingFormatManager = SetFormatDialogComponentProvider.this.listingPanel.getFormatManager();
            SaveState saveState = new SaveState();
            SetFormatDialogComponentProvider.this.defaultFormatManager.saveState(saveState);
            listingFormatManager.readState(saveState);
        }
    }
}

