/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.vertex;

import docking.ActionContext;
import docking.GenericHeader;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import ghidra.app.plugin.core.functiongraph.FunctionGraphPlugin;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.vertex.AbstractGraphComponentPanel;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupHistoryInfo;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedFunctionGraphVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.SetVertexMostRecentColorAction;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphOptions;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import resources.ResourceManager;

public class GroupedFunctionGraphComponentPanel
extends AbstractGraphComponentPanel {
    private GenericHeader genericHeader;
    private GroupedFunctionGraphVertex groupVertex;
    private JComponent contentPanel;
    private DockingAction groupAction;
    private DockingAction regroupAction;
    private DockingAction ungroupAction;
    private DockingAction addToGroupAction;
    private SetVertexMostRecentColorAction setVertexMostRecentAction;
    private Color defaultBackgroundColor;
    private Color userDefinedColor;
    private String userText;
    private JTextArea userTextArea;

    GroupedFunctionGraphComponentPanel(FGController controller, GroupedFunctionGraphVertex vertex, String groupVertexUserText) {
        super(controller, vertex);
        this.groupVertex = vertex;
        this.userText = groupVertexUserText;
        this.title = this.createTitle();
        FunctionGraphOptions options = controller.getFunctionGraphOptions();
        this.defaultBackgroundColor = options.getDefaultGroupBackgroundColor();
        this.setLayout(new BorderLayout());
        this.genericHeader = new GenericHeader(){

            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                FormatManager formatManager = GroupedFunctionGraphComponentPanel.this.getController().getMinimalFormatManager();
                int maxWidth = formatManager.getMaxWidth();
                if (maxWidth <= 0) {
                    return preferredSize;
                }
                preferredSize.width = maxWidth = Math.min(maxWidth, 300);
                return preferredSize;
            }
        };
        this.genericHeader.setComponent((Component)this);
        this.genericHeader.setTitle(this.title);
        this.contentPanel = new JPanel();
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.contentPanel.setLayout((LayoutManager)new VerticalLayout(0));
        this.contentPanel.setOpaque(true);
        this.contentPanel.setBackground(this.defaultBackgroundColor);
        this.userTextArea = new JTextArea(){

            @Override
            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                FormatManager formatManager = GroupedFunctionGraphComponentPanel.this.getController().getMinimalFormatManager();
                int maxWidth = formatManager.getMaxWidth();
                if (maxWidth <= 0) {
                    return preferredSize;
                }
                preferredSize.width = maxWidth;
                return preferredSize;
            }
        };
        this.userTextArea.setOpaque(true);
        this.userTextArea.setBackground(this.defaultBackgroundColor);
        this.userTextArea.setEditable(false);
        this.userTextArea.setLineWrap(true);
        this.userTextArea.setWrapStyleWord(true);
        this.userTextArea.setBorder(BorderFactory.createEmptyBorder());
        this.userTextArea.setDragEnabled(false);
        this.contentPanel.add(this.userTextArea);
        this.setOpaque(true);
        this.setBackground(this.defaultBackgroundColor);
        this.add((Component)this.genericHeader, "North");
        this.add((Component)this.contentPanel, "Center");
        BevelBorder beveledBorder = (BevelBorder)BorderFactory.createBevelBorder(0, new Color(225, 225, 225), new Color(155, 155, 155), new Color(96, 96, 96), new Color(0, 0, 0));
        this.setBorder(beveledBorder);
        this.createActions();
        this.setUserText(this.userText);
        this.userDefinedColor = this.maybeUpdateUserDefinedColor();
        if (this.userDefinedColor != null) {
            this.doSetBackgroundColor(this.userDefinedColor);
        }
    }

    private void updateTextAreaSizeToForceTextLayout() {
        FormatManager formatManager = this.getController().getMinimalFormatManager();
        int maxWidth = formatManager.getMaxWidth();
        if (maxWidth <= 0) {
            return;
        }
        this.userTextArea.setSize(maxWidth, Integer.MAX_VALUE);
    }

    private String createTitle() {
        Set<FGVertex> vertices = this.groupVertex.getVertices();
        int size = vertices.size();
        AddressSetView addresses = this.vertex.getAddresses();
        Address minAddress = addresses.getMinAddress();
        Address maxAddress = addresses.getMaxAddress();
        return "Grouped Vertex - " + size + " vertices [" + minAddress + " - " + maxAddress + "]";
    }

    private void createActions() {
        String firstGroup = "group1";
        String secondGroup = "group2";
        this.groupAction = new DockingAction("Group Vertices", FunctionGraphPlugin.class.getName()){

            public void actionPerformed(ActionContext context) {
                GroupedFunctionGraphComponentPanel.this.groupVertices();
            }
        };
        this.groupAction.setDescription("Combine selected vertices into one vertex");
        ImageIcon imageIcon = ResourceManager.loadImage((String)"images/shape_handles.png");
        this.groupAction.setToolBarData(new ToolBarData((Icon)imageIcon, secondGroup));
        this.groupAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Group_Vertex_Action_Group"));
        this.regroupAction = new DockingAction("Regroup Vertices", FunctionGraphPlugin.class.getName()){

            public void actionPerformed(ActionContext context) {
                GroupedFunctionGraphComponentPanel.this.regroupVertices();
            }
        };
        this.regroupAction.setDescription("Restore vertex and siblings back to group form");
        imageIcon = ResourceManager.loadImage((String)"images/edit-redo.png");
        this.regroupAction.setToolBarData(new ToolBarData((Icon)imageIcon, secondGroup));
        this.regroupAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Vertex_Action_Regroup"));
        this.ungroupAction = new DockingAction("Ungroup Vertices", FunctionGraphPlugin.class.getName()){

            public void actionPerformed(ActionContext context) {
                GroupedFunctionGraphComponentPanel.this.controller.ungroupVertex(GroupedFunctionGraphComponentPanel.this.groupVertex);
            }
        };
        this.ungroupAction.setDescription("Ungroup selected vertices into individual vertex");
        imageIcon = ResourceManager.loadImage((String)"images/shape_ungroup.png");
        this.ungroupAction.setToolBarData(new ToolBarData((Icon)imageIcon, secondGroup));
        this.ungroupAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Vertex_Action_Ungroup"));
        this.addToGroupAction = new DockingAction("Add to Group", FunctionGraphPlugin.class.getName()){

            public void actionPerformed(ActionContext context) {
                GroupedFunctionGraphComponentPanel.this.addToGroup();
            }

            public boolean isEnabledForContext(ActionContext context) {
                Set<FGVertex> vertices = GroupedFunctionGraphComponentPanel.this.controller.getSelectedVertices();
                vertices.remove(GroupedFunctionGraphComponentPanel.this.vertex);
                if (vertices.size() == 0) {
                    Msg.showInfo(((Object)((Object)this)).getClass(), (Component)GroupedFunctionGraphComponentPanel.this, (String)"Cannot Group 1 Vertex", (Object)"You must have more than 1 vertex selected to add to this group");
                    return false;
                }
                return vertices.size() > 0;
            }
        };
        this.addToGroupAction.setDescription("Add the selected vertices to this group");
        imageIcon = ResourceManager.loadImage((String)"images/shape_square_add.png");
        this.addToGroupAction.setToolBarData(new ToolBarData((Icon)imageIcon, secondGroup));
        this.addToGroupAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Vertex_Action_Group_Add"));
        this.setVertexMostRecentAction = new SetVertexMostRecentColorAction(this.controller, this.vertex);
        this.setVertexMostRecentAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Group_Vertex_Action_Color"));
        Icon icon = this.setVertexMostRecentAction.getToolbarIcon();
        this.setVertexMostRecentAction.setToolBarData(new ToolBarData(icon, firstGroup));
        this.genericHeader.actionAdded((DockingActionIf)this.setVertexMostRecentAction);
        this.genericHeader.actionAdded((DockingActionIf)this.ungroupAction);
        this.genericHeader.actionAdded((DockingActionIf)this.addToGroupAction);
        this.genericHeader.actionAdded((DockingActionIf)this.groupAction);
        this.genericHeader.update();
    }

    private void removeRedoAction() {
        this.genericHeader.actionRemoved((DockingActionIf)this.regroupAction);
    }

    private void addRedoAction() {
        GroupHistoryInfo groupInfo = this.vertex.getGroupInfo();
        this.regroupAction.setDescription(HTMLUtilities.toHTML((String)groupInfo.getGroupDescription()));
        this.genericHeader.actionRemoved((DockingActionIf)this.regroupAction);
        this.genericHeader.actionAdded((DockingActionIf)this.regroupAction);
    }

    @Override
    void updateGroupAssociationStatus(boolean groupMember) {
        if (groupMember) {
            this.addRedoAction();
        } else {
            this.removeRedoAction();
        }
    }

    @Override
    void editLabel(JComponent parentComponent) {
        String oldText = this.userText;
        String text = this.controller.promptUserForGroupVertexText(parentComponent, this.userText, this.groupVertex.getVertices());
        if (text == null || text.equals(oldText)) {
            return;
        }
        this.setUserText(text);
        this.groupVertex.userTextChanged(oldText, text);
        this.controller.repaint();
    }

    String getUserText() {
        return this.userText;
    }

    private void setUserText(String userText) {
        if (userText == null || userText.isEmpty()) {
            userText = this.controller.generateGroupVertexDescription(this.groupVertex.getVertices());
        }
        this.userText = userText;
        this.userTextArea.setText(userText);
        this.updateTextAreaSizeToForceTextLayout();
    }

    private void addToGroup() {
        Set<FGVertex> selectedVertices = this.controller.getSelectedVertices();
        this.controller.addToGroup(this.groupVertex, selectedVertices);
    }

    @Override
    public Dimension getPreferredSize() {
        int headerWidth;
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.width = headerWidth = this.genericHeader.getPreferredSize().width;
        return preferredSize;
    }

    private Color maybeUpdateUserDefinedColor() {
        FunctionGraphOptions options = this.controller.getFunctionGraphOptions();
        if (!options.getUpdateGroupColorsAutomatically()) {
            return null;
        }
        Set<FGVertex> vertices = this.groupVertex.getVertices();
        Color lastColor = null;
        for (FGVertex groupedVertex : vertices) {
            Color defaultVertexBackgroundColor;
            Color currentVertexBackgroundColor = groupedVertex.getBackgroundColor();
            if (lastColor == null) {
                lastColor = currentVertexBackgroundColor;
            }
            if (currentVertexBackgroundColor.equals(defaultVertexBackgroundColor = groupedVertex.getDefaultBackgroundColor())) {
                return null;
            }
            if (currentVertexBackgroundColor.equals(lastColor)) continue;
            return null;
        }
        return lastColor;
    }

    @Override
    Color getUserDefinedColor() {
        return this.userDefinedColor;
    }

    @Override
    void restoreColor(Color color) {
        this.doSetBackgroundColor(color);
    }

    @Override
    void setBackgroundColor(Color color) {
        this.userDefinedColor = color;
        this.doSetBackgroundColor(color);
    }

    @Override
    void clearColor() {
        this.userDefinedColor = null;
        this.doSetBackgroundColor(this.defaultBackgroundColor);
    }

    private void doSetBackgroundColor(Color color) {
        this.contentPanel.setBackground(color);
        this.userTextArea.setBackground(color);
        this.controller.removeColor(this.vertex);
        this.controller.repaint();
        if (color.equals(this.defaultBackgroundColor)) {
            return;
        }
        FunctionGraphOptions options = this.controller.getFunctionGraphOptions();
        if (!options.getUpdateGroupColorsAutomatically()) {
            return;
        }
        Set<FGVertex> vertices = this.groupVertex.getVertices();
        for (FGVertex groupedVertex : vertices) {
            groupedVertex.setBackgroundColor(color);
        }
    }

    @Override
    Color getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    @Override
    Color getBackgroundColor() {
        if (this.userDefinedColor != null) {
            return this.userDefinedColor;
        }
        return this.defaultBackgroundColor;
    }

    @Override
    JComponent getHeader() {
        return this.genericHeader;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Component source = event.getComponent();
        if (SwingUtilities.isDescendingFrom(source, (Component)this.genericHeader)) {
            if (!(source instanceof JComponent)) {
                return null;
            }
            JComponent jComponent = (JComponent)source;
            return jComponent.getToolTipText();
        }
        return null;
    }

    @Override
    ListingModel getListingModel(Address address) {
        FGVertex v = this.getVertex(address);
        if (v != null) {
            return v.getListingModel(address);
        }
        throw new AssertException("Unexpectedly called for an address not contained by my grouped vertex!");
    }

    @Override
    JComponent getToolTipComponentForEdge(FGEdge edge) {
        return this;
    }

    @Override
    JComponent getToolTipComponentForVertex() {
        return this;
    }

    @Override
    boolean isSelected() {
        return this.genericHeader.isSelected();
    }

    @Override
    void setSelected(boolean selected) {
        this.genericHeader.setSelected(selected);
    }

    @Override
    ProgramLocation getProgramLocation() {
        return new ProgramLocation(this.vertex.getProgram(), this.vertex.getVertexAddress());
    }

    @Override
    void setCursorPosition(ProgramLocation location) {
        Address address = location.getAddress();
        FGVertex v = this.getVertex(address);
        if (v != null) {
            v.setFocused(true);
            v.setProgramLocation(location);
        }
    }

    private FGVertex getVertex(Address a) {
        Set<FGVertex> vertices = this.groupVertex.getVertices();
        for (FGVertex v : vertices) {
            if (!v.containsAddress(a)) continue;
            return v;
        }
        return null;
    }

    @Override
    Rectangle getCursorBounds() {
        Set<FGVertex> vertices = this.groupVertex.getVertices();
        for (FGVertex v : vertices) {
            Rectangle cursorBounds = v.getCursorBounds();
            if (cursorBounds == null) continue;
            return cursorBounds;
        }
        return null;
    }

    @Override
    void setProgramSelection(ProgramSelection selection) {
        Set<FGVertex> vertices = this.groupVertex.getVertices();
        for (FGVertex v : vertices) {
            v.setProgramSelection(selection);
        }
    }

    @Override
    ProgramSelection getProgramSelection() {
        AddressSet addresses = new AddressSet();
        Set<FGVertex> vertices = this.groupVertex.getVertices();
        for (FGVertex v : vertices) {
            ProgramSelection programSelection = v.getProgramSelection();
            if (programSelection == null) continue;
            addresses.add((AddressSetView)programSelection);
        }
        return new ProgramSelection((AddressSetView)addresses);
    }

    @Override
    void setProgramHighlight(ProgramSelection highlight) {
        Set<FGVertex> vertices = this.groupVertex.getVertices();
        for (FGVertex v : vertices) {
            v.setProgramHighlight(highlight);
        }
    }

    @Override
    void doSetFocused(boolean focused) {
        this.genericHeader.setSelected(focused);
    }

    @Override
    void refreshModel() {
        Set<FGVertex> vertices = this.groupVertex.getVertices();
        for (FGVertex v : vertices) {
            v.refreshModel();
        }
    }

    @Override
    void refreshDisplay() {
        Set<FGVertex> vertices = this.groupVertex.getVertices();
        for (FGVertex v : vertices) {
            v.refreshDisplay();
        }
    }

    @Override
    void refreshDisplayForAddress(Address address) {
        Set<FGVertex> vertices = this.groupVertex.getVertices();
        for (FGVertex v : vertices) {
            v.refreshDisplayForAddress(address);
        }
    }

    @Override
    void setFullScreenMode(boolean fullScreen) {
    }

    @Override
    public boolean isFullScreenMode() {
        return false;
    }

    @Override
    Component getMaximizedViewComponent() {
        return null;
    }

    @Override
    void dispose() {
        this.removeAll();
        this.setVertexMostRecentAction.dispose();
        this.groupVertex = null;
        super.dispose();
    }
}

