/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.foundation.serialization;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import org.prevayler.foundation.serialization.Serializer;

public class DESSerializer
implements Serializer {
    private ThreadLocal _ciphers = new ThreadLocal(){

        protected Object initialValue() {
            try {
                return Cipher.getInstance(DESSerializer.this._triple ? "DESede" : "DES");
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private final Serializer _delegate;
    private final SecretKey _key;
    private final boolean _triple;

    public DESSerializer(Serializer delegate, byte[] key) throws GeneralSecurityException {
        this._delegate = delegate;
        if (key != null && key.length == 8) {
            this._triple = false;
        } else if (key != null && key.length == 24) {
            this._triple = true;
        } else {
            throw new IllegalArgumentException("Key must be 8 or 24 bytes");
        }
        KeySpec keySpec = this._triple ? new DESedeKeySpec(key) : new DESKeySpec(key);
        this._key = SecretKeyFactory.getInstance(this._triple ? "DESede" : "DES").generateSecret(keySpec);
    }

    @Override
    public void writeObject(OutputStream stream, Object object) throws Exception {
        Cipher cipher = this.getCipher();
        cipher.init(1, this._key);
        CipherOutputStream encrypt = new CipherOutputStream(stream, cipher);
        this._delegate.writeObject(encrypt, object);
        encrypt.close();
    }

    @Override
    public Object readObject(InputStream stream) throws Exception {
        Cipher cipher = this.getCipher();
        cipher.init(2, this._key);
        CipherInputStream decrypt = new CipherInputStream(stream, cipher);
        return this._delegate.readObject(decrypt);
    }

    private Cipher getCipher() throws GeneralSecurityException {
        try {
            return (Cipher)this._ciphers.get();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof GeneralSecurityException) {
                throw (GeneralSecurityException)e.getCause();
            }
            throw e;
        }
    }
}

