/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.FixedHandle;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighInstructionPrototype;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.SleighParserContext;
import ghidra.app.plugin.processors.sleigh.VarnodeData;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.TripleSymbol;
import ghidra.app.plugin.processors.sleigh.template.ConstTpl;
import ghidra.app.plugin.processors.sleigh.template.ConstructTpl;
import ghidra.app.plugin.processors.sleigh.template.OpTpl;
import ghidra.app.plugin.processors.sleigh.template.VarnodeTpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.address.UniqueAddressFactory;
import ghidra.program.model.lang.InstructionContext;
import ghidra.program.model.lang.UnknownContextException;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.PcodeOverride;
import ghidra.util.exception.NotYetImplementedException;
import java.util.ArrayList;

public abstract class PcodeEmit {
    private PcodeOverride override;
    private SleighParserContext parsercontext;
    private InstructionContext instcontext;
    private ParserWalker walker;
    private FlowOverride flowOverride;
    private Address startAddress;
    private Address defaultFallAddress;
    private Address fallOverride;
    private int fallOffset;
    private UniqueAddressFactory uniqueFactory;
    private VarnodeData outcache;
    protected VarnodeData[] incache;
    private VarnodeData[] dyncache;
    protected ArrayList<Integer> labeldef = null;
    protected int numOps = 0;
    private int labelbase = 0;
    private int labelcount = 0;
    private boolean inDelaySlot = false;
    private AddressSpace const_space;
    private AddressSpace uniq_space;
    private long uniquemask;
    private long uniqueoffset;
    private AddressSpace overlayspace = null;
    private AddressSpace overlayedspace = null;

    protected PcodeEmit() {
    }

    public PcodeEmit(ParserWalker walk, InstructionContext ictx, int fallOffset, PcodeOverride override, UniqueAddressFactory uniqueFactory) {
        this.walker = walk;
        this.parsercontext = walk.getParserContext();
        this.instcontext = ictx;
        this.const_space = walk.getConstSpace();
        this.startAddress = this.parsercontext.getAddr();
        AddressSpace myspace = this.startAddress.getAddressSpace();
        if (myspace.isOverlaySpace()) {
            this.overlayspace = myspace;
            this.overlayedspace = ((OverlayAddressSpace)myspace).getOverlayedSpace();
            this.startAddress = this.overlayedspace.getAddress(this.startAddress.getOffset());
        }
        this.fallOffset = fallOffset;
        this.uniqueFactory = uniqueFactory;
        this.override = override;
        SleighInstructionPrototype sleighproto = this.parsercontext.getPrototype();
        if (sleighproto != null) {
            SleighLanguage sleighlang = (SleighLanguage)sleighproto.getLanguage();
            this.uniq_space = sleighlang.getAddressFactory().getUniqueSpace();
            this.uniquemask = sleighlang.getUniqueAllocationMask();
            this.uniqueoffset = (this.startAddress.getOffset() & this.uniquemask) << 4;
        } else {
            this.uniq_space = null;
            this.uniquemask = 0L;
            this.uniqueoffset = 0L;
        }
        if (override != null) {
            if (uniqueFactory == null) {
                throw new IllegalArgumentException("uniqueFactory required when override is specified");
            }
            this.flowOverride = override.getFlowOverride();
            if (this.flowOverride == FlowOverride.NONE) {
                this.flowOverride = null;
            }
            this.fallOverride = override.getFallThroughOverride();
            if (this.fallOverride != null) {
                Address instrAddr = override.getInstructionStart();
                try {
                    this.defaultFallAddress = instrAddr.addNoWrap(fallOffset);
                    fallOffset = (int)this.fallOverride.subtract(instrAddr);
                }
                catch (AddressOverflowException e) {
                    this.fallOverride = null;
                    this.defaultFallAddress = null;
                }
            }
        }
        this.incache = new VarnodeData[8];
        this.dyncache = null;
    }

    private void setUniqueOffset(Address addr) {
        this.uniqueoffset = (addr.getOffset() & this.uniquemask) << 4;
    }

    public Address getStartAddress() {
        return this.startAddress;
    }

    public int getFallOffset() {
        return this.fallOffset;
    }

    public ParserWalker getWalker() {
        return this.walker;
    }

    private void setLabel(OpTpl op) {
        if (this.labeldef == null) {
            this.labeldef = new ArrayList();
        }
        int labelindex = (int)op.getInput()[0].getOffset().getReal() + this.labelbase;
        while (this.labeldef.size() <= labelindex) {
            this.labeldef.add(null);
        }
        this.labeldef.set(labelindex, this.numOps);
    }

    abstract void addLabelRef();

    public abstract void resolveRelatives();

    abstract void dump(Address var1, int var2, VarnodeData[] var3, int var4, VarnodeData var5);

    private boolean dumpBranchOverride(OpTpl opt) {
        int opcode = opt.getOpcode();
        VarnodeTpl[] inputs = opt.getInput();
        if (opcode == 7) {
            OpTpl callopt = new OpTpl(4, null, inputs);
            this.dump(callopt);
            this.flowOverride = null;
            return true;
        }
        if (opcode == 8 || opcode == 10) {
            OpTpl callopt = new OpTpl(6, null, inputs);
            this.dump(callopt);
            this.flowOverride = null;
            return true;
        }
        return false;
    }

    private void dumpNullReturn() {
        VarnodeTpl nullAddr = new VarnodeTpl(new ConstTpl(this.const_space), new ConstTpl(0, 0L), new ConstTpl(0, this.const_space.getPointerSize()));
        OpTpl retOpt = new OpTpl(10, null, new VarnodeTpl[]{nullAddr});
        this.dump(retOpt);
    }

    private boolean dumpCallOverride(OpTpl opt, boolean returnAfterCall) {
        int opcode = opt.getOpcode();
        VarnodeTpl[] inputs = opt.getInput();
        if (opcode == 4) {
            int offsetType = inputs[0].getOffset().getType();
            if (offsetType == 7 || offsetType == 2 || offsetType == 3) {
                return false;
            }
            OpTpl callopt = new OpTpl(7, null, inputs);
            this.dump(callopt);
            if (returnAfterCall) {
                this.dumpNullReturn();
            }
            this.flowOverride = null;
            return true;
        }
        if (opcode == 6 || opcode == 10) {
            OpTpl callopt = new OpTpl(8, null, inputs);
            this.dump(callopt);
            if (returnAfterCall) {
                this.dumpNullReturn();
            }
            this.flowOverride = null;
            return true;
        }
        if (opcode == 5) {
            int offsetType = inputs[0].getOffset().getType();
            if (offsetType == 7 || offsetType == 2 || offsetType == 3) {
                return false;
            }
            Address tmpAddr = this.uniqueFactory.getNextUniqueAddress();
            VarnodeTpl tmp = new VarnodeTpl(new ConstTpl(tmpAddr.getAddressSpace()), new ConstTpl(0, tmpAddr.getOffset()), inputs[1].getSize());
            int labelIndex = this.labelcount++;
            VarnodeTpl label = new VarnodeTpl(new ConstTpl(this.const_space), new ConstTpl(7, labelIndex), new ConstTpl(0, 8L));
            VarnodeTpl dest = inputs[0];
            VarnodeTpl cond = inputs[1];
            OpTpl negOpt = new OpTpl(37, tmp, new VarnodeTpl[]{cond});
            this.dump(negOpt);
            OpTpl cbranchOpt = new OpTpl(5, null, new VarnodeTpl[]{label, tmp});
            this.dump(cbranchOpt);
            OpTpl callOpt = new OpTpl(7, null, new VarnodeTpl[]{dest});
            this.dump(callOpt);
            if (returnAfterCall) {
                this.dumpNullReturn();
            }
            OpTpl labelOpt = new OpTpl(65, null, new VarnodeTpl[]{label});
            this.setLabel(labelOpt);
            this.flowOverride = null;
            return true;
        }
        if ((opcode == 7 || opcode == 8) && returnAfterCall) {
            this.dump(opt);
            this.dumpNullReturn();
            this.flowOverride = null;
            return true;
        }
        return false;
    }

    private boolean dumpReturnOverride(OpTpl opt) {
        int opcode = opt.getOpcode();
        VarnodeTpl[] inputs = opt.getInput();
        if (opcode == 4 || opcode == 7) {
            int offsetType = inputs[0].getOffset().getType();
            if (offsetType == 7 || offsetType == 2 || offsetType == 3) {
                return false;
            }
            AddressSpace defaultAddressSpace = this.walker.getCurSpace();
            int ptrSize = defaultAddressSpace.getPointerSize();
            Address tmpAddr = this.uniqueFactory.getNextUniqueAddress();
            VarnodeTpl tmp = new VarnodeTpl(new ConstTpl(tmpAddr.getAddressSpace()), new ConstTpl(0, tmpAddr.getOffset()), new ConstTpl(0, ptrSize));
            VarnodeTpl destAddr = new VarnodeTpl(new ConstTpl(this.const_space), inputs[0].getOffset(), new ConstTpl(0, ptrSize));
            OpTpl copyOpt = new OpTpl(1, tmp, new VarnodeTpl[]{destAddr});
            this.dump(copyOpt);
            OpTpl retOpt = new OpTpl(10, null, new VarnodeTpl[]{tmp});
            this.dump(retOpt);
            this.flowOverride = null;
            return true;
        }
        if (opcode == 6 || opcode == 8) {
            OpTpl callopt = new OpTpl(10, null, inputs);
            this.dump(callopt);
            this.flowOverride = null;
            return true;
        }
        if (opcode == 5) {
            int offsetType = inputs[0].getOffset().getType();
            if (offsetType == 7 || offsetType == 2 || offsetType == 3) {
                return false;
            }
            AddressSpace defaultAddressSpace = this.walker.getCurSpace();
            int ptrSize = defaultAddressSpace.getPointerSize();
            Address tmpAddr = this.uniqueFactory.getNextUniqueAddress();
            VarnodeTpl tmp = new VarnodeTpl(new ConstTpl(tmpAddr.getAddressSpace()), new ConstTpl(0, tmpAddr.getOffset()), inputs[1].getSize());
            tmpAddr = this.uniqueFactory.getNextUniqueAddress();
            VarnodeTpl tmp2 = new VarnodeTpl(new ConstTpl(tmpAddr.getAddressSpace()), new ConstTpl(0, tmpAddr.getOffset()), new ConstTpl(0, ptrSize));
            VarnodeTpl destAddr = new VarnodeTpl(new ConstTpl(this.const_space), inputs[0].getOffset(), new ConstTpl(0, ptrSize));
            int labelIndex = this.labelcount++;
            VarnodeTpl label = new VarnodeTpl(new ConstTpl(this.const_space), new ConstTpl(7, labelIndex), new ConstTpl(0, 8L));
            VarnodeTpl cond = inputs[1];
            OpTpl negOpt = new OpTpl(37, tmp, new VarnodeTpl[]{cond});
            this.dump(negOpt);
            OpTpl cbranchOpt = new OpTpl(5, null, new VarnodeTpl[]{label, tmp});
            this.dump(cbranchOpt);
            OpTpl copyOpt = new OpTpl(1, tmp2, new VarnodeTpl[]{destAddr});
            this.dump(copyOpt);
            OpTpl retOpt = new OpTpl(10, null, new VarnodeTpl[]{tmp2});
            this.dump(retOpt);
            OpTpl labelOpt = new OpTpl(65, null, new VarnodeTpl[]{label});
            this.setLabel(labelOpt);
            this.flowOverride = null;
            return true;
        }
        return false;
    }

    private boolean dumpFlowOverride(OpTpl opt) {
        if (this.flowOverride == null || opt.getOutput() != null) {
            return false;
        }
        if (this.flowOverride == FlowOverride.BRANCH) {
            return this.dumpBranchOverride(opt);
        }
        if (this.flowOverride == FlowOverride.CALL) {
            return this.dumpCallOverride(opt, false);
        }
        if (this.flowOverride == FlowOverride.CALL_RETURN) {
            return this.dumpCallOverride(opt, true);
        }
        if (this.flowOverride == FlowOverride.RETURN) {
            return this.dumpReturnOverride(opt);
        }
        return false;
    }

    private void generateLocation(VarnodeTpl vntpl, VarnodeData vn) {
        vn.space = vntpl.getSpace().fixSpace(this.walker);
        vn.size = (int)vntpl.getSize().fix(this.walker);
        vn.offset = vn.space == this.const_space ? vntpl.getOffset().fix(this.walker) & ConstTpl.calc_mask[vn.size > 8 ? 8 : vn.size] : (vn.space == this.uniq_space ? vntpl.getOffset().fix(this.walker) | this.uniqueoffset : vn.space.truncateOffset(vntpl.getOffset().fix(this.walker)));
    }

    private AddressSpace generatePointer(VarnodeTpl vntpl, VarnodeData vn) {
        FixedHandle hand = this.walker.getFixedHandle(vntpl.getOffset().getHandleIndex());
        vn.space = hand.offset_space;
        vn.size = hand.offset_size;
        vn.offset = vn.space == this.const_space ? hand.offset_offset & ConstTpl.calc_mask[vn.size] : (vn.space == this.uniq_space ? hand.offset_offset | this.uniqueoffset : vn.space.truncateOffset(hand.offset_offset));
        return hand.space;
    }

    private void dump(OpTpl opt) {
        VarnodeTpl outvn;
        int isize = opt.getInput().length;
        for (int i = 0; i < isize; ++i) {
            VarnodeTpl vn = opt.getInput()[i];
            this.incache[i] = new VarnodeData();
            if (vn.isDynamic(this.walker)) {
                this.dyncache = new VarnodeData[3];
                this.dyncache[0] = new VarnodeData();
                this.dyncache[1] = new VarnodeData();
                this.dyncache[2] = new VarnodeData();
                this.generateLocation(vn, this.incache[i]);
                this.dyncache[2].space = this.incache[i].space;
                this.dyncache[2].offset = this.incache[i].offset;
                this.dyncache[2].size = this.incache[i].size;
                AddressSpace spc = this.generatePointer(vn, this.dyncache[1]);
                this.dyncache[0].space = this.const_space;
                this.dyncache[0].offset = spc.getBaseSpaceID();
                this.dyncache[0].size = 4;
                this.dump(this.startAddress, 2, this.dyncache, 2, this.dyncache[2]);
                ++this.numOps;
                continue;
            }
            this.generateLocation(vn, this.incache[i]);
        }
        if (isize > 0 && opt.getInput()[0].isRelative()) {
            this.incache[0].offset += (long)this.labelbase;
            this.addLabelRef();
        }
        if ((outvn = opt.getOutput()) != null) {
            this.outcache = new VarnodeData();
            if (outvn.isDynamic(this.walker)) {
                if (this.dyncache == null) {
                    this.dyncache = new VarnodeData[3];
                    this.dyncache[0] = new VarnodeData();
                    this.dyncache[1] = new VarnodeData();
                    this.dyncache[2] = new VarnodeData();
                }
                this.generateLocation(outvn, this.outcache);
                this.dump(this.startAddress, opt.getOpcode(), this.incache, isize, this.outcache);
                ++this.numOps;
                this.dyncache[2].space = this.outcache.space;
                this.dyncache[2].offset = this.outcache.offset;
                this.dyncache[2].size = this.outcache.size;
                AddressSpace spc = this.generatePointer(outvn, this.dyncache[1]);
                this.dyncache[0].space = this.const_space;
                this.dyncache[0].offset = spc.getBaseSpaceID();
                this.dyncache[0].size = 4;
                this.dump(this.startAddress, 3, this.dyncache, 3, null);
                ++this.numOps;
            } else {
                this.generateLocation(outvn, this.outcache);
                this.dump(this.startAddress, opt.getOpcode(), this.incache, isize, this.outcache);
                ++this.numOps;
            }
        } else {
            this.dump(this.startAddress, opt.getOpcode(), this.incache, isize, null);
            ++this.numOps;
        }
    }

    private void appendBuild(OpTpl bld, int secnum) throws UnknownInstructionException, MemoryAccessException {
        int index = (int)bld.getInput()[0].getOffset().getReal();
        TripleSymbol sym = this.walker.getConstructor().getOperand(index).getDefiningSymbol();
        if (sym == null || !(sym instanceof SubtableSymbol)) {
            return;
        }
        this.walker.pushOperand(index);
        Constructor ct = this.walker.getConstructor();
        if (secnum >= 0) {
            ConstructTpl construct = ct.getNamedTempl(secnum);
            if (construct == null) {
                this.buildEmpty(ct, secnum);
            } else {
                this.build(construct, secnum);
            }
        } else {
            ConstructTpl construct = ct.getTempl();
            this.build(construct, -1);
        }
        this.walker.popOperand();
    }

    private void delaySlot(OpTpl op) throws UnknownInstructionException, MemoryAccessException {
        int len;
        if (this.inDelaySlot) {
            throw new SleighException("Delay Slot recursion problem for Instruction at " + this.walker.getAddr());
        }
        this.inDelaySlot = true;
        Address baseaddr = this.parsercontext.getAddr();
        int falloffset = this.parsercontext.getPrototype().getLength();
        int delaySlotByteCnt = this.parsercontext.getPrototype().getDelaySlotByteCount();
        ParserWalker oldwalker = this.walker;
        long olduniqueoffset = this.uniqueoffset;
        int bytecount = 0;
        do {
            Address addr = baseaddr.add(falloffset);
            this.setUniqueOffset(addr);
            try {
                this.parsercontext = (SleighParserContext)this.instcontext.getParserContext(addr);
            }
            catch (UnknownContextException e) {
                throw new UnknownInstructionException("Could not find cached delayslot parser context");
            }
            len = this.parsercontext.getPrototype().getLength();
            this.walker = new ParserWalker(this.parsercontext);
            this.walker.baseState();
            this.build(this.walker.getConstructor().getTempl(), -1);
            falloffset += len;
        } while ((bytecount += len) < delaySlotByteCnt);
        this.walker = oldwalker;
        this.parsercontext = this.walker.getParserContext();
        this.uniqueoffset = olduniqueoffset;
        this.inDelaySlot = false;
    }

    private void appendCrossBuild(OpTpl bld, int secnum) throws UnknownInstructionException, MemoryAccessException {
        if (secnum >= 0) {
            throw new SleighException("CROSSBUILD recursion problem for instruction at " + this.walker.getAddr());
        }
        secnum = (int)bld.getInput()[1].getOffset().getReal();
        VarnodeTpl vn = bld.getInput()[0];
        AddressSpace spc = vn.getSpace().fixSpace(this.walker);
        Address addr = spc.getTruncatedAddress(vn.getOffset().fix(this.walker), false);
        if (this.overlayspace != null) {
            addr = this.overlayspace.getOverlayAddress(addr);
        }
        ParserWalker oldwalker = this.walker;
        long olduniqueoffset = this.uniqueoffset;
        this.setUniqueOffset(addr);
        try {
            this.parsercontext = (SleighParserContext)this.instcontext.getParserContext(addr);
        }
        catch (UnknownContextException e) {
            throw new UnknownInstructionException("Could not find cached crossbuild parser context");
        }
        this.walker = new ParserWalker(this.parsercontext, oldwalker.getParserContext());
        this.walker.baseState();
        Constructor ct = this.walker.getConstructor();
        ConstructTpl construct = ct.getNamedTempl(secnum);
        if (construct == null) {
            this.buildEmpty(ct, secnum);
        } else {
            this.build(construct, secnum);
        }
        this.walker = oldwalker;
        this.parsercontext = this.walker.getParserContext();
        this.uniqueoffset = olduniqueoffset;
    }

    public void build(ConstructTpl construct, int secnum) throws UnknownInstructionException, MemoryAccessException {
        if (construct == null) {
            throw new NotYetImplementedException("Semantics for this instruction are not implemented");
        }
        int oldbase = this.labelbase;
        this.labelbase = this.labelcount;
        this.labelcount += construct.getNumLabels();
        OpTpl[] optpllist = construct.getOpVec();
        block6: for (int i = 0; i < optpllist.length; ++i) {
            OpTpl op = optpllist[i];
            switch (op.getOpcode()) {
                case 60: {
                    this.appendBuild(op, secnum);
                    continue block6;
                }
                case 61: {
                    this.delaySlot(op);
                    continue block6;
                }
                case 65: {
                    this.setLabel(op);
                    continue block6;
                }
                case 66: {
                    this.appendCrossBuild(op, secnum);
                    continue block6;
                }
                default: {
                    if (!this.inDelaySlot && this.flowOverride != null && this.dumpFlowOverride(op)) continue block6;
                    this.dump(op);
                }
            }
        }
        this.labelbase = oldbase;
    }

    private void buildEmpty(Constructor ct, int secnum) throws UnknownInstructionException, MemoryAccessException {
        int numops = ct.getNumOperands();
        for (int i = 0; i < numops; ++i) {
            TripleSymbol sym = ct.getOperand(i).getDefiningSymbol();
            if (sym == null || !(sym instanceof SubtableSymbol)) continue;
            this.walker.pushOperand(i);
            ConstructTpl construct = this.walker.getConstructor().getNamedTempl(secnum);
            if (construct == null) {
                this.buildEmpty(this.walker.getConstructor(), secnum);
            } else {
                this.build(construct, secnum);
            }
            this.walker.popOperand();
        }
    }

    void checkOverlays(int opcode, VarnodeData[] in, int isize, VarnodeData out) {
        if (this.uniqueFactory == null) {
            return;
        }
        if (opcode == 2 || opcode == 3) {
            int spaceId = (int)in[0].offset;
            AddressSpace space = this.uniqueFactory.getAddressFactory().getAddressSpace(spaceId);
            if (space.isOverlaySpace()) {
                space = ((OverlayAddressSpace)space).getOverlayedSpace();
                in[0].offset = space.getBaseSpaceID();
            }
        }
        if (this.overlayspace != null) {
            for (int i = 0; i < isize; ++i) {
                VarnodeData v = in[0];
                if (!v.space.equals(this.overlayspace)) continue;
                v.space = ((OverlayAddressSpace)v.space).getOverlayedSpace();
            }
            if (out != null && out.space.equals(this.overlayspace)) {
                out.space = ((OverlayAddressSpace)out.space).getOverlayedSpace();
            }
        }
    }

    void checkOverrides(int opcode, VarnodeData[] in) {
        Address callRef;
        if (this.override == null) {
            return;
        }
        if (opcode == 7 && !this.override.hasCallFixup(in[0].space.getAddress(in[0].offset)) && (callRef = this.override.getPrimaryCallReference()) != null) {
            VarnodeData dest = in[0];
            dest.space = callRef.getAddressSpace();
            dest.offset = callRef.getOffset();
            dest.size = dest.space.getPointerSize();
        }
        if (this.fallOverride != null && (opcode == 5 || opcode == 4)) {
            VarnodeData dest = in[0];
            if (this.defaultFallAddress.getOffset() == dest.offset) {
                dest.space = this.fallOverride.getAddressSpace();
                dest.offset = this.fallOverride.getOffset();
                dest.size = dest.space.getPointerSize();
            }
        }
    }
}

