/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import generic.stl.IteratorSTL;
import generic.stl.VectorSTL;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slghsymbol.Constructor;
import ghidra.pcodeCPort.slghsymbol.ContextSymbol;
import ghidra.pcodeCPort.slghsymbol.EndSymbol;
import ghidra.pcodeCPort.slghsymbol.EpsilonSymbol;
import ghidra.pcodeCPort.slghsymbol.MacroSymbol;
import ghidra.pcodeCPort.slghsymbol.NameSymbol;
import ghidra.pcodeCPort.slghsymbol.OperandSymbol;
import ghidra.pcodeCPort.slghsymbol.SleighSymbol;
import ghidra.pcodeCPort.slghsymbol.StartSymbol;
import ghidra.pcodeCPort.slghsymbol.SubtableSymbol;
import ghidra.pcodeCPort.slghsymbol.SymbolScope;
import ghidra.pcodeCPort.slghsymbol.UserOpSymbol;
import ghidra.pcodeCPort.slghsymbol.ValueMapSymbol;
import ghidra.pcodeCPort.slghsymbol.ValueSymbol;
import ghidra.pcodeCPort.slghsymbol.VarnodeListSymbol;
import ghidra.pcodeCPort.slghsymbol.VarnodeSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.utils.XmlUtils;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class SymbolTable {
    private VectorSTL<SleighSymbol> symbollist = new VectorSTL();
    private VectorSTL<SymbolScope> table = new VectorSTL();
    private SymbolScope curscope = null;
    private static final String NEWLINE = System.getProperty("line.separator");

    public SymbolScope getCurrentScope() {
        return this.curscope;
    }

    public SymbolScope getGlobalScope() {
        return (SymbolScope)this.table.get(0);
    }

    public void setCurrentScope(SymbolScope scope) {
        this.curscope = scope;
    }

    public VectorSTL<SleighSymbol> getUnsoughtSymbols() {
        VectorSTL result = new VectorSTL();
        IteratorSTL siter = this.symbollist.begin();
        while (!siter.isEnd()) {
            SleighSymbol sleighSymbol = (SleighSymbol)siter.get();
            if (!sleighSymbol.wasSought()) {
                result.push_back((Object)sleighSymbol);
            }
            siter.increment();
        }
        return result;
    }

    public SleighSymbol findSymbol(String nm) {
        return this.findSymbolInternal(this.curscope, nm);
    }

    public SleighSymbol findSymbol(String nm, int skip) {
        return this.findSymbolInternal(this.skipScope(skip), nm);
    }

    public SleighSymbol findGlobalSymbol(String nm) {
        return this.findSymbolInternal((SymbolScope)this.table.get(0), nm);
    }

    public SleighSymbol findSymbol(int id) {
        SleighSymbol sleighSymbol = (SleighSymbol)this.symbollist.get(id);
        sleighSymbol.setWasSought(true);
        return sleighSymbol;
    }

    public void dispose() {
        IteratorSTL iter = this.table.begin();
        while (!iter.isEnd()) {
            ((SymbolScope)iter.get()).dispose();
            iter.increment();
        }
        IteratorSTL siter = this.symbollist.begin();
        while (!siter.isEnd()) {
            ((SleighSymbol)siter.get()).dispose();
            siter.increment();
        }
    }

    public void addScope() {
        this.curscope = new SymbolScope(this.curscope, this.table.size());
        this.table.push_back((Object)this.curscope);
    }

    public void popScope() {
        if (this.curscope != null) {
            this.curscope = this.curscope.getParent();
        }
    }

    private SymbolScope skipScope(int i) {
        SymbolScope res = this.curscope;
        while (i > 0) {
            if (res.parent == null) {
                return res;
            }
            res = res.parent;
            --i;
        }
        return res;
    }

    public void addGlobalSymbol(SleighSymbol a) {
        a.id = this.symbollist.size();
        this.symbollist.push_back((Object)a);
        SymbolScope scope = this.getGlobalScope();
        a.scopeid = scope.getId();
        SleighSymbol res = scope.addSymbol(a);
        if (res != a) {
            throw new SleighError("Duplicate symbol name: " + a.getName() + " (previously defined at " + res.location + ")", a.getLocation());
        }
    }

    public int addSymbol(SleighSymbol a) {
        a.id = this.symbollist.size();
        this.symbollist.push_back((Object)a);
        a.scopeid = this.curscope.getId();
        SleighSymbol res = this.curscope.addSymbol(a);
        if (res != a) {
            throw new SleighError("Duplicate symbol name: " + a.getName() + " (previously defined at " + res.location + ")", a.getLocation());
        }
        return a.id;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (SymbolScope scope = this.curscope; scope != null; scope = scope.getParent()) {
            sb.append(scope);
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private SleighSymbol findSymbolInternal(SymbolScope scope, String nm) {
        while (scope != null) {
            SleighSymbol res = scope.findSymbol(nm);
            if (res != null) {
                res.setWasSought(true);
                return res;
            }
            scope = scope.getParent();
        }
        return null;
    }

    public void replaceSymbol(SleighSymbol a, SleighSymbol b) {
        for (int i = this.table.size() - 1; i >= 0; --i) {
            SleighSymbol sym = ((SymbolScope)this.table.get(i)).findSymbol(a.getName());
            if (sym != a) continue;
            ((SymbolScope)this.table.get(i)).removeSymbol(a);
            b.id = a.id;
            b.scopeid = a.scopeid;
            this.symbollist.set(b.id, (Object)b);
            ((SymbolScope)this.table.get(i)).addSymbol(b);
            a.dispose();
            return;
        }
    }

    public void saveXml(PrintStream s) {
        int i;
        s.append("<symbol_table");
        s.append(" scopesize=\"");
        s.print(this.table.size());
        s.append("\"");
        s.append(" symbolsize=\"");
        s.print(this.symbollist.size());
        s.append("\">\n");
        for (i = 0; i < this.table.size(); ++i) {
            s.append("<scope id=\"0x");
            s.append(Long.toHexString(((SymbolScope)this.table.get(i)).getId()));
            s.append("\"");
            s.append(" parent=\"0x");
            if (((SymbolScope)this.table.get(i)).getParent() == null) {
                s.append("0");
            } else {
                s.append(Long.toHexString(((SymbolScope)this.table.get(i)).getParent().getId()));
            }
            s.append("\"/>\n");
        }
        for (i = 0; i < this.symbollist.size(); ++i) {
            ((SleighSymbol)this.symbollist.get(i)).saveXmlHeader(s);
        }
        for (i = 0; i < this.symbollist.size(); ++i) {
            ((SleighSymbol)this.symbollist.get(i)).saveXml(s);
        }
        s.append("</symbol_table>\n");
    }

    public void restoreXml(Element el, SleighBase trans) {
        int i;
        int i2;
        int size = XmlUtils.decodeUnknownInt(el.getAttributeValue("scopesize"));
        for (i2 = 0; i2 < size; ++i2) {
            this.table.push_back(null);
        }
        size = XmlUtils.decodeUnknownInt(el.getAttributeValue("symbolsize"));
        for (i2 = 0; i2 < size; ++i2) {
            this.symbollist.push_back(null);
        }
        List list = el.getChildren();
        Iterator iter = list.iterator();
        for (i = 0; i < this.table.size(); ++i) {
            Element subel = (Element)iter.next();
            if (!subel.getName().equals("scope")) {
                throw new SleighError("Misnumbered symbol scopes", null);
            }
            int id = XmlUtils.decodeUnknownInt(subel.getAttributeValue("id"));
            int parent = XmlUtils.decodeUnknownInt(subel.getAttributeValue("parent"));
            SymbolScope parscope = parent == id ? null : (SymbolScope)this.table.get(parent);
            this.table.set(id, (Object)new SymbolScope(parscope, id));
        }
        this.curscope = (SymbolScope)this.table.get(0);
        for (i = 0; i < this.symbollist.size(); ++i) {
            Element child = (Element)iter.next();
            this.restoreSymbolHeader(child);
        }
        while (iter.hasNext()) {
            Element subel = (Element)iter.next();
            int id = XmlUtils.decodeUnknownInt(subel.getAttributeValue("id"));
            SleighSymbol sym = this.findSymbol(id);
            sym.restoreXml(subel, trans);
        }
    }

    public void restoreSymbolHeader(Element el) {
        SleighSymbol sym;
        Location location = null;
        if (el.getName().equals("userop_head")) {
            sym = new UserOpSymbol(location);
        } else if (el.getName().equals("epsilon_sym_head")) {
            sym = new EpsilonSymbol(location);
        } else if (el.getName().equals("value_sym_head")) {
            sym = new ValueSymbol(location);
        } else if (el.getName().equals("valuemap_sym_head")) {
            sym = new ValueMapSymbol(location);
        } else if (el.getName().equals("name_sym_head")) {
            sym = new NameSymbol(location);
        } else if (el.getName().equals("varnode_sym_head")) {
            sym = new VarnodeSymbol(location);
        } else if (el.getName().equals("context_sym_head")) {
            sym = new ContextSymbol(location);
        } else if (el.getName().equals("varlist_sym_head")) {
            sym = new VarnodeListSymbol(location);
        } else if (el.getName().equals("operand_sym_head")) {
            sym = new OperandSymbol(location);
        } else if (el.getName().equals("start_sym_head")) {
            sym = new StartSymbol(location);
        } else if (el.getName().equals("end_sym_head")) {
            sym = new EndSymbol(location);
        } else if (el.getName().equals("subtable_sym_head")) {
            sym = new SubtableSymbol(location);
        } else {
            throw new SleighError("Bad symbol xml", null);
        }
        sym.restoreXmlHeader(el);
        this.symbollist.set(sym.id, (Object)sym);
        ((SymbolScope)this.table.get(sym.scopeid)).addSymbol(sym);
    }

    public void purge() {
        block5: for (int symbolIndex = 0; symbolIndex < this.symbollist.size(); ++symbolIndex) {
            SleighSymbol sym = (SleighSymbol)this.symbollist.get(symbolIndex);
            if (sym == null) continue;
            if (sym.scopeid != 0) {
                if (sym.getType() == symbol_type.operand_symbol) {
                    continue;
                }
            } else {
                switch (sym.getType()) {
                    case space_symbol: 
                    case token_symbol: 
                    case epsilon_symbol: 
                    case section_symbol: {
                        break;
                    }
                    case macro_symbol: {
                        MacroSymbol macro = (MacroSymbol)sym;
                        for (int macroIndex = 0; macroIndex < macro.getNumOperands(); ++macroIndex) {
                            OperandSymbol opersym = macro.getOperand(macroIndex);
                            ((SymbolScope)this.table.get(opersym.scopeid)).removeSymbol(opersym);
                            this.symbollist.set(opersym.id, null);
                            ((SleighSymbol)opersym).dispose();
                        }
                        break;
                    }
                    case subtable_symbol: {
                        SubtableSymbol subsym = (SubtableSymbol)sym;
                        if (subsym.getPattern() != null) continue block5;
                        for (int subtableIndex = 0; subtableIndex < subsym.getNumConstructors(); ++subtableIndex) {
                            Constructor con = subsym.getConstructor(subtableIndex);
                            for (int operandIndex = 0; operandIndex < con.getNumOperands(); ++operandIndex) {
                                OperandSymbol oper = con.getOperand(operandIndex);
                                ((SymbolScope)this.table.get(oper.scopeid)).removeSymbol(oper);
                                this.symbollist.set(oper.id, null);
                                oper.dispose();
                            }
                        }
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
            }
            ((SymbolScope)this.table.get(sym.scopeid)).removeSymbol(sym);
            this.symbollist.set(symbolIndex, null);
            sym.dispose();
        }
        for (int tableIndex = 1; tableIndex < this.table.size(); ++tableIndex) {
            if (!((SymbolScope)this.table.get((int)tableIndex)).tree.isEmpty()) continue;
            ((SymbolScope)this.table.get(tableIndex)).dispose();
            this.table.set(tableIndex, null);
        }
        this.renumber();
    }

    private void renumber() {
        VectorSTL newtable = new VectorSTL();
        VectorSTL newsymbol = new VectorSTL();
        SymbolScope scope = null;
        for (int i = 0; i < this.table.size(); ++i) {
            scope = (SymbolScope)this.table.get(i);
            if (scope == null) continue;
            scope.id = newtable.size();
            newtable.push_back((Object)scope);
        }
        SleighSymbol sym = null;
        for (int i = 0; i < this.symbollist.size(); ++i) {
            sym = (SleighSymbol)this.symbollist.get(i);
            if (sym == null) continue;
            sym.scopeid = ((SymbolScope)this.table.get((int)sym.scopeid)).id;
            sym.id = newsymbol.size();
            newsymbol.push_back((Object)sym);
        }
        this.table = newtable;
        this.symbollist = newsymbol;
    }
}

