/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import db.DBHandle;
import db.buffers.BufferFile;
import db.buffers.LocalBufferFile;
import db.buffers.ManagedBufferFile;
import ghidra.framework.data.DBContentHandler;
import ghidra.framework.data.DomainObjectAdapter;
import ghidra.framework.data.DomainObjectMergeManager;
import ghidra.framework.model.ChangeSet;
import ghidra.framework.model.DomainObject;
import ghidra.framework.store.DatabaseItem;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.FolderItem;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.ProgramDBChangeSet;
import ghidra.program.database.ProgramMultiUserMergeManagerFactory;
import ghidra.program.database.ProgramUserDataDB;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class ProgramContentHandler
extends DBContentHandler {
    public static ImageIcon PROGRAM_ICON = ResourceManager.loadImage((String)"images/program_obj.png");
    public static final String PROGRAM_CONTENT_TYPE = "Program";

    public long createFile(FileSystem fs, FileSystem userfs, String path, String name, DomainObject obj, TaskMonitor monitor) throws IOException, InvalidNameException, CancelledException {
        if (!(obj instanceof ProgramDB)) {
            throw new IOException("Unsupported domain object: " + obj.getClass().getName());
        }
        return this.createFile((ProgramDB)obj, PROGRAM_CONTENT_TYPE, fs, path, name, monitor);
    }

    public DomainObjectAdapter getImmutableObject(FolderItem item, Object consumer, int version, int minChangeVersion, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        String contentType = item.getContentType();
        if (contentType != null && !contentType.equals(PROGRAM_CONTENT_TYPE)) {
            throw new IOException("Unsupported content type: " + contentType);
        }
        DatabaseItem dbItem = (DatabaseItem)item;
        ManagedBufferFile bf = null;
        DBHandle dbh = null;
        ProgramDB program = null;
        boolean success = false;
        try {
            bf = dbItem.open(version, minChangeVersion);
            dbh = new DBHandle((BufferFile)bf);
            int openMode = 2;
            program = new ProgramDB(dbh, openMode, monitor, consumer);
            this.getProgramChangeSet(program, bf);
            success = true;
            ProgramDB programDB = program;
            return programDB;
        }
        catch (VersionException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (CancelledException e) {
            throw e;
        }
        catch (Throwable t) {
            Msg.error((Object)((Object)this), (Object)"getImmutableObject failed", (Throwable)t);
            String msg = t.getMessage();
            if (msg == null) {
                msg = t.toString();
            }
            throw new IOException("Open failed: " + msg);
        }
        finally {
            if (!success) {
                if (program != null) {
                    program.release(consumer);
                }
                if (dbh != null) {
                    dbh.close();
                }
                if (bf != null) {
                    bf.dispose();
                }
            }
        }
    }

    public DomainObjectAdapter getReadOnlyObject(FolderItem item, int version, boolean okToUpgrade, Object consumer, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        String contentType = item.getContentType();
        if (contentType != null && !contentType.equals(PROGRAM_CONTENT_TYPE)) {
            throw new IOException("Unsupported content type: " + contentType);
        }
        DatabaseItem dbItem = (DatabaseItem)item;
        ManagedBufferFile bf = null;
        DBHandle dbh = null;
        ProgramDB program = null;
        boolean success = false;
        try {
            bf = dbItem.open(version);
            dbh = new DBHandle((BufferFile)bf);
            int openMode = okToUpgrade ? 3 : 1;
            program = new ProgramDB(dbh, openMode, monitor, consumer);
            this.getProgramChangeSet(program, bf);
            program.setProgramUserData(new ProgramUserDataDB(program));
            success = true;
            ProgramDB programDB = program;
            return programDB;
        }
        catch (VersionException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (CancelledException e) {
            throw e;
        }
        catch (Throwable t) {
            Msg.error((Object)((Object)this), (Object)"getReadOnlyObject failed", (Throwable)t);
            t.printStackTrace();
            String msg = t.getMessage();
            if (msg == null) {
                msg = t.toString();
            }
            throw new IOException("Open failed: " + msg);
        }
        finally {
            if (!success) {
                if (program != null) {
                    program.release(consumer);
                }
                if (dbh != null) {
                    dbh.close();
                }
                if (bf != null) {
                    bf.dispose();
                }
            }
        }
    }

    public DomainObjectAdapter getDomainObject(FolderItem item, FileSystem userfs, long checkoutId, boolean okToUpgrade, boolean recover, Object consumer, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        String contentType = item.getContentType();
        if (contentType != null && !contentType.equals(PROGRAM_CONTENT_TYPE)) {
            throw new IOException("Unsupported content type: " + contentType);
        }
        DatabaseItem dbItem = (DatabaseItem)item;
        ManagedBufferFile bf = null;
        DBHandle dbh = null;
        ProgramDB program = null;
        boolean success = false;
        try {
            bf = dbItem.openForUpdate(checkoutId);
            dbh = new DBHandle((BufferFile)bf, recover, monitor);
            int openMode = okToUpgrade ? 3 : 1;
            program = new ProgramDB(dbh, openMode, monitor, consumer);
            if (checkoutId == -1L) {
                this.getProgramChangeSet(program, bf);
            }
            if (recover) {
                this.recoverChangeSet(program, dbh);
                program.setChanged(true);
            }
            program.setProgramUserData(this.getProgramUserData(program, (FolderItem)dbItem, userfs, monitor));
            success = true;
            ProgramDB programDB = program;
            return programDB;
        }
        catch (VersionException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (CancelledException e) {
            throw e;
        }
        catch (Throwable t) {
            Msg.error((Object)((Object)this), (Object)"getDomainObject failed", (Throwable)t);
            String msg = t.getMessage();
            if (msg == null) {
                msg = t.toString();
            }
            throw new IOException("Open failed: " + msg);
        }
        finally {
            if (!success) {
                if (program != null) {
                    program.release(consumer);
                }
                if (dbh != null) {
                    dbh.close();
                }
                if (bf != null) {
                    bf.dispose();
                }
            }
        }
    }

    private ProgramUserDataDB getProgramUserData(ProgramDB program, FolderItem programItem, FileSystem userfs, TaskMonitor monitor) throws CancelledException, IOException, VersionException {
        if (userfs == null) {
            return null;
        }
        DBHandle userDbh = this.openAssociatedUserFile(programItem.getFileID(), PROGRAM_CONTENT_TYPE, userfs, monitor);
        if (userDbh != null) {
            return new ProgramUserDataDB(userDbh, program, monitor);
        }
        return new ProgramUserDataDB(program);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverChangeSet(ProgramDB program, DBHandle dbh) throws IOException {
        ProgramDBChangeSet changeSet = (ProgramDBChangeSet)program.getChangeSet();
        LocalBufferFile cf = dbh.getRecoveryChangeSetFile();
        if (cf != null) {
            DBHandle cfh = null;
            try {
                cfh = new DBHandle((BufferFile)cf);
                changeSet.read(cfh);
            }
            finally {
                if (cfh != null) {
                    cfh.close();
                }
                cf.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProgramDBChangeSet getProgramChangeSet(ProgramDB program, ManagedBufferFile bf) throws IOException {
        ProgramDBChangeSet changeSet = (ProgramDBChangeSet)program.getChangeSet();
        BufferFile cf = bf.getNextChangeDataFile(true);
        DBHandle cfh = null;
        while (cf != null) {
            try {
                cfh = new DBHandle(cf);
                changeSet.read(cfh);
            }
            finally {
                if (cfh != null) {
                    cfh.close();
                    cfh = null;
                }
                cf.dispose();
            }
            cf = bf.getNextChangeDataFile(false);
        }
        return changeSet;
    }

    public ChangeSet getChangeSet(FolderItem item, int fromVer, int toVer) throws VersionException, IOException {
        String contentType = item.getContentType();
        if (contentType != null && !contentType.equals(PROGRAM_CONTENT_TYPE)) {
            throw new IOException("Unsupported content type: " + contentType);
        }
        DatabaseItem dbItem = (DatabaseItem)item;
        ManagedBufferFile bf = null;
        DBHandle dbh = null;
        ProgramDB program = null;
        try {
            bf = dbItem.open(toVer, fromVer);
            dbh = new DBHandle((BufferFile)bf);
            int openMode = 2;
            program = new ProgramDB(dbh, openMode, null, (Object)this);
            ProgramDBChangeSet programDBChangeSet = this.getProgramChangeSet(program, bf);
            return programDBChangeSet;
        }
        catch (VersionException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            Msg.error((Object)((Object)this), (Object)"getChangeSet failed", (Throwable)t);
            String msg = t.getMessage();
            if (msg == null) {
                msg = t.toString();
            }
            throw new IOException("Open failed: " + msg);
        }
        finally {
            if (program != null) {
                program.release((Object)this);
            }
            if (dbh != null) {
                dbh.close();
            }
            if (bf != null) {
                bf.dispose();
            }
        }
    }

    public Class<? extends DomainObject> getDomainObjectClass() {
        return ProgramDB.class;
    }

    public String getContentType() {
        return PROGRAM_CONTENT_TYPE;
    }

    public String getContentTypeDisplayString() {
        return PROGRAM_CONTENT_TYPE;
    }

    public String getDefaultToolName() {
        return "CodeBrowser";
    }

    public Icon getIcon() {
        return PROGRAM_ICON;
    }

    public boolean isPrivateContentType() {
        return false;
    }

    public DomainObjectMergeManager getMergeManager(DomainObject resultsObj, DomainObject sourceObj, DomainObject originalObj, DomainObject latestObj) {
        return ProgramMultiUserMergeManagerFactory.getMergeManager(resultsObj, sourceObj, originalObj, latestObj);
    }
}

