/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.Record;
import db.RecordIterator;
import db.Table;
import db.util.ErrorHandler;
import generic.jar.ResourceFile;
import ghidra.app.plugin.core.datamgr.archive.BuiltInSourceArchive;
import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.framework.store.db.PackedDBHandle;
import ghidra.framework.store.db.PackedDatabase;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.data.ArrayDB;
import ghidra.program.database.data.ArrayDBAdapter;
import ghidra.program.database.data.BuiltinDBAdapter;
import ghidra.program.database.data.CategoryDB;
import ghidra.program.database.data.CategoryDBAdapter;
import ghidra.program.database.data.ComponentDBAdapter;
import ghidra.program.database.data.CompositeDB;
import ghidra.program.database.data.CompositeDBAdapter;
import ghidra.program.database.data.DataTypeDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.database.data.EnumDB;
import ghidra.program.database.data.EnumDBAdapter;
import ghidra.program.database.data.EnumValueDBAdapter;
import ghidra.program.database.data.FunctionDefinitionDB;
import ghidra.program.database.data.FunctionDefinitionDBAdapter;
import ghidra.program.database.data.FunctionParameterAdapter;
import ghidra.program.database.data.InstanceSettingsDB;
import ghidra.program.database.data.InstanceSettingsDBAdapter;
import ghidra.program.database.data.InstanceSettingsDBAdapterV0;
import ghidra.program.database.data.ParentChildAdapter;
import ghidra.program.database.data.PointerDB;
import ghidra.program.database.data.PointerDBAdapter;
import ghidra.program.database.data.SettingsCache;
import ghidra.program.database.data.SettingsDBAdapter;
import ghidra.program.database.data.SettingsDBManager;
import ghidra.program.database.data.SourceArchiveAdapter;
import ghidra.program.database.data.SourceArchiveDB;
import ghidra.program.database.data.SourceArchiveUpgradeMap;
import ghidra.program.database.data.StructureDB;
import ghidra.program.database.data.TypedefDB;
import ghidra.program.database.data.TypedefDBAdapter;
import ghidra.program.database.data.UnionDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.KeyRange;
import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BadDataType;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.DataTypeManagerChangeListenerHandler;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.InvalidatedListener;
import ghidra.program.model.data.MissingBuiltInDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.util.InvalidNameException;
import ghidra.util.Lock;
import ghidra.util.Msg;
import ghidra.util.UniversalID;
import ghidra.util.UniversalIdGenerator;
import ghidra.util.UserSearchUtils;
import ghidra.util.classfinder.ClassTranslator;
import ghidra.util.datastruct.LongObjectHashtable;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class DataTypeManagerDB
implements DataTypeManager {
    static long ROOT_CATEGORY_ID = 0L;
    static final int BUILT_IN = 0;
    static final int COMPOSITE = 1;
    static final int COMPONENT = 2;
    static final int ARRAY = 3;
    static final int POINTER = 4;
    static final int TYPEDEF = 5;
    static final int FUNCTION_DEF = 6;
    static final int PARAMETER = 7;
    static final int ENUM = 8;
    private BuiltinDBAdapter builtinAdapter;
    private ComponentDBAdapter componentAdapter;
    private CompositeDBAdapter compositeAdapter;
    private ArrayDBAdapter arrayAdapter;
    private PointerDBAdapter pointerAdapter;
    private TypedefDBAdapter typedefAdapter;
    private SettingsDBAdapter settingsAdapter;
    private InstanceSettingsDBAdapter instanceSettingsAdapter;
    private CategoryDBAdapter categoryAdapter;
    private FunctionDefinitionDBAdapter functionDefAdapter;
    private FunctionParameterAdapter paramAdapter;
    private EnumDBAdapter enumAdapter;
    private EnumValueDBAdapter enumValueAdapter;
    private ParentChildAdapter parentChildAdapter;
    protected SourceArchiveAdapter sourceArchiveAdapter;
    protected DBHandle dbHandle;
    private AddressMap addrMap;
    private ErrorHandler errHandler;
    private DataTypeConflictHandler currentHandler;
    private CategoryDB root;
    private DBObjectCache<DataTypeDB> dtCache;
    private DBObjectCache<SourceArchiveDB> sourceArchiveDBCache;
    private HashMap<Long, DataType> builtInMap = new HashMap();
    private HashMap<DataType, Long> builtIn2IdMap = new HashMap();
    private DBObjectCache<CategoryDB> catCache = new DBObjectCache(50);
    private SettingsCache settingsCache = new SettingsCache();
    private List<DataType> sortedDataTypes;
    private Map<Long, Set<String>> enumValueMap;
    private List<InvalidatedListener> invalidatedListeners = new ArrayList<InvalidatedListener>();
    protected DataTypeManagerChangeListenerHandler defaultListener = new DataTypeManagerChangeListenerHandler();
    private NameComparator nameComparator = new NameComparator();
    private int creatingDataType = 0;
    protected UniversalID universalID;
    private Map<UniversalID, SourceArchive> sourceArchiveMap;
    private LinkedList<Long> idsToDelete = new LinkedList();
    private List<DataType> favoritesList = new ArrayList<DataType>();
    private IdsToDataTypeMap idsToDataTypeMap = new IdsToDataTypeMap();
    private boolean isBulkRemoving;
    Lock lock;
    protected DataOrganization dataOrganization;

    protected DataTypeManagerDB() {
        this.lock = new Lock("DataTypeManagerDB");
        this.errHandler = new ErrorHandler(){

            public void dbError(IOException e) {
                Msg.showError((Object)this, null, (String)"IO ERROR", (Object)e.getMessage(), (Throwable)e);
            }
        };
        try {
            this.dbHandle = new DBHandle();
            int id = this.startTransaction("");
            try {
                this.init(0, TaskMonitor.DUMMY);
            }
            catch (CancelledException | VersionException e) {
                throw new AssertException(e);
            }
            finally {
                this.endTransaction(id, true);
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
    }

    protected DataTypeManagerDB(ResourceFile packedDBfile, int openMode) throws IOException {
        this.lock = new Lock("DataTypeManagerDB");
        File file = packedDBfile.getFile(false);
        if (file == null && openMode != 2) {
            throw new IOException("Unsupported mode (" + openMode + ") for read-only Datatype Archive: " + packedDBfile.getAbsolutePath());
        }
        this.errHandler = new ErrorHandler(){

            public void dbError(IOException e) {
                Msg.showError((Object)this, null, (String)"IO ERROR", (Object)e.getMessage(), (Throwable)e);
            }
        };
        boolean openSuccess = false;
        PackedDatabase pdb = null;
        try {
            if (openMode == 0) {
                this.dbHandle = new PackedDBHandle("Archive");
            } else {
                pdb = PackedDatabase.getPackedDatabase((ResourceFile)packedDBfile, (boolean)false, (TaskMonitor)TaskMonitor.DUMMY);
                this.dbHandle = openMode == 1 ? pdb.openForUpdate(TaskMonitor.DUMMY) : pdb.open(TaskMonitor.DUMMY);
            }
            openSuccess = true;
        }
        catch (CancelledException e1) {
            throw new AssertException((Throwable)e1);
        }
        finally {
            if (!openSuccess && pdb != null) {
                pdb.dispose();
            }
        }
        boolean initSuccess = false;
        try {
            this.initPackedDatabase(packedDBfile, openMode);
            if (openMode == 0) {
                Long uid = this.universalID != null ? Long.valueOf(this.universalID.getValue()) : null;
                ((PackedDBHandle)this.dbHandle).saveAs("Archive", file.getParentFile(), packedDBfile.getName(), uid, TaskMonitor.DUMMY);
            }
            initSuccess = true;
        }
        catch (CancelledException e) {
            throw new AssertException((Throwable)e);
        }
        finally {
            if (!initSuccess) {
                this.dbHandle.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPackedDatabase(ResourceFile packedDBfile, int openMode) throws CancelledException, IOException {
        block8: {
            int id = this.startTransaction("");
            try {
                this.init(openMode, TaskMonitor.DUMMY);
            }
            catch (VersionException e) {
                if (openMode == 1 && e.isUpgradable()) {
                    try {
                        Msg.info((Object)this, (Object)("Performing datatype archive schema upgrade: " + packedDBfile.getName()));
                        this.init(3, TaskMonitor.DUMMY);
                        break block8;
                    }
                    catch (VersionException ve) {
                        throw new IOException(e);
                    }
                }
                throw new IOException(e);
            }
            finally {
                this.endTransaction(id, true);
            }
        }
    }

    protected DataTypeManagerDB(DBHandle handle, AddressMap addrMap, int openMode, ErrorHandler errHandler, Lock lock, TaskMonitor monitor) throws CancelledException, IOException, VersionException {
        this.dbHandle = handle;
        this.addrMap = addrMap;
        this.errHandler = errHandler;
        this.lock = lock;
        this.init(openMode, monitor);
    }

    private void init(int openMode, TaskMonitor monitor) throws CancelledException, IOException, VersionException {
        this.updateID();
        this.initializeAdapters(openMode, monitor);
        if (this.checkForSourceArchiveUpdatesNeeded(openMode, monitor)) {
            this.doSourceArchiveUpdates(null, TaskMonitor.DUMMY);
        }
        this.dtCache = new DBObjectCache(10);
        this.sourceArchiveDBCache = new DBObjectCache(10);
        this.builtInMap = new HashMap();
        this.builtIn2IdMap = new HashMap();
        this.root = new CategoryDB(this, this.catCache);
        if (this.parentChildAdapter.needsInitializing()) {
            this.initializedParentChildTable();
        }
    }

    private void initializeAdapters(int openMode, TaskMonitor monitor) throws CancelledException, IOException, VersionException {
        VersionException versionExc = null;
        try {
            this.builtinAdapter = BuiltinDBAdapter.getAdapter(this.dbHandle, openMode, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.categoryAdapter = CategoryDBAdapter.getAdapter(this.dbHandle, openMode, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.arrayAdapter = ArrayDBAdapter.getAdapter(this.dbHandle, openMode, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.typedefAdapter = TypedefDBAdapter.getAdapter(this.dbHandle, openMode, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.compositeAdapter = CompositeDBAdapter.getAdapter(this.dbHandle, openMode, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.componentAdapter = ComponentDBAdapter.getAdapter(this.dbHandle, openMode, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.functionDefAdapter = FunctionDefinitionDBAdapter.getAdapter(this.dbHandle, openMode, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.paramAdapter = FunctionParameterAdapter.getAdapter(this.dbHandle, openMode, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.settingsAdapter = SettingsDBAdapter.getAdapter(this.dbHandle, openMode, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        if (this.addrMap != null) {
            try {
                this.instanceSettingsAdapter = InstanceSettingsDBAdapter.getAdapter(this.dbHandle, openMode, this.addrMap, monitor);
            }
            catch (VersionException e) {
                versionExc = e.combine(versionExc);
            }
        }
        try {
            this.pointerAdapter = PointerDBAdapter.getAdapter(this.dbHandle, openMode, monitor, this.addrMap);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.enumAdapter = EnumDBAdapter.getAdapter(this.dbHandle, openMode, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.enumValueAdapter = EnumValueDBAdapter.getAdapter(this.dbHandle, openMode, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.parentChildAdapter = ParentChildAdapter.getAdapter(this.dbHandle, openMode, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.sourceArchiveAdapter = SourceArchiveAdapter.getAdapter(this.dbHandle, openMode, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        if (versionExc != null) {
            throw versionExc;
        }
    }

    private void initializedParentChildTable() {
        this.buildSortedDataTypeList();
        for (DataType dt : this.sortedDataTypes) {
            ParameterDefinition[] vars;
            if (dt instanceof Array) {
                ((Array)dt).getDataType().addParent(dt);
                continue;
            }
            if (dt instanceof Pointer) {
                DataType pdt = ((Pointer)dt).getDataType();
                if (pdt == null) continue;
                pdt.addParent(dt);
                continue;
            }
            if (dt instanceof TypeDef) {
                ((TypeDef)dt).getDataType().addParent(dt);
                continue;
            }
            if (dt instanceof Composite) {
                DataTypeComponent[] comps;
                for (DataTypeComponent comp : comps = ((Composite)dt).getComponents()) {
                    comp.getDataType().addParent(dt);
                }
                continue;
            }
            if (!(dt instanceof FunctionDefinition)) continue;
            FunctionDefinition funDef = (FunctionDefinition)dt;
            DataType retType = funDef.getReturnType();
            if (retType != null) {
                retType.addParent(dt);
            }
            for (ParameterDefinition var : vars = funDef.getArguments()) {
                var.getDataType().addParent(dt);
            }
        }
    }

    protected abstract String getDomainFileID();

    protected abstract String getPath();

    private void buildSortedDataTypeList() {
        if (this.sortedDataTypes != null) {
            return;
        }
        ArrayList<DataType> list = new ArrayList<DataType>();
        this.popuplateDataTypeList(list, this.root);
        Collections.sort(list, this.nameComparator);
        this.sortedDataTypes = list;
    }

    private void buildEnumValueMap() {
        if (this.enumValueMap != null) {
            return;
        }
        HashMap<Long, Set<String>> map = new HashMap<Long, Set<String>>();
        this.populateEnumValueMap(map, this.root);
        this.enumValueMap = map;
    }

    private void removeDataTypeFromSortedList(DataTypePath dataTypePath) {
        if (this.sortedDataTypes == null) {
            return;
        }
        String name = dataTypePath.getDataTypeName();
        TypedefDataType compareDataType = new TypedefDataType(name, DefaultDataType.dataType);
        try {
            compareDataType.setCategoryPath(dataTypePath.getCategoryPath());
        }
        catch (DuplicateNameException duplicateNameException) {
            // empty catch block
        }
        int index = Collections.binarySearch(this.sortedDataTypes, compareDataType, this.nameComparator);
        if (index >= 0) {
            this.sortedDataTypes.remove(index);
        }
    }

    private void insertDataTypeIntoSortedList(DataType dataType) {
        if (this.sortedDataTypes == null) {
            return;
        }
        int index = Collections.binarySearch(this.sortedDataTypes, dataType, this.nameComparator);
        if (index < 0) {
            index = -index - 1;
            this.sortedDataTypes.add(index, dataType);
        } else {
            this.sortedDataTypes.set(index, dataType);
        }
    }

    private void popuplateDataTypeList(List<DataType> list, Category category) {
        for (Category childCategory : category.getCategories()) {
            this.popuplateDataTypeList(list, childCategory);
        }
        list.addAll(Arrays.asList(category.getDataTypes()));
    }

    private void populateEnumValueMap(Map<Long, Set<String>> map, Category category) {
        DataType[] dataTypeCollection;
        for (Category childCategory : category.getCategories()) {
            this.populateEnumValueMap(map, childCategory);
        }
        for (DataType type : dataTypeCollection = category.getDataTypes()) {
            long[] values;
            if (!(type instanceof Enum)) continue;
            Enum enumDt = (Enum)type;
            for (long value : values = enumDt.getValues()) {
                Set<String> namesForValue = map.get(value);
                if (namesForValue == null) {
                    namesForValue = new HashSet<String>();
                    map.put(value, namesForValue);
                }
                namesForValue.add(enumDt.getName(value));
            }
        }
    }

    @Override
    public UniversalID getUniversalID() {
        return this.universalID;
    }

    public void updateID() {
        long databaseID = this.dbHandle.getDatabaseId();
        this.universalID = databaseID == 0L ? null : new UniversalID(databaseID);
        this.invalidateSourceArchiveCache();
    }

    @Override
    public List<DataType> getFavorites() {
        this.lock.acquire();
        try {
            ArrayList<DataType> arrayList = new ArrayList<DataType>(this.favoritesList);
            return arrayList;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isFavorite(DataType dataType) {
        this.lock.acquire();
        try {
            boolean bl = this.favoritesList.contains(dataType);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFavorite(DataType dataType, boolean isFavorite) {
        if (dataType.getDataTypeManager() != this) {
            throw new IllegalArgumentException("Datatype does not belong to this datatype manager.");
        }
        this.lock.acquire();
        try {
            boolean isInFavorites = this.favoritesList.contains(dataType);
            if (isInFavorites == isFavorite) {
                return;
            }
            if (isFavorite) {
                this.favoritesList.add(dataType);
            } else {
                this.favoritesList.remove(dataType);
            }
            this.favoritesChanged(dataType, isFavorite);
        }
        finally {
            this.lock.release();
        }
    }

    DataTypeConflictHandler.ConflictResult resolveConflict(DataTypeConflictHandler handler, DataType addedDataType, DataType existingDataType) {
        return handler.resolveConflict(addedDataType, existingDataType);
    }

    boolean shouldUpdate(DataTypeConflictHandler handler, DataType addedDataType, DataType existingDataType) {
        return handler.shouldUpdate(addedDataType, existingDataType);
    }

    @Override
    public String getUniqueName(CategoryPath path, String baseName) {
        int pos = baseName.lastIndexOf(95);
        int oneUpNumber = 0;
        Object name = baseName;
        if (pos > 0) {
            String numString = baseName.substring(pos + 1);
            try {
                oneUpNumber = Integer.parseInt(numString);
                name = baseName;
                baseName = baseName.substring(0, pos);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        while (this.getDataType(path, (String)name) != null) {
            name = baseName + "_" + ++oneUpNumber;
        }
        return name;
    }

    public String getUniqueName(CategoryPath path1, CategoryPath path2, String baseName) {
        int pos = baseName.lastIndexOf(95);
        int oneUpNumber = 0;
        Object name = baseName;
        if (pos > 0) {
            String numString = baseName.substring(pos + 1);
            try {
                oneUpNumber = Integer.parseInt(numString);
                name = baseName;
                baseName = baseName.substring(0, pos);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        while (this.getDataType(path1, (String)name) != null || this.getDataType(path2, (String)name) != null) {
            name = baseName + "_" + ++oneUpNumber;
        }
        return name;
    }

    @Override
    public Category getCategory(CategoryPath path) {
        if (path.equals(CategoryPath.ROOT)) {
            return this.root;
        }
        Category parent = this.getCategory(path.getParent());
        if (parent == null) {
            return null;
        }
        return parent.getCategory(path.getName());
    }

    CategoryDB getCategoryDB(long id) throws IOException {
        Record rec;
        if (id == ROOT_CATEGORY_ID) {
            return this.root;
        }
        CategoryDB cat = this.catCache.get(id);
        if (cat == null && (rec = this.categoryAdapter.getRecord(id)) != null) {
            long parentID = rec.getLongValue(1);
            CategoryDB parent = this.getCategoryDB(parentID);
            String name = rec.getString(0);
            cat = new CategoryDB(this, this.catCache, id, parent, name);
        }
        return cat;
    }

    CategoryDB createCategoryDB(CategoryDB parent, String categoryName) throws IOException {
        CategoryDB c = parent.getCategory(categoryName);
        if (c != null) {
            return c;
        }
        Record rec = this.categoryAdapter.createCategory(categoryName, parent.getKey());
        String name = rec.getString(0);
        CategoryDB cat = new CategoryDB(this, this.catCache, rec.getKey(), parent, name);
        parent.categoryAdded(cat);
        this.categoryCreated(cat);
        return cat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Category getCategory(long id) {
        this.lock.acquire();
        try {
            CategoryDB categoryDB = this.getCategoryDB(id);
            return categoryDB;
        }
        catch (IOException e) {
            this.dbError(e);
            Category category = null;
            return category;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataType resolve(DataType dataType, DataTypeConflictHandler handler) {
        if (dataType == DataType.DEFAULT) {
            return dataType;
        }
        this.lock.acquire();
        DataTypeConflictHandler originalHandler = null;
        try {
            originalHandler = this.currentHandler;
            this.currentHandler = handler != null ? handler : (this.currentHandler == null ? DataTypeConflictHandler.DEFAULT_HANDLER : this.currentHandler.getSubsequentHandler());
            if (this.contains(dataType)) {
                DataType dataType2 = dataType;
                return dataType2;
            }
            SourceArchive sourceArchive = dataType.getSourceArchive();
            if (sourceArchive != null && sourceArchive.getArchiveType() == ArchiveType.BUILT_IN) {
                DataType dataType3 = this.resolveBuiltIn(dataType);
                return dataType3;
            }
            if (sourceArchive == null || dataType.getUniversalID() == null) {
                DataType dataType4 = this.resolveNoSourceDataType(dataType, this.currentHandler);
                return dataType4;
            }
            if (!sourceArchive.getSourceArchiveID().equals((Object)this.getUniversalID()) && sourceArchive.getArchiveType() == ArchiveType.PROGRAM) {
                DataType dataType5 = this.resolveNoSourceDataType(dataType.copy(this), this.currentHandler);
                return dataType5;
            }
            DataType dataType6 = this.resolveDataTypeWithSource(dataType, sourceArchive, this.currentHandler);
            return dataType6;
        }
        finally {
            this.currentHandler = originalHandler;
            this.lock.release();
        }
    }

    private DataType resolveBuiltIn(DataType dataType) {
        DataType existingDataType = this.getDataType(dataType.getCategoryPath(), dataType.getName());
        if (existingDataType != null) {
            if (dataType.isEquivalent(existingDataType)) {
                return existingDataType;
            }
            this.renameToUnusedConflictName(existingDataType);
        }
        return this.createDataType(dataType, BuiltInSourceArchive.INSTANCE);
    }

    private DataType resolveNoSourceDataType(DataType dataType, DataTypeConflictHandler handler) {
        DataType existingDataType = this.findEquivalentDataTypeSameLocation(dataType, null);
        if (existingDataType != null) {
            return existingDataType;
        }
        existingDataType = this.getDataType(dataType.getCategoryPath(), dataType.getName());
        if (existingDataType == null) {
            return this.createDataType(dataType, null, handler);
        }
        DataTypeConflictHandler.ConflictResult result = this.resolveConflict(handler, dataType, existingDataType);
        switch (result) {
            case RENAME_AND_ADD: {
                DataType copyDataType = dataType.copy(this);
                this.renameToUnusedConflictName(copyDataType);
                copyDataType = this.createDataType(copyDataType, null, handler);
                existingDataType = this.findEquivalentDataTypeSameLocation(dataType, copyDataType.getName());
                if (existingDataType != null) {
                    this.removeInternal(copyDataType, TaskMonitor.DUMMY);
                    return existingDataType;
                }
                return copyDataType;
            }
            case REPLACE_EXISTING: {
                this.renameToUnusedConflictName(existingDataType);
                DataType newDataType = this.createDataType(dataType, null, handler);
                try {
                    this.replace(existingDataType, newDataType);
                }
                catch (DataTypeDependencyException e) {
                    throw new AssertException((Throwable)e);
                }
                return newDataType;
            }
            case USE_EXISTING: {
                return existingDataType;
            }
        }
        return null;
    }

    private void renameToUnusedConflictName(DataType dataType) {
        String dtName = dataType.getName();
        String name = this.getUnusedConflictName(dataType.getCategoryPath(), dtName);
        try {
            dataType.setName(name);
        }
        catch (InvalidNameException e) {
            throw new AssertException("This should not occur here, all we did is tack more on the end", (Throwable)e);
        }
        catch (DuplicateNameException e) {
            throw new AssertException("This should not occur here, we already looked to see if it existed", (Throwable)e);
        }
    }

    public String getUnusedConflictName(CategoryPath path, String name) {
        String baseName;
        int index = name.indexOf(".conflict");
        if (index > 0) {
            name = name.substring(0, index);
        }
        String testName = baseName = name + ".conflict";
        int count = 0;
        while (this.getDataType(path, testName) != null) {
            testName = baseName + ++count;
        }
        return testName;
    }

    private DataType findEquivalentDataTypeSameLocation(DataType dataType, String excludedName) {
        DataType[] dataTypes;
        String dtName = dataType.getName();
        DataType existingDataType = null;
        if (!dtName.equals(excludedName) && (existingDataType = this.getDataType(dataType.getCategoryPath(), dtName)) != null && existingDataType.isEquivalent(dataType)) {
            return existingDataType;
        }
        Category category = this.getCategory(dataType.getCategoryPath());
        if (category == null) {
            return null;
        }
        String namePrefix = dtName + ".conflict";
        for (DataType candidate : dataTypes = category.getDataTypes()) {
            String candidateName = candidate.getName();
            if (!candidateName.startsWith(namePrefix) || candidateName.equals(excludedName) || !candidate.isEquivalent(dataType)) continue;
            return candidate;
        }
        return null;
    }

    private DataType resolveDataTypeWithSource(DataType dataType, SourceArchive sourceArchive, DataTypeConflictHandler handler) {
        DataType existingDataType = this.getDataType(sourceArchive, dataType.getUniversalID());
        if (existingDataType != null) {
            if (!existingDataType.isEquivalent(dataType) && this.shouldUpdate(handler, dataType, existingDataType)) {
                existingDataType.replaceWith(dataType);
                existingDataType.setLastChangeTime(dataType.getLastChangeTime());
            }
            return existingDataType;
        }
        existingDataType = this.getDataType(dataType.getCategoryPath(), dataType.getName());
        if (existingDataType == null) {
            return this.createDataType(dataType, sourceArchive, handler);
        }
        if (this.isLocalSource(existingDataType) && existingDataType.isEquivalent(dataType)) {
            return this.replaceEquivalentLocalWithSourceDataType(dataType, sourceArchive, existingDataType);
        }
        DataType copyDataType = dataType.clone(this);
        this.renameToUnusedConflictName(copyDataType);
        return this.createDataType(copyDataType, sourceArchive, handler);
    }

    private DataType replaceEquivalentLocalWithSourceDataType(DataType dataType, SourceArchive sourceArchive, DataType existingDataType) {
        existingDataType.setSourceArchive(sourceArchive);
        ((DataTypeDB)existingDataType).setUniversalID(dataType.getUniversalID());
        existingDataType.replaceWith(dataType);
        long lastChangeTime = dataType.getLastChangeTime();
        existingDataType.setLastChangeTime(lastChangeTime);
        existingDataType.setLastChangeTimeInSourceArchive(lastChangeTime);
        this.dataTypeChanged(existingDataType);
        return existingDataType;
    }

    private boolean isLocalSource(DataType dataType) {
        SourceArchive sourceArchive = dataType.getSourceArchive();
        return sourceArchive.equals(this.getLocalSourceArchive());
    }

    @Override
    public DataType addDataType(DataType originalDataType, DataTypeConflictHandler handler) {
        return this.resolve(originalDataType, handler);
    }

    @Override
    public SourceArchive resolveSourceArchive(SourceArchive sourceArchive) {
        if (sourceArchive == null) {
            return null;
        }
        if (this.getSourceArchive(sourceArchive.getSourceArchiveID()) != null) {
            return this.getSourceArchive(sourceArchive.getSourceArchiveID());
        }
        try {
            Record record = this.sourceArchiveAdapter.createRecord(sourceArchive);
            SourceArchiveDB newSourceArchive = this.getSourceArchiveDB(record);
            this.invalidateSourceArchiveCache();
            this.sourceArchiveAdded(newSourceArchive.getSourceArchiveID());
            return newSourceArchive;
        }
        catch (IOException e) {
            this.dbError(e);
            return null;
        }
    }

    @Override
    public void removeSourceArchive(SourceArchive sourceArchive) {
        UniversalID sourceArchiveID = sourceArchive.getSourceArchiveID();
        if (sourceArchiveID.equals((Object)this.universalID) || sourceArchiveID.equals((Object)LOCAL_ARCHIVE_UNIVERSAL_ID)) {
            throw new IllegalArgumentException("Attempted to delete the local archive!");
        }
        this.disassociateAllDataTypes(sourceArchiveID);
        try {
            this.sourceArchiveAdapter.deleteRecord(sourceArchiveID);
        }
        catch (IOException e) {
            this.dbError(e);
        }
        this.sourceArchiveChanged(sourceArchiveID);
        this.invalidateSourceArchiveCache();
    }

    private void disassociateAllDataTypes(UniversalID sourceArchiveID) {
        ArrayList<DataType> dataTypes = new ArrayList<DataType>();
        this.getAllDataTypes(dataTypes);
        for (DataType dataType : dataTypes) {
            SourceArchive sourceArchive = dataType.getSourceArchive();
            if (sourceArchive == null || !sourceArchive.getSourceArchiveID().equals((Object)sourceArchiveID)) continue;
            this.disassociate(dataType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataType replaceDataType(DataType existingDt, DataType replacementDt, boolean updateCategoryPath) throws DataTypeDependencyException {
        this.lock.acquire();
        try {
            if (this.getID(existingDt) < 0L) {
                throw new IllegalArgumentException("datatype to replace is not contained in this datatype manager.");
            }
            boolean fixupName = false;
            if (!this.contains(replacementDt)) {
                replacementDt = replacementDt.clone(this);
                try {
                    replacementDt.setCategoryPath(existingDt.getCategoryPath());
                }
                catch (DuplicateNameException e) {
                    throw new AssertException();
                }
                if (replacementDt.getName().equals(existingDt.getName())) {
                    fixupName = true;
                }
                replacementDt = this.resolve(replacementDt, null);
            }
            this.replace(existingDt, replacementDt);
            if (fixupName) {
                try {
                    long lastChangeTime = replacementDt.getLastChangeTime();
                    replacementDt.setName(existingDt.getName());
                    replacementDt.setLastChangeTime(lastChangeTime);
                }
                catch (Exception lastChangeTime) {
                    // empty catch block
                }
            }
            CategoryPath path = existingDt.getCategoryPath();
            if (updateCategoryPath && !replacementDt.getCategoryPath().equals(path)) {
                try {
                    replacementDt.setCategoryPath(path);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            DataType dataType = replacementDt;
            return dataType;
        }
        finally {
            this.lock.release();
        }
    }

    private void replace(DataType existingDt, DataType replacementDt) throws DataTypeDependencyException {
        if (existingDt == replacementDt) {
            return;
        }
        DataTypePath replacedDtPath = existingDt.getDataTypePath();
        long replacedId = this.getID(existingDt);
        UniversalID id = existingDt.getUniversalID();
        this.idsToDataTypeMap.removeDataType(existingDt.getSourceArchive(), id);
        if (replacementDt.dependsOn(existingDt)) {
            throw new DataTypeDependencyException("Replace failed: " + replacementDt.getDisplayName() + " depends on " + existingDt.getDisplayName());
        }
        this.replaceUsesInOtherDataTypes(existingDt, replacementDt);
        try {
            this.replaceDataTypeIDs(replacedId, this.getID(replacementDt));
            this.parentChildAdapter.removeAllRecordsForParent(replacedId);
        }
        catch (IOException e) {
            this.dbError(e);
        }
        this.deleteDataTypeRecord(replacedId);
        this.dtCache.delete(replacedId);
        this.dataTypeReplaced(replacedId, replacedDtPath, replacementDt);
    }

    private void replaceUsesInOtherDataTypes(DataType existingDt, DataType newDt) {
        if (existingDt instanceof DataTypeDB) {
            DataType[] dts;
            for (DataType dt : dts = existingDt.getParents()) {
                dt.dataTypeReplaced(existingDt, newDt);
            }
        } else {
            this.buildSortedDataTypeList();
            for (DataType dt : new ArrayList<DataType>(this.sortedDataTypes)) {
                dt.dataTypeReplaced(existingDt, newDt);
            }
        }
    }

    protected abstract void replaceDataTypeIDs(long var1, long var3);

    public void replaceSourceArchive(SourceArchive oldSourceArchive, SourceArchive newSourceArchive) {
        UniversalID newSourceArchiveID;
        UniversalID oldSourceArchiveID = oldSourceArchive.getSourceArchiveID();
        if (oldSourceArchiveID.equals((Object)(newSourceArchiveID = newSourceArchive.getSourceArchiveID()))) {
            throw new IllegalArgumentException("Cannot replace source archive \"" + oldSourceArchive.getName() + "\" with \"" + newSourceArchive.getName() + "\" in data type archive \"" + this.getName() + "\" since they have the same ID (" + oldSourceArchiveID.getValue() + ").");
        }
        if (this.getSourceArchive(oldSourceArchiveID) == null) {
            throw new IllegalArgumentException("The source archive \"" + oldSourceArchive.getName() + "\" with ID (" + oldSourceArchiveID.getValue() + ") isn't used in data type archive \"" + this.getName() + "\".");
        }
        this.resolveSourceArchive(newSourceArchive);
        Iterator<DataType> allDataTypes = this.getAllDataTypes();
        while (allDataTypes.hasNext()) {
            DataType dt = allDataTypes.next();
            SourceArchive sourceArchive = dt.getSourceArchive();
            if (sourceArchive == null || !oldSourceArchiveID.equals((Object)sourceArchive.getSourceArchiveID())) continue;
            dt.setSourceArchive(newSourceArchive);
        }
        this.removeSourceArchive(oldSourceArchive);
        SourceArchive sourceArchive = this.getSourceArchive(newSourceArchiveID);
        sourceArchive.setLastSyncTime(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findDataTypes(String name, List<DataType> list) {
        if (name == null || name.length() == 0) {
            return;
        }
        if (name.equals(DefaultDataType.dataType.getName())) {
            list.add(DefaultDataType.dataType);
            return;
        }
        this.lock.acquire();
        try {
            this.buildSortedDataTypeList();
            TypedefDataType compareDataType = new TypedefDataType(name, DefaultDataType.dataType);
            int index = Collections.binarySearch(this.sortedDataTypes, compareDataType, this.nameComparator);
            if (index < 0) {
                index = -index - 1;
            }
            while (index < this.sortedDataTypes.size()) {
                DataType dt = this.sortedDataTypes.get(index);
                if (!name.equals(dt.getName())) {
                    break;
                }
                list.add(dt);
                ++index;
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findDataTypes(String name, List<DataType> list, boolean caseSensitive, TaskMonitor monitor) {
        if (name == null || name.length() == 0) {
            return;
        }
        if (name.equals(DefaultDataType.dataType.getName())) {
            list.add(DefaultDataType.dataType);
            return;
        }
        if (monitor == null) {
            monitor = TaskMonitor.DUMMY;
        }
        Pattern regexp = UserSearchUtils.createSearchPattern((String)name, (boolean)caseSensitive);
        this.lock.acquire();
        try {
            this.buildSortedDataTypeList();
            for (DataType dt : this.sortedDataTypes) {
                if (monitor.isCancelled()) {
                    return;
                }
                Matcher matcher = regexp.matcher(dt.getName());
                if (!matcher.matches()) continue;
                list.add(dt);
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataType getDataType(DataTypePath dataTypePath) {
        Category cat = this.getCategory(dataTypePath.getCategoryPath());
        if (cat != null) {
            return cat.getDataType(dataTypePath.getDataTypeName());
        }
        return null;
    }

    @Override
    public DataType getDataType(String dataTypePath) {
        String name = this.getName();
        if (dataTypePath.startsWith(name)) {
            dataTypePath = dataTypePath.substring(name.length());
        }
        if (!dataTypePath.startsWith("/")) {
            return null;
        }
        Category category = this.getLowestLevelCategory(dataTypePath);
        if (category != null) {
            CategoryPath categoryPath = category.getCategoryPath();
            String path = categoryPath.getPath();
            int dataTypeNameStartIndex = path.endsWith("/") ? path.length() : path.length() + 1;
            String dataTypeName = dataTypePath.substring(dataTypeNameStartIndex);
            return category.getDataType(dataTypeName);
        }
        return null;
    }

    @Override
    public DataType findDataType(String dataTypePath) {
        return this.getDataType(dataTypePath);
    }

    private Category getLowestLevelCategory(String dataTypePath) {
        CategoryPath pathParser = new CategoryPath(dataTypePath);
        while (pathParser != null) {
            CategoryPath path = pathParser.getParent();
            Category category = this.getCategory(path);
            if (category != null) {
                return category;
            }
            pathParser = path;
        }
        return null;
    }

    @Override
    public void findEnumValueNames(long value, Set<String> enumValueNames) {
        this.buildEnumValueMap();
        Set<String> names = this.enumValueMap.get(value);
        if (names != null) {
            enumValueNames.addAll(names);
        }
    }

    @Override
    public long getResolvedID(DataType dt) {
        if (dt == null) {
            return -1L;
        }
        if (dt == DataType.DEFAULT) {
            return 0L;
        }
        if (dt instanceof BadDataType) {
            return -2L;
        }
        dt = this.resolve(dt, this.currentHandler);
        return this.getID(dt);
    }

    @Override
    public long getID(DataType dt) {
        if (dt == null) {
            return -1L;
        }
        if (dt == DataType.DEFAULT) {
            return 0L;
        }
        if (dt instanceof BadDataType) {
            return -2L;
        }
        if (dt instanceof DatabaseObject) {
            return ((DatabaseObject)((Object)dt)).getKey();
        }
        Long l = this.builtIn2IdMap.get(dt);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    @Override
    public DataType getDataType(long dataTypeID) {
        if (dataTypeID == -1L) {
            return null;
        }
        if (dataTypeID == 0L) {
            return DataType.DEFAULT;
        }
        if (dataTypeID == -2L) {
            return BadDataType.dataType;
        }
        return this.getDataType(dataTypeID, null);
    }

    @Override
    public void addInvalidatedListener(InvalidatedListener listener) {
        this.invalidatedListeners.add(listener);
    }

    @Override
    public void removeInvalidatedListener(InvalidatedListener listener) {
        this.invalidatedListeners.remove(listener);
    }

    private void fireInvalidated() {
        for (InvalidatedListener listener : this.invalidatedListeners) {
            listener.dataTypeManagerInvalidated(this);
        }
    }

    private boolean removeInternal(DataType dataType, TaskMonitor monitor) {
        if (!this.contains(dataType)) {
            return false;
        }
        LinkedList<Long> deletedIds = new LinkedList<Long>();
        long id = this.getID(dataType);
        if (id < 0L) {
            return false;
        }
        this.idsToDelete.add(new Long(id));
        while (!this.idsToDelete.isEmpty()) {
            Long l = this.idsToDelete.removeFirst();
            id = l;
            this.removeUseOfDataType(id);
            deletedIds.addFirst(l);
        }
        for (Long l : deletedIds) {
            this.deleteDataType(l);
        }
        try {
            this.deleteDataTypeIDs(deletedIds, monitor);
        }
        catch (CancelledException e) {
            return false;
        }
        return true;
    }

    private void removeUseOfDataType(long id) {
        if (this.isBulkRemoving) {
            throw new IllegalStateException("Cannot remove data types with a bulk remove operation in place");
        }
        this.isBulkRemoving = true;
        try {
            this.notifyDeleted(id);
        }
        finally {
            this.isBulkRemoving = false;
        }
        this.removeAllParentChildRecordsForChild(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(DataType dataType, TaskMonitor monitor) {
        this.lock.acquire();
        try {
            boolean bl = this.removeInternal(dataType, monitor);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void associateDataTypeWithArchive(DataType datatype, SourceArchive archive) {
        if (!this.contains(datatype)) {
            throw new IllegalArgumentException("The given datatype must exist in this DataTypeManager");
        }
        if (!datatype.getSourceArchive().equals(this.getLocalSourceArchive())) {
            return;
        }
        if (datatype.getSourceArchive().equals(archive)) {
            return;
        }
        this.resolveSourceArchive(archive);
        Collection<DataType> datatypes = DataTypeUtilities.getContainedDataTypes(datatype);
        datatypes = this.filterOutNonSourceSettableDataTypes(datatypes);
        for (DataType dt : datatypes) {
            dt.setSourceArchive(archive);
            long timeNow = System.currentTimeMillis();
            dt.setLastChangeTime(timeNow);
            dt.setLastChangeTimeInSourceArchive(timeNow);
        }
    }

    @Override
    public void disassociate(DataType dataType) {
        UniversalID id;
        UniversalID oldDtID = dataType.getUniversalID();
        SourceArchive sourceArchive = dataType.getSourceArchive();
        UniversalID universalID = id = (sourceArchive = this.resolveSourceArchive(sourceArchive)) == null ? DataTypeManager.LOCAL_ARCHIVE_UNIVERSAL_ID : sourceArchive.getSourceArchiveID();
        if (id.equals((Object)this.getUniversalID())) {
            id = DataTypeManager.LOCAL_ARCHIVE_UNIVERSAL_ID;
        }
        if (id == DataTypeManager.LOCAL_ARCHIVE_UNIVERSAL_ID) {
            return;
        }
        dataType.setSourceArchive(null);
        if (dataType instanceof DataTypeDB) {
            DataTypeDB dt = (DataTypeDB)dataType;
            dt.setUniversalID(UniversalIdGenerator.nextID());
        }
        if (oldDtID != null) {
            this.idsToDataTypeMap.removeDataType(sourceArchive, oldDtID);
        }
        this.dataTypeChanged(dataType);
    }

    private Collection<DataType> filterOutNonSourceSettableDataTypes(Collection<DataType> datatypes) {
        ArrayList<DataType> filteredList = new ArrayList<DataType>();
        for (DataType dataType : datatypes) {
            if (!this.isSourceSettable(dataType)) continue;
            filteredList.add(dataType);
        }
        return filteredList;
    }

    private boolean isSourceSettable(DataType dataType) {
        if (!(dataType instanceof DataTypeDB)) {
            return false;
        }
        SourceArchive sourceArchive = dataType.getSourceArchive();
        DataTypeManager dtm = dataType.getDataTypeManager();
        if (sourceArchive == null || dtm == null) {
            return false;
        }
        return sourceArchive.equals(dtm.getLocalSourceArchive());
    }

    protected void addDataTypeToDelete(long id) {
        this.idsToDelete.add(new Long(id));
    }

    protected abstract void deleteDataTypeIDs(LinkedList<Long> var1, TaskMonitor var2) throws CancelledException;

    private void notifyDeleted(long dataTypeID) {
        DataType dataType = this.getDataType(dataTypeID);
        if (dataType == null) {
            return;
        }
        if (dataType instanceof DataTypeDB) {
            ((DataTypeDB)dataType).notifyDeleted();
        } else {
            this.buildSortedDataTypeList();
            ArrayList<DataType> sortedDataTypesCopy = new ArrayList<DataType>(this.sortedDataTypes);
            for (DataType dt : sortedDataTypesCopy) {
                dt.dataTypeDeleted(dataType);
            }
        }
    }

    private void deleteDataType(long dataTypeID) {
        DataType dataType = this.getDataType(dataTypeID);
        if (dataType == null) {
            return;
        }
        UniversalID id = dataType.getUniversalID();
        if (id != null) {
            this.idsToDataTypeMap.removeDataType(dataType.getSourceArchive(), id);
        }
        this.deleteDataTypeRecord(dataTypeID);
        try {
            this.parentChildAdapter.removeAllRecordsForParent(dataTypeID);
        }
        catch (IOException e) {
            this.dbError(e);
        }
        this.dtCache.delete(dataTypeID);
        this.favoritesList.remove(dataType);
        DataTypePath deletedDtPath = dataType.getDataTypePath();
        this.dataTypeDeleted(dataTypeID, deletedDtPath);
    }

    private void deleteDataTypeRecord(long dataID) {
        int tableID = this.getTableID(dataID);
        try {
            DataType dt = null;
            switch (tableID) {
                case 0: {
                    boolean status = this.builtinAdapter.removeRecord(dataID);
                    if (!status) break;
                    dt = this.builtInMap.remove(new Long(dataID));
                    this.builtIn2IdMap.remove(dt);
                    break;
                }
                case 1: {
                    this.removeComponents(dataID);
                    boolean status = this.compositeAdapter.removeRecord(dataID);
                    break;
                }
                case 2: {
                    boolean status = this.componentAdapter.removeRecord(dataID);
                    break;
                }
                case 5: {
                    boolean status = this.typedefAdapter.removeRecord(dataID);
                    break;
                }
                case 3: {
                    boolean status = this.arrayAdapter.removeRecord(dataID);
                    break;
                }
                case 4: {
                    boolean status = this.pointerAdapter.removeRecord(dataID);
                    break;
                }
                case 6: {
                    this.removeParameters(dataID);
                    boolean status = this.functionDefAdapter.removeRecord(dataID);
                    break;
                }
                case 7: {
                    boolean status = this.paramAdapter.removeRecord(dataID);
                    break;
                }
                case 8: {
                    boolean bl = this.enumAdapter.removeRecord(dataID);
                }
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
    }

    private void removeParameters(long parentID) throws IOException {
        long[] paramIDs;
        for (long paramID : paramIDs = this.paramAdapter.getParameterIdsInFunctionDef(parentID)) {
            this.deleteDataTypeRecord(paramID);
        }
    }

    private void removeComponents(long parentID) throws IOException {
        long[] componentIDs;
        for (long componentID : componentIDs = this.componentAdapter.getComponentIdsInComposite(parentID)) {
            this.deleteDataTypeRecord(componentID);
        }
    }

    @Override
    public boolean contains(DataType dataType) {
        if (dataType == null) {
            return false;
        }
        if (dataType.getDataTypeManager() != this) {
            return false;
        }
        if (dataType instanceof DataTypeDB) {
            long id = ((DataTypeDB)dataType).getKey();
            return this.dtCache.get(id) != null;
        }
        return this.builtIn2IdMap.containsKey(dataType);
    }

    @Override
    public boolean containsCategory(CategoryPath path) {
        return this.getCategory(path) != null;
    }

    @Override
    public Category createCategory(CategoryPath path) {
        this.lock.acquire();
        try {
            Category cat = this.getCategory(path);
            if (cat != null) {
                Category category = cat;
                return category;
            }
            CategoryPath parentPath = path.getParent();
            Category parentCat = this.getCategory(parentPath);
            if (parentCat == null) {
                parentCat = this.createCategory(parentPath);
            }
            Category category = parentCat.createCategory(path.getName());
            return category;
        }
        catch (InvalidNameException e) {
            throw new AssertException("Got invalid name exception here, but should be impossible.");
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Category getRootCategory() {
        return this.root;
    }

    public DataType[] getDataTypes(CategoryPath path) {
        Category cat = this.getCategory(path);
        if (cat != null) {
            return cat.getDataTypes();
        }
        return new DataType[0];
    }

    @Override
    public DataType getDataType(CategoryPath path, String name) {
        if (path.equals(DataType.DEFAULT.getCategoryPath()) && name.equals(DataType.DEFAULT.getName())) {
            return DataType.DEFAULT;
        }
        Category category = this.getCategory(path);
        if (category != null) {
            return category.getDataType(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DataType> getDataTypesInCategory(long categoryID) {
        this.lock.acquire();
        ArrayList<DataType> list = new ArrayList<DataType>();
        try {
            long[] ids = this.builtinAdapter.getRecordIdsInCategory(categoryID);
            this.getDataTypes(ids, list);
            ids = this.typedefAdapter.getRecordIdsInCategory(categoryID);
            this.getDataTypes(ids, list);
            ids = this.compositeAdapter.getRecordIdsInCategory(categoryID);
            this.getDataTypes(ids, list);
            ids = this.functionDefAdapter.getRecordIdsInCategory(categoryID);
            this.getDataTypes(ids, list);
            ids = this.enumAdapter.getRecordIdsInCategory(categoryID);
            this.getDataTypes(ids, list);
            ids = this.pointerAdapter.getRecordIdsInCategory(categoryID);
            this.getDataTypes(ids, list);
            ids = this.arrayAdapter.getRecordIdsInCategory(categoryID);
            this.getDataTypes(ids, list);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return list;
    }

    @Override
    public int getCategoryCount() {
        return this.categoryAdapter.getRecordCount() + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDataTypeCount(boolean includePointersAndArrays) {
        this.lock.acquire();
        try {
            this.buildSortedDataTypeList();
            int count = this.sortedDataTypes.size();
            if (includePointersAndArrays) {
                int n = count;
                return n;
            }
            for (DataType dt : this.sortedDataTypes) {
                if (!(dt instanceof Pointer) && !(dt instanceof Array)) continue;
                --count;
            }
            int n = count;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    private void getDataTypes(long[] ids, ArrayList<DataType> list) {
        for (long id : ids) {
            DataType dt = this.getDataType(id);
            if (dt == null) {
                throw new AssertException("Could not find data type id: " + id);
            }
            list.add(dt);
        }
    }

    private int getTableID(long dataID) {
        return (int)(dataID >> 56);
    }

    private DataType getDataType(long dataTypeID, Record record) {
        int tableId = this.getTableID(dataTypeID);
        switch (tableId) {
            case 0: {
                return this.getBuiltInDataType(dataTypeID, record);
            }
            case 1: {
                return this.getCompositeDataType(dataTypeID, record);
            }
            case 3: {
                return this.getArrayDataType(dataTypeID, record);
            }
            case 4: {
                return this.getPointerDataType(dataTypeID, record);
            }
            case 5: {
                return this.getTypedefDataType(dataTypeID, record);
            }
            case 6: {
                return this.getFunctionDefDataType(dataTypeID, record);
            }
            case 8: {
                return this.getEnumDataType(dataTypeID, record);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataType getBuiltInDataType(long dataTypeID, Record record) {
        this.lock.acquire();
        try {
            Long key = new Long(dataTypeID);
            DataType dt = this.builtInMap.get(key);
            if (dt == null) {
                if (record == null) {
                    record = this.builtinAdapter.getRecord(dataTypeID);
                }
                if (record != null) {
                    long catID = record.getLongValue(2);
                    CategoryDB catDB = this.getCategoryDB(catID);
                    CategoryPath catPath = catDB.getCategoryPath();
                    String classPath = record.getString(1);
                    String name = record.getString(0);
                    try {
                        Class<?> c;
                        try {
                            c = Class.forName(classPath);
                        }
                        catch (ClassNotFoundException | NoClassDefFoundError e) {
                            String newClassPath = ClassTranslator.get((String)classPath);
                            if (newClassPath == null) {
                                throw e;
                            }
                            c = Class.forName(newClassPath);
                        }
                        dt = (BuiltInDataType)c.newInstance();
                        dt.setName(name);
                        dt.setCategoryPath(catPath);
                        dt = dt.clone(this);
                        dt.setDefaultSettings(new SettingsDBManager(this, dt, dataTypeID));
                    }
                    catch (Exception e) {
                        dt = new MissingBuiltInDataType(catPath, name, classPath, this);
                    }
                    this.builtInMap.put(key, dt);
                    this.builtIn2IdMap.put(dt, key);
                }
            }
            DataType dataType = dt;
            return dataType;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Enum getEnumDataType(long dataTypeID, Record record) {
        this.lock.acquire();
        try {
            EnumDB enu = (EnumDB)this.dtCache.get(dataTypeID);
            if (enu == null) {
                if (record == null) {
                    record = this.enumAdapter.getRecord(dataTypeID);
                }
                if (record != null) {
                    enu = new EnumDB(this, this.dtCache, this.enumAdapter, this.enumValueAdapter, record);
                }
            }
            EnumDB enumDB = enu;
            return enumDB;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Composite getCompositeDataType(long dataTypeID, Record record) {
        this.lock.acquire();
        try {
            CompositeDB comp = (CompositeDB)this.dtCache.get(dataTypeID);
            if (comp == null) {
                if (record == null) {
                    record = this.compositeAdapter.getRecord(dataTypeID);
                }
                if (record != null) {
                    comp = record.getBooleanValue(2) ? new UnionDB(this, this.dtCache, this.compositeAdapter, this.componentAdapter, record) : new StructureDB(this, this.dtCache, this.compositeAdapter, this.componentAdapter, record);
                }
            }
            CompositeDB compositeDB = comp;
            return compositeDB;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeDef getTypedefDataType(long dataTypeID, Record record) {
        this.lock.acquire();
        try {
            TypedefDB typeDB = (TypedefDB)this.dtCache.get(dataTypeID);
            if (typeDB == null) {
                if (record == null) {
                    record = this.typedefAdapter.getRecord(dataTypeID);
                }
                if (record != null) {
                    typeDB = new TypedefDB(this, this.dtCache, this.typedefAdapter, record);
                }
            }
            TypedefDB typedefDB = typeDB;
            return typedefDB;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Array getArrayDataType(long dataTypeID, Record record) {
        this.lock.acquire();
        try {
            ArrayDB arrayDB = (ArrayDB)this.dtCache.get(dataTypeID);
            if (arrayDB == null) {
                if (record == null) {
                    record = this.arrayAdapter.getRecord(dataTypeID);
                }
                if (record != null) {
                    arrayDB = new ArrayDB(this, this.dtCache, this.arrayAdapter, record);
                }
            }
            ArrayDB arrayDB2 = arrayDB;
            return arrayDB2;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pointer getPointerDataType(long dataTypeID, Record record) {
        this.lock.acquire();
        try {
            PointerDB ptrDB = (PointerDB)this.dtCache.get(dataTypeID);
            if (ptrDB == null) {
                if (record == null) {
                    record = this.pointerAdapter.getRecord(dataTypeID);
                }
                if (record != null) {
                    ptrDB = new PointerDB(this, this.dtCache, this.pointerAdapter, record);
                }
            }
            PointerDB pointerDB = ptrDB;
            return pointerDB;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionDefinition getFunctionDefDataType(long dataTypeID, Record record) {
        this.lock.acquire();
        try {
            FunctionDefinitionDB funDef = (FunctionDefinitionDB)this.dtCache.get(dataTypeID);
            if (funDef == null) {
                if (record == null) {
                    record = this.functionDefAdapter.getRecord(dataTypeID);
                }
                if (record != null) {
                    funDef = new FunctionDefinitionDB(this, this.dtCache, this.functionDefAdapter, this.paramAdapter, record);
                }
            }
            FunctionDefinitionDB functionDefinitionDB = funDef;
            return functionDefinitionDB;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    private DataType createDataType(DataType dt, SourceArchive sourceArchive) {
        return this.createDataType(dt, sourceArchive, null);
    }

    private DataType createDataType(DataType dt, SourceArchive sourceArchive, DataTypeConflictHandler handler) {
        String name = dt.getName();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Data type must have a valid name");
        }
        try {
            this.resolveSourceArchive(sourceArchive);
            CategoryPath cp = dt.getCategoryPath();
            CategoryDB cat = (CategoryDB)this.createCategory(cp);
            UniversalID id = dt.getUniversalID();
            long sourceArchiveIdValue = 0L;
            if (sourceArchive == null) {
                id = UniversalIdGenerator.nextID();
            } else if (!sourceArchive.getSourceArchiveID().equals((Object)this.getUniversalID())) {
                sourceArchiveIdValue = sourceArchive.getSourceArchiveID().getValue();
            }
            DataType newDataType = null;
            if (dt instanceof Array) {
                Array array = (Array)dt;
                newDataType = this.createArray(array.getDataType(), array.getNumElements(), array.getElementLength(), cat, handler);
            } else if (dt instanceof Pointer) {
                Pointer ptr = (Pointer)dt;
                int len = ptr.isDynamicallySized() ? -1 : ptr.getLength();
                newDataType = this.createPointer(ptr.getDataType(), cat, (byte)len, handler);
            } else if (dt instanceof Structure) {
                Structure structure = (Structure)dt;
                newDataType = this.createStructure(structure, cat, sourceArchiveIdValue, id.getValue(), handler);
            } else if (dt instanceof TypeDef) {
                TypeDef typedef = (TypeDef)dt;
                newDataType = this.createTypeDef(typedef, cat, sourceArchiveIdValue, id.getValue(), handler);
            } else if (dt instanceof Union) {
                Union union = (Union)dt;
                newDataType = this.createUnion(union, cat, sourceArchiveIdValue, id.getValue(), handler);
            } else if (dt instanceof Enum) {
                Enum enumm = (Enum)dt;
                newDataType = this.createEnum(enumm, cat, sourceArchiveIdValue, id.getValue());
            } else if (dt instanceof FunctionDefinition) {
                FunctionDefinition funDef = (FunctionDefinition)dt;
                newDataType = this.createFunctionDefinition(funDef, cat, sourceArchiveIdValue, id.getValue(), handler);
            } else if (dt instanceof BuiltInDataType) {
                BuiltInDataType builtInDataType = (BuiltInDataType)dt;
                newDataType = this.createBuiltIn(builtInDataType, cat);
            } else if (dt instanceof MissingBuiltInDataType) {
                MissingBuiltInDataType missingBuiltInDataType = (MissingBuiltInDataType)dt;
                newDataType = this.createMissingBuiltIn(missingBuiltInDataType, cat);
            } else {
                throw new AssertException("Unknown data Type:" + dt.getDisplayName());
            }
            this.dataTypeAdded(newDataType, dt);
            return newDataType;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Structure createStructure(Structure struct, CategoryDB category, long sourceArchiveIdValue, long universalIdValue, DataTypeConflictHandler handler) throws IOException {
        try {
            ++this.creatingDataType;
            int len = struct.getLength();
            if (struct.isNotYetDefined()) {
                len = 0;
            }
            Record record = this.compositeAdapter.createRecord(struct.getName(), struct.getDescription(), false, category.getID(), len, sourceArchiveIdValue, universalIdValue, struct.getLastChangeTime(), this.getInternalAlignment(struct), this.getExternalAlignment(struct));
            StructureDB structDB = new StructureDB(this, this.dtCache, this.compositeAdapter, this.componentAdapter, record);
            category.dataTypeAdded(structDB);
            structDB.doReplaceWith(struct, false, handler);
            structDB.notifySizeChanged();
            structDB.setLastChangeTime(struct.getLastChangeTime());
            StructureDB structureDB = structDB;
            return structureDB;
        }
        finally {
            --this.creatingDataType;
        }
    }

    public boolean isChanged() {
        return this.dbHandle.isChanged();
    }

    private int getExternalAlignment(Composite struct) {
        if (struct.isDefaultAligned()) {
            return 0;
        }
        if (struct.isMachineAligned()) {
            return -1;
        }
        int alignment = struct.getMinimumAlignment();
        if (alignment == 0) {
            return 0;
        }
        return alignment;
    }

    private int getInternalAlignment(Composite struct) {
        if (struct.isInternallyAligned()) {
            int packingValue = struct.getPackingValue();
            if (packingValue == 0) {
                return 0;
            }
            return packingValue;
        }
        return -1;
    }

    private TypeDef createTypeDef(TypeDef typedef, Category cat, long sourceArchiveIdValue, long universalIdValue, DataTypeConflictHandler handler) throws IOException {
        DataType dataType = this.resolve(typedef.getDataType(), handler);
        Record record = this.typedefAdapter.createRecord(this.getID(dataType), typedef.getName(), cat.getID(), sourceArchiveIdValue, universalIdValue, typedef.getLastChangeTime());
        TypedefDB typedefDB = new TypedefDB(this, this.dtCache, this.typedefAdapter, record);
        dataType.addParent(typedefDB);
        return typedefDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Union createUnion(Union union, CategoryDB category, long sourceArchiveIdValue, long universalIdValue, DataTypeConflictHandler handler) throws IOException {
        try {
            ++this.creatingDataType;
            Record record = this.compositeAdapter.createRecord(union.getName(), null, true, category.getID(), 0, sourceArchiveIdValue, universalIdValue, union.getLastChangeTime(), this.getInternalAlignment(union), this.getExternalAlignment(union));
            UnionDB unionDB = new UnionDB(this, this.dtCache, this.compositeAdapter, this.componentAdapter, record);
            category.dataTypeAdded(unionDB);
            unionDB.doReplaceWith(union, false, handler);
            unionDB.notifySizeChanged();
            unionDB.setLastChangeTime(union.getLastChangeTime());
            UnionDB unionDB2 = unionDB;
            return unionDB2;
        }
        finally {
            --this.creatingDataType;
        }
    }

    private Enum createEnum(Enum enumm, Category cat, long sourceArchiveIdValue, long universalIdValue) throws IOException {
        String[] enumNames;
        Record record = this.enumAdapter.createRecord(enumm.getName(), enumm.getDescription(), cat.getID(), (byte)enumm.getLength(), sourceArchiveIdValue, universalIdValue, enumm.getLastChangeTime());
        long enumID = record.getKey();
        for (String enumName : enumNames = enumm.getNames()) {
            this.enumValueAdapter.createRecord(enumID, enumName, enumm.getValue(enumName));
        }
        EnumDB enumDB = new EnumDB(this, this.dtCache, this.enumAdapter, this.enumValueAdapter, record);
        return enumDB;
    }

    private Pointer createPointer(DataType dt, Category cat, byte length, DataTypeConflictHandler handler) throws IOException {
        if (dt != null) {
            dt = this.resolve(dt.clone(this), handler);
        }
        long dataTypeID = this.getResolvedID(dt);
        Record record = this.pointerAdapter.createRecord(dataTypeID, cat.getID(), length);
        PointerDB ptrDB = new PointerDB(this, this.dtCache, this.pointerAdapter, record);
        if (dt != null) {
            dt.addParent(ptrDB);
        }
        return ptrDB;
    }

    private Array createArray(DataType dt, int numElements, int elementLength, Category cat, DataTypeConflictHandler handler) throws IOException {
        if (dt instanceof FactoryDataType) {
            throw new IllegalArgumentException("Array data-type may not be a Factory data-type: " + dt.getName());
        }
        if (dt instanceof Dynamic && !((Dynamic)dt).canSpecifyLength()) {
            throw new IllegalArgumentException("Array data-type may not be a non-sizable Dynamic data-type: " + dt.getName());
        }
        if (elementLength <= 0) {
            throw new IllegalArgumentException("Array data-type must be Fixed length");
        }
        if (numElements <= 0) {
            throw new IllegalArgumentException("number of array elements must be positive, not " + numElements);
        }
        dt = this.resolve(dt, handler);
        long dataTypeID = this.getResolvedID(dt);
        if (!(dt instanceof Dynamic)) {
            elementLength = -1;
        }
        Record record = this.arrayAdapter.createRecord(dataTypeID, numElements, elementLength, cat.getID());
        this.addParentChildRecord(record.getKey(), dataTypeID);
        ArrayDB arrayDB = new ArrayDB(this, this.dtCache, this.arrayAdapter, record);
        dt.addParent(arrayDB);
        return arrayDB;
    }

    private void updateLastChangeTime() {
        SourceArchive mySourceArchive = this.getSourceArchive(this.getUniversalID());
        if (mySourceArchive == null) {
            return;
        }
        mySourceArchive.setLastSyncTime(System.currentTimeMillis());
    }

    private void setDirtyFlag(DataType dt) {
        SourceArchive sourceArchive = dt.getSourceArchive();
        if (sourceArchive == null) {
            return;
        }
        sourceArchive.setDirtyFlag(true);
    }

    @Override
    public List<SourceArchive> getSourceArchives() {
        Collection<SourceArchive> values = this.getSourceArchivesFromCache();
        ArrayList<SourceArchive> sourceArchives = new ArrayList<SourceArchive>();
        for (SourceArchive sourceArchive : values) {
            if (!this.isOtherAndNotBuiltIn(sourceArchive)) continue;
            sourceArchives.add(sourceArchive);
        }
        return sourceArchives;
    }

    private boolean isOtherAndNotBuiltIn(SourceArchive sourceArchive) {
        if (sourceArchive.getSourceArchiveID() == LOCAL_ARCHIVE_UNIVERSAL_ID) {
            return false;
        }
        if (sourceArchive.getSourceArchiveID() == this.universalID) {
            return false;
        }
        return sourceArchive.getSourceArchiveID() != BUILT_IN_ARCHIVE_UNIVERSAL_ID;
    }

    public SourceArchive getSourceArchive(String fileID) {
        for (SourceArchive archive : this.getSourceArchivesFromCache()) {
            if (!fileID.equals(archive.getDomainFileID())) continue;
            return archive;
        }
        return null;
    }

    @Override
    public SourceArchive getSourceArchive(UniversalID sourceID) {
        if (!LOCAL_ARCHIVE_UNIVERSAL_ID.equals((Object)sourceID)) {
            return this.getSourceArchiveFromCache(sourceID);
        }
        if (this.universalID == null) {
            return null;
        }
        return this.getSourceArchiveFromCache(this.universalID);
    }

    @Override
    public SourceArchive getLocalSourceArchive() {
        return this.getSourceArchive(this.getUniversalID());
    }

    private synchronized SourceArchive getSourceArchiveFromCache(UniversalID sourceID) {
        this.populateSourceArchiveCache();
        return this.sourceArchiveMap.get(sourceID);
    }

    private synchronized void invalidateSourceArchiveCache() {
        this.sourceArchiveMap = null;
    }

    private synchronized Collection<SourceArchive> getSourceArchivesFromCache() {
        this.populateSourceArchiveCache();
        return new ArrayList<SourceArchive>(this.sourceArchiveMap.values());
    }

    private synchronized void populateSourceArchiveCache() {
        if (this.sourceArchiveMap != null) {
            return;
        }
        HashMap<UniversalID, SourceArchive> archiveMap = new HashMap<UniversalID, SourceArchive>();
        archiveMap.put(BUILT_IN_ARCHIVE_UNIVERSAL_ID, BuiltInSourceArchive.INSTANCE);
        try {
            List<Record> records = this.sourceArchiveAdapter.getRecords();
            for (Record record : records) {
                SourceArchiveDB sourceArchive = this.getSourceArchiveDB(record);
                archiveMap.put(sourceArchive.getSourceArchiveID(), sourceArchive);
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        this.sourceArchiveMap = archiveMap;
    }

    private SourceArchiveDB getSourceArchiveDB(Record record) {
        SourceArchiveDB archive = this.sourceArchiveDBCache.get(record.getKey());
        if (archive == null) {
            archive = new SourceArchiveDB(this, this.sourceArchiveDBCache, this.sourceArchiveAdapter, record);
        }
        return archive;
    }

    @Override
    public boolean updateSourceArchiveName(String archiveFileID, String name) {
        SourceArchive sourceArchive = this.getSourceArchive(archiveFileID);
        if (sourceArchive != null && !sourceArchive.getName().equals(name)) {
            sourceArchive.setName(name);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateSourceArchiveName(UniversalID sourceID, String name) {
        SourceArchive sourceArchive = this.getSourceArchive(sourceID);
        if (sourceArchive != null && !sourceArchive.getName().equals(name)) {
            sourceArchive.setName(name);
            return true;
        }
        return false;
    }

    @Override
    public List<DataType> getDataTypes(SourceArchive sourceArchive) {
        ArrayList<DataType> sourceDataTypes = new ArrayList<DataType>();
        Iterator<DataType> allDataTypes = this.getAllDataTypes();
        while (allDataTypes.hasNext()) {
            DataType dt = allDataTypes.next();
            if (!sourceArchive.equals(dt.getSourceArchive())) continue;
            sourceDataTypes.add(dt);
        }
        return sourceDataTypes;
    }

    private DataType createMissingBuiltIn(MissingBuiltInDataType dt, Category category) throws IOException {
        Record record = this.builtinAdapter.createRecord(dt.getMissingBuiltInName(), dt.getMissingBuiltInClassPath(), category.getID());
        return this.getBuiltInDataType(record.getKey(), record);
    }

    private DataType createBuiltIn(BuiltInDataType dt, Category category) throws IOException {
        Record record = this.builtinAdapter.createRecord(dt.getName(), dt.getClass().getName(), category.getID());
        return this.getBuiltInDataType(record.getKey(), record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionDefinition createFunctionDefinition(FunctionDefinition funDef, Category cat, long sourceArchiveIdValue, long universalIdValue, DataTypeConflictHandler handler) throws IOException {
        DataType retType = this.resolve(funDef.getReturnType(), handler);
        try {
            ++this.creatingDataType;
            Record record = this.functionDefAdapter.createRecord(funDef.getName(), funDef.getComment(), cat.getID(), this.getID(retType), funDef.hasVarArgs(), funDef.getGenericCallingConvention(), sourceArchiveIdValue, universalIdValue, funDef.getLastChangeTime());
            FunctionDefinitionDB funDefDb = new FunctionDefinitionDB(this, this.dtCache, this.functionDefAdapter, this.paramAdapter, record);
            retType.addParent(funDefDb);
            funDefDb.setArguments(funDef.getArguments());
            funDefDb.setLastChangeTime(funDef.getLastChangeTime());
            FunctionDefinitionDB functionDefinitionDB = funDefDb;
            return functionDefinitionDB;
        }
        finally {
            --this.creatingDataType;
        }
    }

    public void dbError(IOException e) {
        this.errHandler.dbError(e);
    }

    SettingsDBAdapter getSettingsAdapter() {
        return this.settingsAdapter;
    }

    void dataTypeCategoryPathChanged(DataTypeDB dt, CategoryPath oldPath) {
        if (!(dt instanceof Array) && !(dt instanceof Pointer)) {
            try {
                Record rec;
                RecordIterator it = this.arrayAdapter.getRecords();
                while (it.hasNext()) {
                    rec = it.next();
                    ArrayDB array = (ArrayDB)this.getDataType(rec.getKey(), rec);
                    array.updatePath(dt);
                }
                it = this.pointerAdapter.getRecords();
                while (it.hasNext()) {
                    rec = it.next();
                    PointerDB ptr = (PointerDB)this.getDataType(rec.getKey(), rec);
                    ptr.updatePath(dt);
                }
            }
            catch (IOException e) {
                this.dbError(e);
            }
        }
        this.dataTypeMoved(dt, new DataTypePath(oldPath, dt.getName()), dt.getDataTypePath());
    }

    @Override
    public Iterator<DataType> getAllDataTypes() {
        this.lock.acquire();
        try {
            this.buildSortedDataTypeList();
            Iterator<DataType> iterator = new ArrayList<DataType>(this.sortedDataTypes).iterator();
            return iterator;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void getAllDataTypes(List<DataType> list) {
        this.lock.acquire();
        try {
            this.buildSortedDataTypeList();
            list.addAll(this.sortedDataTypes);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Iterator<Structure> getAllStructures() {
        try {
            return new StructureIterator();
        }
        catch (IOException e) {
            this.dbError(e);
            return new ArrayList().iterator();
        }
    }

    @Override
    public Iterator<Composite> getAllComposites() {
        try {
            return new CompositeIterator();
        }
        catch (IOException e) {
            this.dbError(e);
            return new ArrayList().iterator();
        }
    }

    public void invalidateCache() {
        this.lock.acquire();
        try {
            this.dtCache.invalidate();
            this.sourceArchiveDBCache.invalidate();
            this.invalidateSourceArchiveCache();
            this.builtInMap.clear();
            this.builtIn2IdMap.clear();
            this.root.setInvalid();
            this.catCache.invalidate();
            this.settingsCache.clear();
            this.sortedDataTypes = null;
            this.enumValueMap = null;
            this.fireInvalidated();
            this.updateFavorites();
            this.idsToDataTypeMap.clear();
        }
        finally {
            this.lock.release();
        }
    }

    private void updateFavorites() {
        Iterator<DataType> it = this.favoritesList.iterator();
        while (it.hasNext()) {
            DataType dt = it.next();
            if (this.contains(dt)) continue;
            it.remove();
            this.favoritesChanged(dt, false);
        }
    }

    public boolean setLongSettingsValue(Address dataAddr, String name, long value) {
        return this.updateInstanceSettings(dataAddr, name, null, value, null);
    }

    public boolean setStringSettingsValue(Address dataAddr, String name, String value) {
        return this.updateInstanceSettings(dataAddr, name, value, -1L, null);
    }

    public boolean setByteSettingsValue(Address dataAddr, String name, byte[] byteValue) {
        return this.updateInstanceSettings(dataAddr, name, null, -1L, byteValue);
    }

    public boolean setSettings(Address dataAddr, String name, Object value) {
        if (value instanceof String) {
            return this.updateInstanceSettings(dataAddr, name, (String)value, -1L, null);
        }
        if (value instanceof byte[]) {
            return this.updateInstanceSettings(dataAddr, name, null, -1L, (byte[])value);
        }
        if (this.isAllowedNumberType(value)) {
            return this.updateInstanceSettings(dataAddr, name, null, ((Number)value).longValue(), null);
        }
        throw new IllegalArgumentException("Unsupportd Settings Value: " + (value == null ? "null" : value.getClass().getName()));
    }

    private boolean isAllowedNumberType(Object value) {
        if (value instanceof Long) {
            return true;
        }
        if (value instanceof Integer) {
            return true;
        }
        if (value instanceof Short) {
            return true;
        }
        return value instanceof Byte;
    }

    public Long getLongSettingsValue(Address dataAddr, String name) {
        InstanceSettingsDB settings = this.getInstanceSettingsDB(dataAddr, name);
        if (settings != null) {
            return settings.getLongValue();
        }
        return null;
    }

    public String getStringSettingsValue(Address dataAddr, String name) {
        InstanceSettingsDB settings = this.getInstanceSettingsDB(dataAddr, name);
        if (settings != null) {
            return settings.getStringValue();
        }
        return null;
    }

    public byte[] getByteSettingsValue(Address dataAddr, String name) {
        InstanceSettingsDB settings = this.getInstanceSettingsDB(dataAddr, name);
        if (settings != null) {
            return settings.getByteValue();
        }
        return null;
    }

    public Object getSettings(Address dataAddr, String name) {
        Object obj = this.getStringSettingsValue(dataAddr, name);
        if (obj != null) {
            return obj;
        }
        obj = this.getByteSettingsValue(dataAddr, name);
        if (obj != null) {
            return obj;
        }
        return this.getLongSettingsValue(dataAddr, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearSetting(Address dataAddr, String name) {
        if (this.instanceSettingsAdapter == null) {
            throw new UnsupportedOperationException();
        }
        this.lock.acquire();
        try {
            InstanceSettingsDB settings = this.getInstanceSettingsDB(dataAddr, name);
            if (settings != null) {
                long key = settings.getKey();
                this.settingsCache.remove(dataAddr, name);
                this.instanceSettingsAdapter.removeInstanceRecord(key);
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllSettings(Address dataAddr) {
        if (this.instanceSettingsAdapter == null) {
            throw new UnsupportedOperationException();
        }
        this.lock.acquire();
        try {
            long[] keys;
            this.settingsCache.clear();
            for (long key : keys = this.instanceSettingsAdapter.getInstanceKeys(this.addrMap.getKey(dataAddr, false))) {
                this.instanceSettingsAdapter.removeInstanceRecord(key);
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSettings(Address start, Address end, TaskMonitor monitor) throws CancelledException {
        if (this.instanceSettingsAdapter == null) {
            throw new UnsupportedOperationException();
        }
        this.lock.acquire();
        try {
            this.settingsCache.clear();
            List<KeyRange> keyRanges = this.addrMap.getKeyRanges(start, end, false);
            for (KeyRange range : keyRanges) {
                RecordIterator iter = this.instanceSettingsAdapter.getRecords(range.minKey, range.maxKey);
                while (iter.hasNext()) {
                    if (monitor.isCancelled()) {
                        throw new CancelledException();
                    }
                    iter.next();
                    iter.delete();
                }
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
        if (this.instanceSettingsAdapter == null) {
            throw new UnsupportedOperationException();
        }
        DBHandle scratchPad = null;
        this.lock.acquire();
        try {
            this.settingsCache.clear();
            scratchPad = this.dbHandle.getScratchPad();
            Table tmpTable = scratchPad.createTable("Instance Settings", InstanceSettingsDBAdapterV0.V0_INSTANCE_SCHEMA);
            List<KeyRange> keyRanges = this.addrMap.getKeyRanges(fromAddr, fromAddr.add(length - 1L), false);
            for (KeyRange range : keyRanges) {
                RecordIterator iter = this.instanceSettingsAdapter.getRecords(range.minKey, range.maxKey);
                while (iter.hasNext()) {
                    monitor.checkCanceled();
                    Record rec = iter.next();
                    tmpTable.putRecord(rec);
                    iter.delete();
                }
            }
            RecordIterator iter = tmpTable.iterator();
            while (iter.hasNext()) {
                monitor.checkCanceled();
                Record rec = iter.next();
                Address addr = this.addrMap.decodeAddress(rec.getLongValue(0));
                long offset = addr.subtract(fromAddr);
                addr = toAddr.add(offset);
                rec.setLongValue(0, this.addrMap.getKey(addr, true));
                this.instanceSettingsAdapter.updateInstanceRecord(rec);
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            if (scratchPad != null) {
                try {
                    scratchPad.deleteTable("Instance Settings");
                }
                catch (IOException iOException) {}
            }
            this.lock.release();
        }
    }

    @Override
    public boolean isUpdatable() {
        return this.dbHandle.canUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNames(Address dataAddr) {
        if (this.instanceSettingsAdapter == null) {
            throw new UnsupportedOperationException();
        }
        this.lock.acquire();
        try {
            long[] keys = this.instanceSettingsAdapter.getInstanceKeys(this.addrMap.getKey(dataAddr, false));
            ArrayList<String> list = new ArrayList<String>();
            for (long key : keys) {
                Record rec = this.instanceSettingsAdapter.getInstanceRecord(key);
                list.add(rec.getString(1));
            }
            String[] names = new String[list.size()];
            String[] stringArray = list.toArray(names);
            return stringArray;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    public boolean isEmptySetting(Address dataAddr) {
        if (this.instanceSettingsAdapter == null) {
            throw new UnsupportedOperationException();
        }
        try {
            return this.instanceSettingsAdapter.getInstanceKeys(this.addrMap.getKey(dataAddr, false)).length == 0;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateInstanceSettings(Address dataAddr, String name, String strValue, long longValue, byte[] byteValue) {
        boolean wasChanged = false;
        this.lock.acquire();
        try {
            if (this.instanceSettingsAdapter == null) {
                throw new UnsupportedOperationException();
            }
            InstanceSettingsDB settings = this.getInstanceSettingsDB(dataAddr, name);
            if (settings == null) {
                wasChanged = true;
                Record rec = this.instanceSettingsAdapter.createInstanceRecord(this.addrMap.getKey(dataAddr, true), name, strValue, longValue, byteValue);
                settings = new InstanceSettingsDB(rec);
                this.settingsCache.put(dataAddr, name, settings);
            } else {
                long recLongValue;
                byte[] recByteValue;
                Record rec = settings.getRecord();
                String recStrValue = rec.getString(3);
                wasChanged = SettingsDBManager.valuesChanged(recStrValue, strValue, byteValue, recByteValue = rec.getBinaryData(4), recLongValue = rec.getLongValue(2), longValue);
                if (wasChanged) {
                    rec.setString(3, strValue);
                    rec.setLongValue(2, longValue);
                    rec.setBinaryData(4, byteValue);
                    this.instanceSettingsAdapter.updateInstanceRecord(rec);
                }
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return wasChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstanceSettingsDB getInstanceSettingsDB(Address dataAddr, String name) {
        this.lock.acquire();
        try {
            if (this.instanceSettingsAdapter == null) {
                throw new UnsupportedOperationException();
            }
            InstanceSettingsDB settings = this.settingsCache.getInstanceSettings(dataAddr, name);
            if (settings != null) {
                InstanceSettingsDB instanceSettingsDB = settings;
                return instanceSettingsDB;
            }
            long addr = this.addrMap.getKey(dataAddr, false);
            Record rec = this.getInstanceRecord(addr, name);
            if (rec != null) {
                settings = new InstanceSettingsDB(rec);
                this.settingsCache.put(dataAddr, name, settings);
                InstanceSettingsDB instanceSettingsDB = settings;
                return instanceSettingsDB;
            }
            InstanceSettingsDB instanceSettingsDB = null;
            return instanceSettingsDB;
        }
        finally {
            this.lock.release();
        }
    }

    private Record getInstanceRecord(long addr, String name) {
        try {
            long[] keys;
            for (long key : keys = this.instanceSettingsAdapter.getInstanceKeys(addr)) {
                Record rec = this.instanceSettingsAdapter.getInstanceRecord(key);
                if (!rec.getString(1).equals(name)) continue;
                return rec;
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        return null;
    }

    static long createKey(int tableID, long tableKey) {
        long key = (long)tableID << 56;
        return key |= tableKey;
    }

    void addParentChildRecord(long parentID, long childID) {
        try {
            this.parentChildAdapter.createRecord(parentID, childID);
        }
        catch (IOException e) {
            this.dbError(e);
        }
    }

    private void removeAllParentChildRecordsForChild(long childID) {
        try {
            this.parentChildAdapter.removeAllRecordsForChild(childID);
        }
        catch (IOException e) {
            this.dbError(e);
        }
    }

    void removeParentChildRecord(long parentID, long childID) {
        if (this.isBulkRemoving) {
            return;
        }
        try {
            this.parentChildAdapter.removeRecord(parentID, childID);
        }
        catch (IOException e) {
            this.dbError(e);
        }
    }

    DataType[] getParentDataTypes(long childID) {
        try {
            long[] ids = this.parentChildAdapter.getParentIds(childID);
            DataType[] dts = new DataType[ids.length];
            for (int i = 0; i < dts.length; ++i) {
                dts[i] = this.getDataType(ids[i]);
            }
            return dts;
        }
        catch (IOException e) {
            this.dbError(e);
            return null;
        }
    }

    @Override
    public Set<DataType> getDataTypesContaining(DataType dataType) {
        HashSet<DataType> set = new HashSet<DataType>();
        if (dataType instanceof DataTypeDB) {
            long dataTypeID = ((DataTypeDB)dataType).getKey();
            try {
                long[] ids;
                for (long id : ids = this.parentChildAdapter.getParentIds(dataTypeID)) {
                    set.add(this.getDataType(id));
                }
            }
            catch (IOException e) {
                this.dbError(e);
            }
        }
        return set;
    }

    @Override
    public Pointer getPointer(DataType dt) {
        return new PointerDataType(dt, -1, (DataTypeManager)this);
    }

    @Override
    public Pointer getPointer(DataType dt, int size) {
        return new PointerDataType(dt, size, (DataTypeManager)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException {
        if (this.instanceSettingsAdapter == null) {
            throw new UnsupportedOperationException();
        }
        this.lock.acquire();
        try {
            List<KeyRange> addrKeyRanges = this.addrMap.getKeyRanges(startAddr, endAddr, false);
            int cnt = addrKeyRanges.size();
            for (int i = 0; i < cnt; ++i) {
                KeyRange kr = addrKeyRanges.get(i);
                this.instanceSettingsAdapter.delete(kr.minKey, kr.maxKey, monitor);
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.settingsCache.clear();
            this.lock.release();
        }
    }

    @Override
    public void addDataTypeManagerListener(DataTypeManagerChangeListener l) {
        this.defaultListener.addDataTypeManagerListener(l);
    }

    @Override
    public void removeDataTypeManagerListener(DataTypeManagerChangeListener l) {
        this.defaultListener.removeDataTypeManagerListener(l);
    }

    protected boolean isCreatingDataType() {
        return this.creatingDataType != 0;
    }

    @Override
    public void dataTypeChanged(DataType dt) {
        if (dt instanceof Enum) {
            this.enumValueMap = null;
        }
        if (this.creatingDataType == 0) {
            this.updateLastChangeTime();
            this.setDirtyFlag(dt);
        }
        this.defaultListener.dataTypeChanged(this, dt.getDataTypePath());
    }

    protected void dataTypeAdded(DataType newDt, DataType originalDataType) {
        CategoryDB category = (CategoryDB)this.getCategory(newDt.getCategoryPath());
        category.dataTypeAdded(newDt);
        this.insertDataTypeIntoSortedList(newDt);
        if (newDt instanceof Enum) {
            this.enumValueMap = null;
        }
        this.updateLastChangeTime();
        this.defaultListener.dataTypeAdded(this, newDt.getDataTypePath());
    }

    protected void dataTypeReplaced(long existingDtID, DataTypePath replacedDataTypePath, DataType replacementDt) {
        CategoryDB category = (CategoryDB)this.getCategory(replacedDataTypePath.getCategoryPath());
        category.dataTypeRemoved(replacedDataTypePath.getDataTypeName());
        this.removeDataTypeFromSortedList(replacedDataTypePath);
        this.enumValueMap = null;
        this.updateLastChangeTime();
        this.defaultListener.dataTypeReplaced(this, replacedDataTypePath, replacementDt.getDataTypePath(), replacementDt);
    }

    protected void dataTypeDeleted(long deletedID, DataTypePath deletedDataTypePath) {
        CategoryDB category = (CategoryDB)this.getCategory(deletedDataTypePath.getCategoryPath());
        category.dataTypeRemoved(deletedDataTypePath.getDataTypeName());
        this.removeDataTypeFromSortedList(deletedDataTypePath);
        this.enumValueMap = null;
        this.updateLastChangeTime();
        this.defaultListener.dataTypeRemoved(this, deletedDataTypePath);
    }

    protected void dataTypeMoved(DataType dt, DataTypePath oldDataTypePath, DataTypePath newDataTypePath) {
        CategoryDB category = (CategoryDB)this.getCategory(oldDataTypePath.getCategoryPath());
        category.dataTypeRemoved(oldDataTypePath.getDataTypeName());
        this.removeDataTypeFromSortedList(oldDataTypePath);
        category = (CategoryDB)this.getCategory(newDataTypePath.getCategoryPath());
        category.dataTypeAdded(dt);
        this.insertDataTypeIntoSortedList(dt);
        this.updateLastChangeTime();
        this.defaultListener.dataTypeMoved(this, oldDataTypePath, newDataTypePath);
    }

    protected void dataTypeNameChanged(DataType dt, String oldName) {
        CategoryDB category = (CategoryDB)this.getCategory(dt.getCategoryPath());
        category.dataTypeRenamed(dt, oldName);
        if (this.sortedDataTypes != null) {
            Collections.sort(this.sortedDataTypes, this.nameComparator);
        }
        this.updateLastChangeTime();
        this.setDirtyFlag(dt);
        this.defaultListener.dataTypeRenamed(this, new DataTypePath(dt.getCategoryPath(), oldName), dt.getDataTypePath());
    }

    protected void categoryCreated(Category cat) {
        this.updateLastChangeTime();
        this.defaultListener.categoryAdded(this, cat.getCategoryPath());
    }

    protected void categoryRenamed(CategoryPath oldPath, Category category) {
        this.catCache.invalidate();
        this.updateLastChangeTime();
        this.defaultListener.categoryRenamed(this, oldPath, category.getCategoryPath());
    }

    protected void categoryRemoved(Category parent, String name, long categoryID) {
        this.catCache.delete(categoryID);
        this.updateLastChangeTime();
        this.defaultListener.categoryRemoved(this, new CategoryPath(parent.getCategoryPath(), name));
    }

    protected void categoryMoved(CategoryPath oldPath, Category category) {
        this.catCache.invalidate();
        this.updateLastChangeTime();
        this.defaultListener.categoryMoved(this, oldPath, category.getCategoryPath());
    }

    protected void favoritesChanged(DataType dataType, boolean isFavorite) {
        this.defaultListener.favoritesChanged(this, dataType.getDataTypePath(), isFavorite);
    }

    public void sourceArchiveChanged(UniversalID sourceArchiveID) {
        SourceArchive sourceArchive = this.getSourceArchive(sourceArchiveID);
        this.defaultListener.sourceArchiveChanged(this, sourceArchive);
    }

    protected void sourceArchiveAdded(UniversalID sourceArchiveID) {
        SourceArchive sourceArchive = this.getSourceArchive(sourceArchiveID);
        this.defaultListener.sourceArchiveAdded(this, sourceArchive);
    }

    CategoryDBAdapter getCategoryDBAdapter() {
        return this.categoryAdapter;
    }

    @Override
    public long getLastChangeTimeForMyManager() {
        SourceArchive archive = this.getSourceArchive(this.getUniversalID());
        if (archive != null) {
            return archive.getLastSyncTime();
        }
        return 0L;
    }

    @Override
    public DataType getDataType(SourceArchive sourceArchive, UniversalID datatypeID) {
        if (datatypeID.getValue() == 0L) {
            throw new AssertException("should not be called with id of 0");
        }
        UniversalID sourceID = sourceArchive == null ? null : sourceArchive.getSourceArchiveID();
        return this.idsToDataTypeMap.getDataType(sourceID, datatypeID);
    }

    @Override
    public DataType findDataTypeForID(UniversalID datatypeID) {
        SourceArchive localSA = this.getLocalSourceArchive();
        DataType dt = this.getDataType(localSA, datatypeID);
        if (dt != null) {
            return dt;
        }
        for (SourceArchive sa : this.getSourceArchives()) {
            if (sa == localSA || (dt = this.getDataType(sa, datatypeID)) == null) continue;
            return dt;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataType findDataTypeForIDs(UniversalID sourceID, UniversalID datatypeID) {
        this.lock.acquire();
        Record record = null;
        try {
            record = this.typedefAdapter.getRecordWithIDs(sourceID, datatypeID);
            if (record == null) {
                record = this.compositeAdapter.getRecordWithIDs(sourceID, datatypeID);
            }
            if (record == null) {
                record = this.functionDefAdapter.getRecordWithIDs(sourceID, datatypeID);
            }
            if (record == null) {
                record = this.enumAdapter.getRecordWithIDs(sourceID, datatypeID);
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        if (record != null) {
            return this.getDataType(record.getKey(), record);
        }
        return null;
    }

    @Override
    public DataOrganization getDataOrganization() {
        if (this.dataOrganization == null) {
            this.dataOrganization = DataOrganizationImpl.getDefaultOrganization();
        }
        return this.dataOrganization;
    }

    private boolean checkForSourceArchiveUpdatesNeeded(int openMode, TaskMonitor monitor) throws IOException {
        if (openMode == 0 || openMode == 2) {
            return false;
        }
        List<Record> records = this.sourceArchiveAdapter.getRecords();
        for (Record record : records) {
            if (!SourceArchiveUpgradeMap.isReplacedSourceArchive(record.getKey())) continue;
            return true;
        }
        return false;
    }

    protected void doSourceArchiveUpdates(CompilerSpec compilerSpec, TaskMonitor monitor) throws CancelledException {
        SourceArchiveUpgradeMap upgradeMap = new SourceArchiveUpgradeMap();
        for (SourceArchive sourceArchive : this.getSourceArchives()) {
            SourceArchive mappedSourceArchive = upgradeMap.getMappedSourceArchive(sourceArchive, compilerSpec);
            if (mappedSourceArchive == null) continue;
            this.replaceSourceArchive(sourceArchive, mappedSourceArchive);
        }
        BuiltInDataTypeManager builtInDTM = BuiltInDataTypeManager.getDataTypeManager();
        for (String name : SourceArchiveUpgradeMap.getTypedefReplacements()) {
            DataType builtIn;
            monitor.checkCanceled();
            DataType dataType = this.getDataType(CategoryPath.ROOT, name);
            if (!(dataType instanceof TypeDef) || (builtIn = builtInDTM.getDataType(CategoryPath.ROOT, name)) == null) continue;
            try {
                this.replace(dataType, this.resolve(builtIn, null));
            }
            catch (DataTypeDependencyException e) {
                throw new AssertException("Got DataTypeDependencyException on built in");
            }
        }
    }

    class IdsToDataTypeMap {
        private Map<UniversalID, LongObjectHashtable<DataType>> map = new HashMap<UniversalID, LongObjectHashtable<DataType>>();

        IdsToDataTypeMap() {
        }

        DataType getDataType(UniversalID sourceID, UniversalID dataTypeID) {
            DataType dt;
            LongObjectHashtable idMap;
            if (sourceID == null || sourceID.equals((Object)DataTypeManagerDB.this.universalID)) {
                sourceID = DataTypeManager.LOCAL_ARCHIVE_UNIVERSAL_ID;
            }
            if ((idMap = this.map.get(sourceID)) == null) {
                idMap = new LongObjectHashtable();
                this.map.put(sourceID, (LongObjectHashtable<DataType>)idMap);
            }
            if ((dt = (DataType)idMap.get(dataTypeID.getValue())) != null) {
                return dt;
            }
            dt = DataTypeManagerDB.this.findDataTypeForIDs(sourceID, dataTypeID);
            if (dt != null) {
                idMap.put(dataTypeID.getValue(), (Object)dt);
            }
            return dt;
        }

        public void clear() {
            this.map.clear();
        }

        void removeDataType(SourceArchive sourceArchive, UniversalID dataTypeID) {
            if (dataTypeID == null) {
                return;
            }
            UniversalID sourceID = sourceArchive == null || sourceArchive.getSourceArchiveID().equals((Object)DataTypeManagerDB.this.universalID) ? DataTypeManager.LOCAL_ARCHIVE_UNIVERSAL_ID : sourceArchive.getSourceArchiveID();
            LongObjectHashtable<DataType> idMap = this.map.get(sourceID);
            if (idMap != null) {
                idMap.remove(dataTypeID.getValue());
            }
        }
    }

    private class NameComparator
    implements Comparator<DataType> {
        private NameComparator() {
        }

        @Override
        public int compare(DataType d1, DataType d2) {
            int c = d1.getName().compareTo(d2.getName());
            if (c == 0) {
                return d1.getCategoryPath().compareTo(d2.getCategoryPath());
            }
            return c;
        }
    }

    class CompositeIterator
    implements Iterator<Composite> {
        private RecordIterator it;
        private Composite nextComposite;

        CompositeIterator() throws IOException {
            this.it = DataTypeManagerDB.this.compositeAdapter.getRecords();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }

        @Override
        public boolean hasNext() {
            if (this.nextComposite == null) {
                this.getNextComposite();
            }
            return this.nextComposite != null;
        }

        @Override
        public Composite next() {
            if (this.hasNext()) {
                Composite c = this.nextComposite;
                this.nextComposite = null;
                return c;
            }
            return null;
        }

        private void getNextComposite() {
            try {
                if (this.it.hasNext()) {
                    Record rec = this.it.next();
                    this.nextComposite = (Composite)DataTypeManagerDB.this.getDataType(rec.getKey(), rec);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    class StructureIterator
    implements Iterator<Structure> {
        private RecordIterator it;
        private Structure nextStruct;

        StructureIterator() throws IOException {
            this.it = DataTypeManagerDB.this.compositeAdapter.getRecords();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }

        @Override
        public boolean hasNext() {
            if (this.nextStruct == null) {
                this.getNextStruct();
            }
            return this.nextStruct != null;
        }

        @Override
        public Structure next() {
            if (this.hasNext()) {
                Structure s = this.nextStruct;
                this.nextStruct = null;
                return s;
            }
            return null;
        }

        private void getNextStruct() {
            try {
                while (this.it.hasNext()) {
                    Record rec = this.it.next();
                    DataType dt = DataTypeManagerDB.this.getDataType(rec.getKey(), rec);
                    if (!(dt instanceof Structure)) continue;
                    this.nextStruct = (Structure)dt;
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

