/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.references;

import ghidra.program.model.symbol.SourceType;

class RefListFlagsV0 {
    private static final int SOURCE_LOBIT = 1;
    private static final int IS_PRIMARY = 2;
    private static final int IS_OFFSET = 4;
    private static final int HAS_SYMBOL_ID = 8;
    private static final int IS_SHIFT = 16;
    private static final int SOURCE_HIBIT = 32;
    private int flags;

    RefListFlagsV0(byte flags) {
        this.flags = flags;
    }

    public RefListFlagsV0(boolean isPrimary, boolean isOffsetRef, boolean hasSymbolID, boolean isShiftRef, SourceType source) {
        this.flags = 0;
        if (source == SourceType.USER_DEFINED || source == SourceType.IMPORTED) {
            this.flags |= 1;
        }
        if (source == SourceType.ANALYSIS || source == SourceType.IMPORTED) {
            this.flags |= 0x20;
        }
        if (isPrimary) {
            this.flags |= 2;
        }
        if (isOffsetRef) {
            this.flags |= 4;
        }
        if (hasSymbolID) {
            this.flags |= 8;
        }
        if (isShiftRef) {
            this.flags |= 0x10;
        }
    }

    byte getValue() {
        return (byte)this.flags;
    }

    SourceType getSource() {
        boolean isHiBit;
        boolean isLoBit = (this.flags & 1) != 0;
        boolean bl = isHiBit = (this.flags & 0x20) != 0;
        if (isHiBit) {
            return isLoBit ? SourceType.IMPORTED : SourceType.ANALYSIS;
        }
        return isLoBit ? SourceType.USER_DEFINED : SourceType.DEFAULT;
    }

    public boolean hasSymbolID() {
        return (this.flags & 8) != 0;
    }

    public boolean isShiftRef() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isOffsetRef() {
        return (this.flags & 4) != 0;
    }

    public boolean isPrimary() {
        return (this.flags & 2) != 0;
    }

    public void setPrimary(boolean isPrimary) {
        this.flags &= 0xFFFFFFFD;
        if (isPrimary) {
            this.flags |= 2;
        }
    }

    public void setHasSymbolID(boolean hasSymbolID) {
        this.flags &= 0xFFFFFFF7;
        if (hasSymbolID) {
            this.flags |= 8;
        }
    }
}

