/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.StringFormat;
import ghidra.util.classfinder.ClassTranslator;

public class Undefined3DataType
extends Undefined {
    private static final long serialVersionUID = 1L;
    public static final Undefined3DataType dataType;

    public Undefined3DataType() {
        this(null);
    }

    public Undefined3DataType(DataTypeManager dtm) {
        super("undefined3", dtm);
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public String getDescription() {
        return "Undefined 3-Byte";
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.name;
    }

    private long getValue(MemBuffer buf) throws MemoryAccessException {
        long val = (long)(buf.getShort(0) << 8) + ((long)buf.getByte(2) & 0xFFL);
        return val & 0xFFFFFFL;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        String val = "??";
        try {
            long b = this.getValue(buf);
            val = Long.toHexString(b).toUpperCase();
            val = StringFormat.padIt((String)val, (int)6, (char)'h', (boolean)true);
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
        return val;
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        try {
            return new Scalar(24, this.getValue(buf));
        }
        catch (MemoryAccessException e) {
            return null;
        }
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new Undefined3DataType(dtm);
    }

    static {
        ClassTranslator.put((String)"ghidra.program.model.data.Undefined3", (String)Undefined3DataType.class.getName());
        dataType = new Undefined3DataType();
    }
}

