/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.sleigh.VarnodeData;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Register;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;
import java.util.Map;

public class ParamEntry {
    private static final int FORCE_LEFT_JUSTIFY = 1;
    private static final int REVERSE_STACK = 2;
    private static final int SMALLSIZE_ZEXT = 4;
    private static final int SMALLSIZE_SEXT = 8;
    private static final int IS_BIG_ENDIAN = 16;
    private static final int SMALLSIZE_INTTYPE = 32;
    private static final int SMALLSIZE_FLOAT = 64;
    public static final int TYPE_UNKNOWN = 8;
    public static final int TYPE_PTR = 2;
    public static final int TYPE_FLOAT = 3;
    private int flags;
    private int type;
    private int group;
    private int groupsize;
    private AddressSpace spaceid;
    private long addressbase;
    private int size;
    private int minsize;
    private int alignment;
    private int numslots;
    private Varnode[] joinrec;

    public ParamEntry(int grp) {
        this.group = grp;
    }

    public int getGroup() {
        return this.group;
    }

    public int getGroupSize() {
        return this.groupsize;
    }

    public int getSize() {
        return this.size;
    }

    public int getMinSize() {
        return this.minsize;
    }

    public int getAlign() {
        return this.alignment;
    }

    public long getAddressBase() {
        return this.addressbase;
    }

    public int getType() {
        return this.type;
    }

    public boolean isExclusion() {
        return this.alignment == 0;
    }

    public boolean isReverseStack() {
        return (this.flags & 2) != 0;
    }

    public boolean isBigEndian() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isFloatExtended() {
        return (this.flags & 0x40) != 0;
    }

    private boolean isLeftJustified() {
        return (this.flags & 0x10) == 0 || (this.flags & 1) != 0;
    }

    public AddressSpace getSpace() {
        return this.spaceid;
    }

    public Varnode[] getJoinRecord() {
        return this.joinrec;
    }

    public boolean contains(ParamEntry op2) {
        if (this.type != 8 && op2.type != this.type) {
            return false;
        }
        if (this.spaceid != op2.spaceid) {
            return false;
        }
        if (ParamEntry.unsignedCompare(op2.addressbase, this.addressbase)) {
            return false;
        }
        long end = this.addressbase + (long)this.size - 1L;
        long op2end = op2.addressbase + (long)op2.size - 1L;
        if (ParamEntry.unsignedCompare(end, op2end)) {
            return false;
        }
        return this.alignment == op2.alignment;
    }

    public int justifiedContain(Address addr, int sz) {
        if (this.joinrec != null) {
            int res = 0;
            for (int i = this.joinrec.length - 1; i >= 0; --i) {
                Varnode vdata = this.joinrec[i];
                int cur = ParamEntry.justifiedContainAddress(vdata.getAddress().getAddressSpace(), vdata.getOffset(), vdata.getSize(), addr.getAddressSpace(), addr.getOffset(), sz, false, (this.flags & 0x10) != 0);
                if (cur < 0) {
                    res += vdata.getSize();
                    continue;
                }
                return res + cur;
            }
            return -1;
        }
        if (this.alignment == 0) {
            return ParamEntry.justifiedContainAddress(this.spaceid, this.addressbase, this.size, addr.getAddressSpace(), addr.getOffset(), sz, (this.flags & 1) != 0, (this.flags & 0x10) != 0);
        }
        if (this.spaceid != addr.getAddressSpace()) {
            return -1;
        }
        if (ParamEntry.unsignedCompare(addr.getOffset(), this.addressbase)) {
            return -1;
        }
        long endaddr = addr.getOffset() + (long)sz - 1L;
        if (ParamEntry.unsignedCompare(endaddr, addr.getOffset())) {
            return -1;
        }
        if (ParamEntry.unsignedCompare(this.addressbase + (long)this.size - 1L, endaddr)) {
            return -1;
        }
        if (!this.isLeftJustified()) {
            int res = (int)((endaddr + 1L) % (long)this.alignment);
            if (res == 0) {
                return 0;
            }
            return this.alignment - res;
        }
        return (int)(addr.getOffset() % (long)this.alignment);
    }

    public int getSlot(Address addr, int skip) {
        int res = this.group;
        if (this.alignment != 0) {
            long diff = addr.getOffset() + (long)skip - this.addressbase;
            int baseslot = (int)diff / this.alignment;
            res = this.isReverseStack() ? (res += this.numslots - 1 - baseslot) : (res += baseslot);
        } else if (skip != 0) {
            res += this.groupsize - 1;
        }
        return res;
    }

    public int getAddrBySlot(int slotnum, int sz, VarnodeData res) {
        int spaceused;
        res.space = null;
        if (sz < this.minsize) {
            return slotnum;
        }
        if (this.alignment == 0) {
            if (slotnum != 0) {
                return slotnum;
            }
            if (sz > this.size) {
                return slotnum;
            }
            res.space = this.spaceid;
            res.offset = this.addressbase;
            spaceused = this.size;
            if ((this.flags & 0x40) != 0) {
                return slotnum;
            }
        } else {
            int index;
            int slotsused = sz / this.alignment;
            if (sz % this.alignment != 0) {
                ++slotsused;
            }
            if (slotnum + slotsused > this.numslots) {
                return slotnum;
            }
            spaceused = slotsused * this.alignment;
            if (this.isReverseStack()) {
                index = this.numslots;
                index -= slotnum;
                index -= slotsused;
            } else {
                index = slotnum;
            }
            res.space = this.spaceid;
            res.offset = this.addressbase + (long)(index * this.alignment);
            slotnum += slotsused;
        }
        if (!this.isLeftJustified()) {
            res.offset += (long)(spaceused - sz);
        }
        return slotnum;
    }

    private void readJoinXML(XmlElement el, CompilerSpec cspec) throws XmlParseException {
        String attrName;
        String attrVal;
        ArrayList<Varnode> pieces = new ArrayList<Varnode>();
        int sizesum = 0;
        int pos = 0;
        while ((attrVal = el.getAttribute(attrName = "piece" + Integer.toString(pos + 1))) != null) {
            Varnode newvn;
            int offpos = attrVal.indexOf(58);
            if (offpos == -1) {
                Register register = cspec.getLanguage().getRegister(attrVal);
                if (register == null) {
                    throw new XmlParseException("Unknown pentry register: " + attrVal);
                }
                newvn = new Varnode(register.getAddress(), register.getBitLength() / 8);
            } else {
                int szpos = attrVal.indexOf(58, offpos + 1);
                if (szpos == -1) {
                    throw new XmlParseException("join address piece attribute is malformed");
                }
                String spcname = attrVal.substring(0, offpos);
                AddressSpace spc = cspec.getAddressSpace(spcname);
                long offset = SpecXmlUtils.decodeLong((String)attrVal.substring(offpos + 1, szpos));
                long sz = SpecXmlUtils.decodeLong((String)attrVal.substring(szpos + 1));
                newvn = new Varnode(spc.getAddress(offset), (int)sz);
            }
            pieces.add(newvn);
            sizesum += newvn.getSize();
            ++pos;
        }
        this.addressbase = 0L;
        this.size = sizesum;
        this.joinrec = new Varnode[pieces.size()];
        pieces.toArray(this.joinrec);
    }

    private void readXMLAddress(XmlPullParser parser, CompilerSpec cspec, int size) throws XmlParseException {
        XmlElement subel = parser.start(new String[0]);
        if (subel.getName().equals("register")) {
            String regName = subel.getAttribute("name");
            if (regName == null) {
                throw new XmlParseException("Missing pentry register name");
            }
            Register register = cspec.getLanguage().getRegister(regName);
            if (register == null) {
                throw new XmlParseException("Unknown pentry register: " + regName);
            }
            int regSize = register.getMinimumByteSize();
            if (size > regSize) {
                throw new XmlParseException("Invalid pentry size specified for " + regSize + "-byte register: " + regName);
            }
            this.spaceid = register.getAddressSpace();
            this.addressbase = register.getOffset();
        } else {
            this.spaceid = cspec.getAddressSpace(subel.getAttribute("space"));
            if (this.spaceid.getType() == 6) {
                this.readJoinXML(subel, cspec);
            } else {
                this.addressbase = SpecXmlUtils.decodeLong((String)subel.getAttribute("offset"));
            }
        }
        parser.end(subel);
    }

    public void restoreXml(XmlPullParser parser, CompilerSpec cspec, boolean normalstack) throws XmlParseException {
        this.flags = 0;
        this.type = 8;
        this.minsize = -1;
        this.size = -1;
        this.alignment = 0;
        this.numslots = 1;
        this.groupsize = 1;
        XmlElement el = parser.start(new String[]{"pentry"});
        for (Map.Entry entry : el.getAttributes().entrySet()) {
            String name = (String)entry.getKey();
            if (name.equals("minsize")) {
                this.minsize = SpecXmlUtils.decodeInt((String)((String)entry.getValue()));
                continue;
            }
            if (name.equals("size")) {
                this.alignment = SpecXmlUtils.decodeInt((String)((String)entry.getValue()));
                continue;
            }
            if (name.equals("align")) {
                this.alignment = SpecXmlUtils.decodeInt((String)((String)entry.getValue()));
                continue;
            }
            if (name.equals("maxsize")) {
                this.size = SpecXmlUtils.decodeInt((String)((String)entry.getValue()));
                continue;
            }
            if (name.equals("metatype")) {
                String meta = (String)entry.getValue();
                if (meta == null || !meta.equals("float")) continue;
                this.type = 3;
                continue;
            }
            if (name.equals("group")) {
                this.group = SpecXmlUtils.decodeInt((String)((String)entry.getValue()));
                continue;
            }
            if (name.equals("groupsize")) {
                this.groupsize = SpecXmlUtils.decodeInt((String)((String)entry.getValue()));
                continue;
            }
            if (name.equals("extension")) {
                this.flags &= 0xFFFFFFD3;
                String value = (String)entry.getValue();
                if (value.equals("sign")) {
                    this.flags |= 8;
                    continue;
                }
                if (value.equals("zero")) {
                    this.flags |= 4;
                    continue;
                }
                if (value.equals("inttype")) {
                    this.flags |= 0x20;
                    continue;
                }
                if (value.equals("float")) {
                    this.flags |= 0x40;
                    continue;
                }
                if (value.equals("none")) continue;
                throw new XmlParseException("Bad extension attribute: " + value);
            }
            throw new XmlParseException("Unknown paramentry attribute: " + name);
        }
        if (this.minsize < 1 || this.size < this.minsize) {
            throw new XmlParseException("paramentry size not specified properly: minsize=" + this.minsize + " maxsize=" + this.size);
        }
        if (this.alignment == this.size) {
            this.alignment = 0;
        }
        this.readXMLAddress(parser, cspec, this.size);
        boolean isbigendian = cspec.getLanguage().isBigEndian();
        if (isbigendian) {
            this.flags |= 0x10;
        }
        if (this.alignment != 0) {
            if (this.addressbase % (long)this.alignment != 0L) {
                throw new XmlParseException("Stack <pentry> address must match alignment");
            }
            this.numslots = this.size / this.alignment;
        }
        if (this.spaceid.isStackSpace() && !cspec.isStackRightJustified() && isbigendian) {
            this.flags |= 1;
        }
        if (!normalstack) {
            this.flags |= 2;
            if (this.alignment != 0 && this.size % this.alignment != 0) {
                throw new XmlParseException("For positive stack growth, <pentry> size must match alignment");
            }
        }
        parser.end(el);
    }

    public static boolean unsignedCompare(long a, long b) {
        return a + Long.MIN_VALUE < b + Long.MIN_VALUE;
    }

    public static int justifiedContainAddress(AddressSpace spc1, long offset1, int sz1, AddressSpace spc2, long offset2, int sz2, boolean forceleft, boolean isBigEndian) {
        if (spc1 != spc2) {
            return -1;
        }
        if (ParamEntry.unsignedCompare(offset2, offset1)) {
            return -1;
        }
        long off1 = offset1 + (long)(sz1 - 1);
        long off2 = offset2 + (long)(sz2 - 1);
        if (ParamEntry.unsignedCompare(off1, off2)) {
            return -1;
        }
        if (isBigEndian && !forceleft) {
            return (int)(off1 - off2);
        }
        return (int)(offset2 - offset1);
    }

    public static int getMetatype(DataType tp) {
        if (tp instanceof TypeDef) {
            tp = ((TypeDef)tp).getBaseDataType();
        }
        if (tp instanceof AbstractFloatDataType) {
            return 3;
        }
        if (tp instanceof Pointer) {
            return 2;
        }
        return 8;
    }
}

