/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.listing;

import ghidra.program.model.address.Address;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeOverride;
import ghidra.program.model.symbol.Reference;
import ghidra.util.Msg;

public class InstructionPcodeOverride
implements PcodeOverride {
    protected Instruction instr;

    public InstructionPcodeOverride(Instruction instr) {
        this.instr = instr;
    }

    @Override
    public Address getFallThroughOverride() {
        Address defaultFallAddr = this.instr.getDefaultFallThrough();
        Address fallAddr = this.instr.getFallThrough();
        if (fallAddr != null && !fallAddr.equals(defaultFallAddr)) {
            return fallAddr;
        }
        return null;
    }

    @Override
    public FlowOverride getFlowOverride() {
        return this.instr.getFlowOverride();
    }

    @Override
    public Address getInstructionStart() {
        return this.instr.getMinAddress();
    }

    @Override
    public Address getPrimaryCallReference() {
        for (Reference ref : this.instr.getReferencesFrom()) {
            if (!ref.isPrimary() || !ref.getReferenceType().isCall()) continue;
            return ref.getToAddress();
        }
        return null;
    }

    @Override
    public boolean hasCallFixup(Address callDestAddr) {
        Program program = this.instr.getProgram();
        Function func = program.getFunctionManager().getFunctionAt(callDestAddr);
        if (func == null) {
            return false;
        }
        return func.getCallFixup() != null;
    }

    @Override
    public InjectPayload getCallFixup(Address callDestAddr) {
        Program program = this.instr.getProgram();
        Function func = program.getFunctionManager().getFunctionAt(callDestAddr);
        if (func == null) {
            return null;
        }
        String fixupName = func.getCallFixup();
        if (fixupName == null) {
            return null;
        }
        InjectPayload fixup = program.getCompilerSpec().getPcodeInjectLibrary().getPayload(1, fixupName, program, null);
        if (fixup == null) {
            Msg.warn((Object)this, (Object)("Undefined call-fixup at " + callDestAddr + ": " + fixupName));
        }
        return fixup;
    }
}

