/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.symbol;

import ghidra.program.model.symbol.DataRefType;
import ghidra.program.model.symbol.FlowType;

public abstract class RefType {
    static final byte __INVALID = -2;
    static final byte __UNKNOWNFLOW = -1;
    static final byte __FALL_THROUGH = 0;
    static final byte __UNCONDITIONAL_JUMP = 1;
    static final byte __CONDITIONAL_JUMP = 2;
    static final byte __UNCONDITIONAL_CALL = 3;
    static final byte __CONDITIONAL_CALL = 4;
    static final byte __TERMINATOR = 5;
    static final byte __COMPUTED_JUMP = 6;
    static final byte __CONDITIONAL_TERMINATOR = 7;
    static final byte __COMPUTED_CALL = 8;
    static final byte __INDIRECTION = 9;
    static final byte __CALL_TERMINATOR = 10;
    static final byte __JUMP_TERMINATOR = 11;
    static final byte __CONDITIONAL_COMPUTED_JUMP = 12;
    static final byte __CONDITIONAL_COMPUTED_CALL = 13;
    static final byte __CONDITIONAL_CALL_TERMINATOR = 14;
    static final byte __COMPUTED_CALL_TERMINATOR = 15;
    static final byte __UNKNOWNDATA = 100;
    static final byte __READ = 101;
    static final byte __WRITE = 102;
    static final byte __READ_WRITE = 103;
    static final byte __READ_IND = 104;
    static final byte __WRITE_IND = 105;
    static final byte __READ_WRITE_IND = 106;
    static final byte __UNKNOWNPARAM = 107;
    @Deprecated
    static final byte __STACK_READ = 110;
    @Deprecated
    static final byte __STACK_WRITE = 111;
    static final byte __EXTERNAL_REF = 113;
    static final byte __UNKNOWNDATA_IND = 114;
    static final byte __DYNAMICDATA = 127;
    public static final FlowType INVALID = new FlowType(-2, "INVALID", true, false, false, false, false, false);
    public static final FlowType FLOW = new FlowType(-1, "FLOW", true, false, false, false, false, false);
    public static final FlowType FALL_THROUGH = new FlowType(0, "FALL_THROUGH", true, false, false, false, false, false);
    public static final FlowType UNCONDITIONAL_JUMP = new FlowType(1, "UNCONDITIONAL_JUMP", false, false, true, false, false, false);
    public static final FlowType CONDITIONAL_JUMP = new FlowType(2, "CONDITIONAL_JUMP", true, false, true, false, false, true);
    public static final FlowType UNCONDITIONAL_CALL = new FlowType(3, "UNCONDITIONAL_CALL", true, true, false, false, false, false);
    public static final FlowType CONDITIONAL_CALL = new FlowType(4, "CONDITIONAL_CALL", true, true, false, false, false, true);
    public static final FlowType TERMINATOR = new FlowType(5, "TERMINATOR", false, false, false, true, false, false);
    public static final FlowType COMPUTED_JUMP = new FlowType(6, "COMPUTED_JUMP", false, false, true, false, true, false);
    public static final FlowType CONDITIONAL_TERMINATOR = new FlowType(7, "CONDITIONAL_TERMINATOR", true, false, false, true, false, true);
    public static final FlowType COMPUTED_CALL = new FlowType(8, "COMPUTED_CALL", true, true, false, false, true, false);
    public static final FlowType CALL_TERMINATOR = new FlowType(10, "CALL_TERMINATOR", false, true, false, true, false, false);
    public static final FlowType COMPUTED_CALL_TERMINATOR = new FlowType(15, "COMPUTED_CALL_TERMINATOR", false, true, false, true, true, false);
    public static final FlowType CONDITIONAL_CALL_TERMINATOR = new FlowType(14, "CONDITIONAL_CALL_TERMINATOR", false, true, false, true, false, true);
    public static final FlowType CONDITIONAL_COMPUTED_CALL = new FlowType(13, "CONDITIONAL_COMPUTED_CALL", true, true, false, false, true, true);
    public static final FlowType CONDITIONAL_COMPUTED_JUMP = new FlowType(12, "CONDITIONAL_COMPUTED_JUMP", true, false, true, false, true, true);
    public static final FlowType JUMP_TERMINATOR = new FlowType(11, "JUMP TERMINATOR", false, false, true, true, false, false);
    public static final FlowType INDIRECTION = new FlowType(9, "INDIRECTION", false, false, false, false, false, false);
    public static final RefType THUNK = new DataRefType(127, "THUNK", 0);
    public static final RefType DATA = new DataRefType(100, "DATA", 0);
    public static final RefType PARAM = new DataRefType(107, "PARAM", 0);
    public static final RefType DATA_IND = new DataRefType(114, "DATA_IND", 4);
    public static final RefType READ = new DataRefType(101, "READ", 1);
    public static final RefType WRITE = new DataRefType(102, "WRITE", 2);
    public static final RefType READ_WRITE = new DataRefType(103, "READ_WRITE", 3);
    public static final RefType READ_IND = new DataRefType(104, "READ_IND", 5);
    public static final RefType WRITE_IND = new DataRefType(105, "WRITE_IND", 6);
    public static final RefType READ_WRITE_IND = new DataRefType(106, "READ_WRITE_IND", 7);
    @Deprecated
    public static final RefType STACK_READ = new DataRefType(110, "STACK_READ", 1);
    @Deprecated
    public static final RefType STACK_WRITE = new DataRefType(111, "STACK_WRITE", 2);
    public static final RefType EXTERNAL_REF = new DataRefType(113, "EXTERNAL", 0);
    private byte type;
    private String name;

    protected RefType(byte type, String name) {
        this.type = type;
        this.name = name;
    }

    public byte getValue() {
        return this.type;
    }

    public boolean isData() {
        return false;
    }

    public boolean isRead() {
        return false;
    }

    public boolean isWrite() {
        return false;
    }

    public boolean isIndirect() {
        return this == INDIRECTION;
    }

    public boolean isFlow() {
        return false;
    }

    public final boolean isFallthrough() {
        return this == FALL_THROUGH;
    }

    public boolean hasFallthrough() {
        return false;
    }

    public boolean isCall() {
        return false;
    }

    public boolean isJump() {
        return false;
    }

    public boolean isUnConditional() {
        return !this.isConditional();
    }

    public boolean isConditional() {
        return false;
    }

    public boolean isComputed() {
        return false;
    }

    public boolean isTerminal() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        RefType other = (RefType)obj;
        return this.type == other.type;
    }

    public int hashCode() {
        return this.type;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }
}

