/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.cmd;

import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;

public class CompoundBackgroundCommand
extends BackgroundCommand {
    private ArrayList<BackgroundCommand> bkgroundCmdList = new ArrayList();
    private ArrayList<Command> cmdList = new ArrayList();

    public CompoundBackgroundCommand(String name, boolean modal, boolean canCancel) {
        super(name, false, canCancel, modal);
    }

    @Override
    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        Command cmd;
        int i;
        for (i = 0; i < this.bkgroundCmdList.size(); ++i) {
            cmd = this.bkgroundCmdList.get(i);
            if (((BackgroundCommand)cmd).applyTo(obj, monitor)) continue;
            this.setStatusMsg(((BackgroundCommand)cmd).getStatusMsg());
            return false;
        }
        for (i = 0; i < this.cmdList.size(); ++i) {
            if (monitor.isCancelled()) {
                this.setStatusMsg("Cancelled");
                return false;
            }
            cmd = this.cmdList.get(i);
            if (cmd.applyTo(obj)) continue;
            this.setStatusMsg(cmd.getStatusMsg());
            return false;
        }
        return true;
    }

    public void add(BackgroundCommand cmd) {
        this.bkgroundCmdList.add(cmd);
    }

    public void add(Command cmd) {
        this.cmdList.add(cmd);
    }

    public int size() {
        return this.bkgroundCmdList.size();
    }

    public boolean isEmpty() {
        return this.bkgroundCmdList.isEmpty();
    }
}

