/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.dialog;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.dialog.ExtensionDetails;
import ghidra.framework.plugintool.dialog.ExtensionDetailsPanel;
import ghidra.framework.plugintool.dialog.ExtensionException;
import ghidra.framework.plugintool.dialog.ExtensionTablePanel;
import ghidra.framework.plugintool.dialog.ExtensionUtils;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.filechooser.GhidraFileChooserModel;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import resources.Icons;
import resources.ResourceManager;

public class ExtensionTableProvider
extends DialogComponentProvider {
    private ExtensionTablePanel extensionTablePanel;
    private boolean requireRestart = false;

    public ExtensionTableProvider(PluginTool tool) {
        super("Install Extensions");
        this.addWorkPanel(this.createMainPanel(tool));
    }

    private JComponent createMainPanel(PluginTool tool) {
        JPanel panel = new JPanel(new BorderLayout());
        this.extensionTablePanel = new ExtensionTablePanel(tool);
        ExtensionDetailsPanel extensionDetailsPanel = new ExtensionDetailsPanel(this.extensionTablePanel);
        JSplitPane splitPane = new JSplitPane(0, this.extensionTablePanel, extensionDetailsPanel);
        splitPane.setResizeWeight(0.75);
        panel.add((Component)splitPane, "Center");
        splitPane.setDividerLocation(0.75);
        this.createAddAction(this.extensionTablePanel);
        this.createRefreshAction(this.extensionTablePanel, extensionDetailsPanel);
        this.addOKButton();
        return panel;
    }

    protected void okCallback() {
        this.close();
    }

    public void close() {
        super.close();
        this.extensionTablePanel.dispose();
    }

    protected void dialogClosed() {
        super.dialogClosed();
        if (this.extensionTablePanel.getTableModel().hasModelChanged() || this.requireRestart) {
            Msg.showInfo((Object)((Object)this), (Component)this.getComponent(), (String)"Extensions Changed!", (Object)"Please restart Ghidra for extension changes to take effect.");
        }
    }

    private void createAddAction(final ExtensionTablePanel panel) {
        ImageIcon addIcon = ResourceManager.loadImage((String)"images/Plus.png");
        DockingAction addAction = new DockingAction("ExtensionTools", "AddExtension"){

            public void actionPerformed(ActionContext context) {
                ResourceFile installDir = Application.getApplicationLayout().getExtensionInstallationDir();
                if (!installDir.canWrite()) {
                    Msg.showError((Object)((Object)this), null, (String)"Permissions Error", (Object)"Cannot install/uninstall extensions: Invalid write permissions on installion directory.\nSee the \"Ghidra Extension Notes\" section of the Ghidra Installation Guide for more information.");
                    return;
                }
                GhidraFileChooser chooser = new GhidraFileChooser((Component)ExtensionTableProvider.this.getComponent());
                chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_AND_DIRECTORIES);
                chooser.setTitle("Select extension");
                chooser.addFileFilter((GhidraFileFilter)new ExtensionFileFilter());
                List files = chooser.getSelectedFiles();
                for (File file : files) {
                    block8: {
                        try {
                            if (!ExtensionUtils.isExtension(new ResourceFile(file))) {
                                Msg.showError((Object)((Object)this), null, (String)"Installation Error", (Object)("Selected file: [" + file.getName() + "] is not a valid Ghidra Extension"));
                            }
                            break block8;
                        }
                        catch (ExtensionException e1) {
                            Msg.showError((Object)((Object)this), null, (String)"Installation Error", (Object)("Error determining if [" + file.getName() + "] is a valid Ghidra Extension"), (Throwable)((Object)e1));
                        }
                        continue;
                    }
                    if (!ExtensionTableProvider.this.hasCorrectVersion(file)) {
                        Msg.showError((Object)((Object)this), null, (String)"Installation Error", (Object)("Extension version for [" + file.getName() + "] is incompatible with Ghidra."));
                        continue;
                    }
                    try {
                        if (!ExtensionUtils.install(new ResourceFile(file))) continue;
                        panel.refreshTable();
                        ExtensionTableProvider.this.requireRestart = true;
                    }
                    catch (Exception e) {
                        Msg.error(null, (Object)("Problem installing extension [" + file.getName() + "]"), (Throwable)e);
                    }
                }
            }
        };
        String group = "extensionTools";
        addAction.setMenuBarData(new MenuData(new String[]{"Add Extension"}, (Icon)addIcon, group));
        addAction.setToolBarData(new ToolBarData((Icon)addIcon, group));
        addAction.setHelpLocation(new HelpLocation("FrontEndPlugin", "ExtensionTools"));
        addAction.setDescription(SystemUtilities.isInDevelopmentMode() ? "Add Extension (disabled in development mode)" : "Add extension");
        addAction.setEnabled(!SystemUtilities.isInDevelopmentMode() && !Application.inSingleJarMode());
        this.addAction((DockingActionIf)addAction);
    }

    private boolean hasCorrectVersion(File file) {
        String ghidraVersion = Application.getApplicationVersion();
        if (file.isFile()) {
            try {
                if (ExtensionUtils.isZip(file)) {
                    Properties props = ExtensionUtils.getPropertiesFromArchive(file);
                    if (props == null) {
                        return false;
                    }
                    ExtensionDetails extension = ExtensionUtils.createExtensionDetailsFromProperties(props);
                    String extVersion = extension.getVersion();
                    if (extVersion != null && extVersion.equals(ghidraVersion)) {
                        return true;
                    }
                }
            }
            catch (ExtensionException props) {
                // empty catch block
            }
            return false;
        }
        List<ResourceFile> propFiles = ExtensionUtils.findExtensionPropertyFiles(new ResourceFile(file), true);
        for (ResourceFile propFile : propFiles) {
            ExtensionDetails extension = ExtensionUtils.createExtensionDetailsFromPropertyFile(propFile);
            String extVersion = extension.getVersion();
            if (extVersion == null || !extVersion.equals(ghidraVersion)) continue;
            return true;
        }
        return false;
    }

    private void createRefreshAction(final ExtensionTablePanel tablePanel, ExtensionDetailsPanel detailsPanel) {
        ImageIcon refreshIcon = Icons.REFRESH_ICON;
        DockingAction refreshAction = new DockingAction("ExtensionTools", "RefreshExtensions"){

            public void actionPerformed(ActionContext context) {
                tablePanel.refreshTable();
            }
        };
        String group = "extensionTools";
        refreshAction.setMenuBarData(new MenuData(new String[]{"Refresh"}, (Icon)refreshIcon, group));
        refreshAction.setToolBarData(new ToolBarData((Icon)refreshIcon, group));
        refreshAction.setHelpLocation(new HelpLocation("FrontEndPlugin", "ExtensionTools"));
        refreshAction.setDescription("Refresh extension list");
        this.addAction((DockingActionIf)refreshAction);
    }

    private class ExtensionFileFilter
    implements GhidraFileFilter {
        private ExtensionFileFilter() {
        }

        public String getDescription() {
            return "Ghidra Extension";
        }

        public boolean accept(File f, GhidraFileChooserModel l_model) {
            try {
                return ExtensionUtils.isExtension(new ResourceFile(f)) || f.isDirectory();
            }
            catch (ExtensionException extensionException) {
                return false;
            }
        }
    }
}

