/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server.security;

import ch.ethz.ssh2.signature.DSAPublicKey;
import ch.ethz.ssh2.signature.DSASHA1Verify;
import ch.ethz.ssh2.signature.DSASignature;
import ch.ethz.ssh2.signature.RSAPublicKey;
import ch.ethz.ssh2.signature.RSASHA1Verify;
import ch.ethz.ssh2.signature.RSASignature;
import ghidra.framework.remote.GhidraPrincipal;
import ghidra.framework.remote.SSHSignatureCallback;
import ghidra.framework.remote.security.SSHKeyManager;
import ghidra.net.ApplicationKeyManagerFactory;
import ghidra.net.ApplicationKeyManagerUtils;
import ghidra.net.SignedToken;
import ghidra.server.UserManager;
import ghidra.server.security.TokenGenerator;
import java.io.File;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;

public class SSHAuthenticationModule {
    private static final long MAX_TOKEN_TIME = 10000L;
    private static final int TOKEN_SIZE = 64;
    private final boolean nameCallbackAllowed;

    public SSHAuthenticationModule(boolean nameCallbackAllowed) {
        this.nameCallbackAllowed = nameCallbackAllowed;
    }

    public Callback[] addAuthenticationCallbacks(Callback[] primaryAuthCallbacks) {
        boolean addNameCallback = this.nameCallbackAllowed;
        if (this.nameCallbackAllowed && primaryAuthCallbacks != null) {
            for (Callback cb : primaryAuthCallbacks) {
                if (!(cb instanceof NameCallback)) continue;
                addNameCallback = false;
                break;
            }
        }
        ArrayList<Callback> list = new ArrayList<Callback>();
        if (primaryAuthCallbacks != null) {
            list.addAll(Arrays.asList(primaryAuthCallbacks));
        }
        if (addNameCallback) {
            list.add(new NameCallback("User ID:"));
        }
        byte[] token = TokenGenerator.getNewToken(64);
        try {
            boolean usingSelfSignedCert = ApplicationKeyManagerFactory.usingGeneratedSelfSignedCertificate();
            SignedToken signedToken = ApplicationKeyManagerUtils.getSignedToken((Principal[])(usingSelfSignedCert ? null : ApplicationKeyManagerUtils.getTrustedIssuers()), (byte[])token);
            list.add((Callback)new SSHSignatureCallback(token, signedToken.signature));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to generate signed token", e);
        }
        return list.toArray(new Callback[list.size()]);
    }

    public boolean hasSignedSSHCallback(Callback[] callbacks) {
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                if (!(callbacks[i] instanceof SSHSignatureCallback)) continue;
                SSHSignatureCallback sshCb = (SSHSignatureCallback)callbacks[i];
                return sshCb.isSigned();
            }
        }
        return false;
    }

    public String authenticate(UserManager userMgr, Subject subject, Callback[] callbacks) throws LoginException {
        GhidraPrincipal user = GhidraPrincipal.getGhidraPrincipal((Subject)subject);
        if (user == null) {
            throw new FailedLoginException("GhidraPrincipal required");
        }
        String username = user.getName();
        NameCallback nameCb = null;
        SSHSignatureCallback sshCb = null;
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    nameCb = (NameCallback)callbacks[i];
                }
                if (!(callbacks[i] instanceof SSHSignatureCallback)) continue;
                sshCb = (SSHSignatureCallback)callbacks[i];
            }
        }
        if (this.nameCallbackAllowed && nameCb != null) {
            username = nameCb.getName();
        }
        if (username == null || username.length() == 0) {
            throw new FailedLoginException("User ID must be specified");
        }
        if (!userMgr.isValidUser(username)) {
            throw new FailedLoginException("Unknown user: " + username);
        }
        if (sshCb == null) {
            throw new FailedLoginException("SSH Signature callback not found for user: " + username);
        }
        File sshPublicKeyFile = userMgr.getSSHPubKeyFile(username);
        if (sshPublicKeyFile == null) {
            throw new FailedLoginException("SSH public key file not found for user: " + username);
        }
        byte[] sigBytes = sshCb.getSignature();
        if (sigBytes == null) {
            throw new FailedLoginException("SSH Signature missing");
        }
        byte[] token = sshCb.getToken();
        if (!TokenGenerator.isRecentToken(token, 10000L)) {
            throw new FailedLoginException("Stale SSH Signature callback");
        }
        boolean isValid = false;
        try {
            boolean usingSelfSignedCert = ApplicationKeyManagerFactory.usingGeneratedSelfSignedCertificate();
            isValid = ApplicationKeyManagerUtils.isMySignature((Principal[])(usingSelfSignedCert ? null : ApplicationKeyManagerUtils.getTrustedIssuers()), (byte[])token, (byte[])sshCb.getServerSignature());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to verify signed token", e);
        }
        if (!isValid) {
            throw new FailedLoginException("Invalid SSH Signature callback");
        }
        try {
            Object sshPublicKey = SSHKeyManager.getSSHPublicKey((File)sshPublicKeyFile);
            if (sshPublicKey instanceof RSAPublicKey) {
                RSAPublicKey key = (RSAPublicKey)sshPublicKey;
                RSASignature rsaSignature = RSASHA1Verify.decodeSSHRSASignature((byte[])sigBytes);
                if (!RSASHA1Verify.verifySignature((byte[])token, (RSASignature)rsaSignature, (RSAPublicKey)key)) {
                    throw new FailedLoginException("Incorrect signature");
                }
            } else if (sshPublicKey instanceof DSAPublicKey) {
                DSAPublicKey key = (DSAPublicKey)sshPublicKey;
                DSASignature dsaSignature = DSASHA1Verify.decodeSSHDSASignature((byte[])sigBytes);
                if (!DSASHA1Verify.verifySignature((byte[])token, (DSASignature)dsaSignature, (DSAPublicKey)key)) {
                    throw new FailedLoginException("Incorrect signature");
                }
            }
        }
        catch (LoginException e) {
            throw e;
        }
        catch (Throwable t) {
            String msg = t.getMessage();
            if (msg == null) {
                msg = t.toString();
            }
            throw new FailedLoginException(msg);
        }
        return username;
    }

    public boolean allowsNameCallback() {
        return this.nameCallbackAllowed;
    }
}

