/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import generic.cache.BasicFactory;
import generic.cache.CachingPool;
import generic.cache.CountingBasicFactory;
import generic.concurrent.ConcurrentGraphQ;
import generic.concurrent.GThreadPool;
import generic.concurrent.QRunnable;
import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.HighLocal;
import ghidra.program.model.pcode.HighParamID;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.util.AcyclicCallGraphBuilder;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.graph.DependencyGraph;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;

public class DecompilerParameterIdCmd
extends BackgroundCommand {
    private AddressSet entryPoints = new AddressSet();
    private Program program;
    private SourceType sourceTypeClearLevel;
    private boolean commitDataTypes;
    private boolean commitVoidReturn;
    private int decompilerTimeoutSecs;

    public DecompilerParameterIdCmd(AddressSetView entries, SourceType sourceTypeClearLevel, boolean commitDataTypes, boolean commitVoidReturn, int decompilerTimeoutSecs) {
        super("Create Function Stack Variables", true, true, false);
        this.entryPoints.add(entries);
        this.sourceTypeClearLevel = sourceTypeClearLevel;
        this.commitDataTypes = commitDataTypes;
        this.commitVoidReturn = commitVoidReturn;
        this.decompilerTimeoutSecs = decompilerTimeoutSecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        this.program = (Program)obj;
        CachingPool decompilerPool = new CachingPool((BasicFactory)new DecompilerFactory());
        ParallelDecompileRunnable runnable = new ParallelDecompileRunnable((CachingPool<DecompInterface>)decompilerPool);
        ConcurrentGraphQ queue = null;
        try {
            monitor.setMessage("Analyzing Call Hierarchy...");
            AcyclicCallGraphBuilder builder = new AcyclicCallGraphBuilder(this.program, (AddressSetView)this.entryPoints, true);
            DependencyGraph graph = builder.getDependencyGraph(monitor);
            if (graph.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            GThreadPool pool = AutoAnalysisManager.getSharedAnalsysThreadPool();
            queue = new ConcurrentGraphQ((QRunnable)runnable, graph, pool, monitor);
            this.resetFunctionSourceTypes(graph.getValues());
            monitor.setMessage("Analyzing...");
            queue.execute();
        }
        catch (CancelledException builder) {
        }
        catch (Exception e) {
            this.setStatusMsg(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (queue != null) {
                queue.dispose();
            }
            decompilerPool.dispose();
        }
        return true;
    }

    private boolean funcIsExternalGlue(Function func) {
        String blockName = this.program.getMemory().getBlock(func.getEntryPoint()).getName();
        return blockName.equals("EXTERNAL") || blockName.equals(".plt") || blockName.equals("__stub_helper");
    }

    private void resetFunctionSourceTypes(Set<Address> set) {
        FunctionManager functionManager = this.program.getFunctionManager();
        for (Address entryPoint : set) {
            Function func = functionManager.getFunctionAt(entryPoint);
            try {
                if (func.isExternal() || this.funcIsExternalGlue(func)) continue;
                Parameter retParam = func.getReturn();
                if (retParam != null && !retParam.getSource().isHigherPriorityThan(this.sourceTypeClearLevel)) {
                    func.setReturn(retParam.getDataType(), retParam.getVariableStorage(), SourceType.DEFAULT);
                }
                if (func.getSignatureSource().isHigherPriorityThan(this.sourceTypeClearLevel)) continue;
                func.setSignatureSource(SourceType.DEFAULT);
            }
            catch (InvalidInputException e) {
                Msg.warn((Object)((Object)this), (Object)("Error changing signature SourceType (should not since Input is the same) on--" + func.getName()), (Throwable)e);
            }
        }
    }

    private void analyzeFunction(DecompInterface decomplib, Function f, TaskMonitor monitor) {
        block16: {
            if (f == null || f.isThunk() || f.getSignatureSource() != SourceType.DEFAULT) {
                return;
            }
            if (f.isExternal()) {
                return;
            }
            if (this.funcIsExternalGlue(f)) {
                return;
            }
            try {
                DecompileResults decompRes = null;
                if (monitor.isCancelled()) {
                    return;
                }
                decompRes = decomplib.decompileFunction(f, this.decompilerTimeoutSecs, monitor);
                this.setStatusMsg(decompRes.getErrorMessage());
                if (monitor.isCancelled()) {
                    return;
                }
                boolean goodInfo = false;
                if (decompRes.decompileCompleted()) {
                    if (this.hasInconsistentResults(decompRes)) {
                        this.setStatusMsg("Error function " + decompRes.getFunction() + " has inconsistent parameters");
                        return;
                    }
                    if (this.commitDataTypes) {
                        DataType returnType;
                        HighFunction hfunc = decompRes.getHighFunction();
                        if (hfunc == null) {
                            return;
                        }
                        HighFunctionDBUtil.commitParamsToDatabase((HighFunction)hfunc, (boolean)true, (SourceType)SourceType.ANALYSIS);
                        boolean commitReturn = true;
                        if (!this.commitVoidReturn && (returnType = hfunc.getFunctionPrototype().getReturnType()) instanceof VoidDataType) {
                            commitReturn = false;
                        }
                        if (commitReturn) {
                            HighFunctionDBUtil.commitReturnToDatabase((HighFunction)hfunc, (SourceType)SourceType.ANALYSIS);
                        }
                        goodInfo = true;
                    } else {
                        HighParamID hparamid = decompRes.getHighParamID();
                        hparamid.storeParametersToDatabase(this.commitDataTypes, SourceType.ANALYSIS);
                        hparamid.storeReturnToDatabase(this.commitDataTypes, SourceType.ANALYSIS);
                        goodInfo = true;
                    }
                    this.checkModelNameConsistency(decompRes.getFunction());
                }
                if (!monitor.isCancelled() && !goodInfo) {
                    Object msg = this.getStatusMsg();
                    msg = msg == null ? "" : ": " + (String)msg;
                    Msg.debug((Object)((Object)this), (Object)("  Failed to decompile function: " + f.getName() + (String)msg));
                }
            }
            catch (Exception e) {
                if (monitor.isCancelled()) break block16;
                Object errMsg = e.getMessage();
                if (errMsg == null) {
                    errMsg = "Error decompiling function: " + e;
                }
                this.setStatusMsg((String)errMsg);
            }
        }
    }

    private boolean hasInconsistentResults(DecompileResults decompRes) {
        HighFunction hfunc = decompRes.getHighFunction();
        if (hfunc == null) {
            return false;
        }
        Iterator symIter = hfunc.getLocalSymbolMap().getSymbols();
        while (symIter.hasNext()) {
            HighSymbol sym = (HighSymbol)symIter.next();
            HighVariable highVar = sym.getHighVariable();
            if (!(highVar instanceof HighLocal) || !sym.getName().startsWith("in_") || sym.getName().equals("in_FS_OFFSET") || !sym.getHighVariable().getStorage().isRegisterStorage()) continue;
            Function func = hfunc.getFunction();
            if (func != null) {
                Address entryPoint = func.getEntryPoint();
                BookmarkManager bookmarkManager = hfunc.getFunction().getProgram().getBookmarkManager();
                bookmarkManager.setBookmark(entryPoint, "Warning", "DecompilerParamID", "Problem recovering parameters in function " + func.getName() + " at " + func.getEntryPoint() + " unknown input variable " + sym.getName());
            }
            return true;
        }
        return false;
    }

    private void checkModelNameConsistency(Function func) {
        int paramCount = func.getParameterCount();
        String modelName = func.getCallingConventionName();
        if (func.getStackPurgeSize() == 0 && paramCount > 0 && modelName.equals("__stdcall")) {
            try {
                func.setCallingConvention("__cdecl");
            }
            catch (InvalidInputException e) {
                this.setStatusMsg("Invalid Calling Convention __cdecl : " + e);
            }
        }
    }

    private class ParallelDecompileRunnable
    implements QRunnable<Address> {
        private CachingPool<DecompInterface> pool;

        ParallelDecompileRunnable(CachingPool<DecompInterface> decompilerPool) {
            this.pool = decompilerPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Address address, TaskMonitor monitor) throws CancelledException, Exception {
            DecompInterface decompiler = (DecompInterface)this.pool.get();
            try {
                Function function = DecompilerParameterIdCmd.this.program.getFunctionManager().getFunctionAt(address);
                this.doWork(function, decompiler, monitor);
            }
            finally {
                this.pool.release((Object)decompiler);
                monitor.incrementProgress(1L);
            }
        }

        private void doWork(Function function, DecompInterface decompiler, TaskMonitor monitor) throws CancelledException {
            monitor.checkCanceled();
            monitor.setMessage("Decompile " + function.getName());
            DecompilerParameterIdCmd.this.analyzeFunction(decompiler, function, monitor);
        }
    }

    private class DecompilerFactory
    extends CountingBasicFactory<DecompInterface> {
        private DecompilerFactory() {
        }

        public DecompInterface doCreate(int itemNumber) throws IOException {
            DecompInterface decompiler = new DecompInterface();
            decompiler.toggleCCode(false);
            if (DecompilerParameterIdCmd.this.commitDataTypes) {
                decompiler.toggleSyntaxTree(false);
                decompiler.setSimplificationStyle("decompile");
            } else {
                decompiler.toggleParamMeasures(true);
                decompiler.toggleSyntaxTree(false);
                decompiler.setSimplificationStyle("paramid");
            }
            DecompileOptions opts = new DecompileOptions();
            opts.setEliminateUnreachable(false);
            opts.grabFromProgram(DecompilerParameterIdCmd.this.program);
            decompiler.setOptions(opts);
            decompiler.openProgram(DecompilerParameterIdCmd.this.program);
            return decompiler;
        }

        public void doDispose(DecompInterface decompiler) {
            decompiler.dispose();
        }
    }
}

