/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcodeInject;

import ghidra.app.plugin.processors.sleigh.PcodeEmit;
import ghidra.app.util.pcodeInject.JavaComputationalCategory;
import ghidra.javaclass.format.ClassFileAnalysisState;
import ghidra.javaclass.format.ClassFileJava;
import ghidra.javaclass.format.DescriptorDecoder;
import ghidra.javaclass.format.MethodInfoJava;
import ghidra.javaclass.format.constantpool.ConstantPoolUtf8Info;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.InjectContext;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;

public class InjectPayloadJavaParameters
implements InjectPayload {
    private InjectPayload.InjectParameter[] noParams = new InjectPayload.InjectParameter[0];
    private boolean analysisStateRecoverable = true;

    public String getName() {
        return "javaparameters";
    }

    public int getType() {
        return 3;
    }

    public String getSource() {
        return "javaparameters";
    }

    public int getParamShift() {
        return 0;
    }

    public InjectPayload.InjectParameter[] getInput() {
        return this.noParams;
    }

    public InjectPayload.InjectParameter[] getOutput() {
        return this.noParams;
    }

    public void inject(InjectContext context, PcodeEmit emit) {
    }

    public PcodeOp[] getPcode(Program program, InjectContext con) {
        ClassFileAnalysisState analysisState;
        if (!this.analysisStateRecoverable) {
            return new PcodeOp[0];
        }
        try {
            analysisState = ClassFileAnalysisState.getState(program);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)e.getMessage(), (Throwable)e);
            this.analysisStateRecoverable = false;
            return new PcodeOp[0];
        }
        ClassFileJava classFile = analysisState.getClassFile();
        MethodInfoJava methodInfo = analysisState.getMethodInfo(con.baseAddr);
        if (methodInfo == null) {
            return new PcodeOp[0];
        }
        short descriptorIndex = methodInfo.getDescriptorIndex();
        ConstantPoolUtf8Info descriptorInfo = (ConstantPoolUtf8Info)classFile.getConstantPool()[descriptorIndex];
        String descriptor = descriptorInfo.getString();
        ArrayList<JavaComputationalCategory> paramCategories = new ArrayList<JavaComputationalCategory>();
        if (!methodInfo.isStatic()) {
            paramCategories.add(JavaComputationalCategory.CAT_1);
        }
        paramCategories.addAll(DescriptorDecoder.getParameterCategories(descriptor));
        int numOps = paramCategories.size();
        if (paramCategories.size() == 0) {
            return new PcodeOp[0];
        }
        AddressSpace paramSpace = program.getAddressFactory().getAddressSpace("parameterSpace");
        int paramSpaceID = paramSpace.getBaseSpaceID();
        AddressSpace lva = program.getAddressFactory().getAddressSpace("localVariableArray");
        int lvaID = lva.getBaseSpaceID();
        AddressSpace constant = program.getAddressFactory().getConstantSpace();
        PcodeOp[] resOps = new PcodeOp[1 + 3 * numOps];
        int seqNum = 0;
        Varnode zero = new Varnode(constant.getAddress(0L), 4);
        Varnode four = new Varnode(constant.getAddress(4L), 4);
        Varnode eight = new Varnode(constant.getAddress(8L), 4);
        Address LVAregAddress = program.getRegister("LVA").getAddress();
        Varnode LVA = new Varnode(LVAregAddress, 4);
        PcodeOp copy = new PcodeOp(con.baseAddr, seqNum, 1);
        copy.setInput(zero, 0);
        copy.setOutput(LVA);
        resOps[seqNum++] = copy;
        Address temp4Address = analysisState.getNextUniqueAddress();
        Varnode temp4 = new Varnode(temp4Address, 4);
        Address temp8Address = analysisState.getNextUniqueAddress();
        Varnode temp8 = new Varnode(temp8Address, 8);
        Varnode tempLocation = null;
        Varnode increment = null;
        for (JavaComputationalCategory cat : paramCategories) {
            if (cat.equals((Object)JavaComputationalCategory.CAT_1)) {
                tempLocation = temp4;
                increment = four;
            } else {
                tempLocation = temp8;
                increment = eight;
            }
            PcodeOp load = new PcodeOp(con.baseAddr, seqNum, 2);
            load.setInput(new Varnode(constant.getAddress((long)paramSpaceID), 4), 0);
            load.setInput(LVA, 1);
            load.setOutput(tempLocation);
            resOps[seqNum++] = load;
            PcodeOp store = new PcodeOp(con.baseAddr, seqNum, 3);
            store.setInput(new Varnode(constant.getAddress((long)lvaID), 4), 0);
            store.setInput(LVA, 1);
            store.setInput(tempLocation, 2);
            resOps[seqNum++] = store;
            PcodeOp add = new PcodeOp(con.baseAddr, seqNum, 19);
            add.setInput(LVA, 0);
            add.setInput(increment, 1);
            add.setOutput(LVA);
            resOps[seqNum++] = add;
        }
        return resOps;
    }

    public boolean isFallThru() {
        return true;
    }
}

