/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ExceptionsAttribute
extends AbstractAttributeInfo {
    private short numberOfExceptions;
    private short[] exceptionIndexTable;

    public ExceptionsAttribute(BinaryReader reader) throws IOException {
        super(reader);
        this.numberOfExceptions = reader.readNextShort();
        this.exceptionIndexTable = reader.readNextShortArray((int)this.numberOfExceptions);
    }

    public short getNumberOfExceptions() {
        return this.numberOfExceptions;
    }

    public short[] getExceptionIndexTable() {
        return this.exceptionIndexTable;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = this.getBaseStructure("Exceptions_attribute");
        structure.add(WORD, "number_of_exceptions", null);
        if (this.exceptionIndexTable.length > 0) {
            ArrayDataType array = new ArrayDataType(WORD, this.exceptionIndexTable.length, WORD.getLength());
            structure.add((DataType)array, "exception_index_table", null);
        }
        return structure;
    }
}

