/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.http;

import com.dropbox.core.util.IOUtil;
import com.dropbox.core.util.LangUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLConfig {
    private static final SSLSocketFactory sslSocketFactory = SSLConfig.createSSLSocketFactory();
    private static final String[] protocolListTLS_v1_2 = new String[]{"TLSv1.2"};
    private static final String[] protocolListTLS_v1_0 = new String[]{"TLSv1.0"};
    private static final String[] protocolListTLS_v1 = new String[]{"TLSv1"};
    private static HashSet<String> allowedCipherSuites = new HashSet<String>(Arrays.asList("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_RC4_128_SHA", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA", "ECDHE-RSA-AES256-GCM-SHA384", "ECDHE-RSA-AES256-SHA384", "ECDHE-RSA-AES256-SHA", "ECDHE-RSA-AES128-GCM-SHA256", "ECDHE-RSA-AES128-SHA256", "ECDHE-RSA-AES128-SHA", "ECDHE-RSA-RC4-SHA", "DHE-RSA-AES256-GCM-SHA384", "DHE-RSA-AES256-SHA256", "DHE-RSA-AES256-SHA", "DHE-RSA-AES128-GCM-SHA256", "DHE-RSA-AES128-SHA256", "DHE-RSA-AES128-SHA", "AES256-GCM-SHA384", "AES256-SHA256", "AES256-SHA", "AES128-GCM-SHA256", "AES128-SHA256", "AES128-SHA"));
    private static CipherSuiteFilterationResults cachedCipherSuiteFilterationResults;
    private static final String RootCertsResourceName = "trusted-certs.jks";

    public static void apply(HttpsURLConnection conn) throws SSLException {
        conn.setSSLSocketFactory(sslSocketFactory);
    }

    public static SSLSocketFactory getSSLSocketFactory() {
        return sslSocketFactory;
    }

    private static void limitProtocolsAndCiphers(SSLSocket socket) throws SSLException {
        block5: {
            for (String protocol : socket.getSupportedProtocols()) {
                if (protocol.equals("TLSv1.2")) {
                    socket.setEnabledProtocols(protocolListTLS_v1_2);
                } else if (protocol.equals("TLSv1.0")) {
                    socket.setEnabledProtocols(protocolListTLS_v1_0);
                } else {
                    if (!protocol.equals("TLSv1")) continue;
                    socket.setEnabledProtocols(protocolListTLS_v1);
                }
                break block5;
            }
            throw new SSLException("Socket doesn't support protocols \"TLSv1.2\", \"TLSv1.0\" or \"TLSv1\".");
        }
        socket.setEnabledCipherSuites(SSLConfig.getFilteredCipherSuites(socket.getSupportedCipherSuites()));
    }

    private static String[] getFilteredCipherSuites(String[] supportedCipherSuites) {
        CipherSuiteFilterationResults cached = cachedCipherSuiteFilterationResults;
        if (cached != null && Arrays.equals(cached.supported, supportedCipherSuites)) {
            return cached.enabled;
        }
        ArrayList<String> enabled = new ArrayList<String>(allowedCipherSuites.size());
        for (String supported : supportedCipherSuites) {
            if (!allowedCipherSuites.contains(supported)) continue;
            enabled.add(supported);
        }
        String[] filteredArray = enabled.toArray(new String[enabled.size()]);
        cachedCipherSuiteFilterationResults = new CipherSuiteFilterationResults(supportedCipherSuites, filteredArray);
        return filteredArray;
    }

    private static SSLSocketFactory createSSLSocketFactory() {
        KeyStore trustedCertKeyStore = SSLConfig.loadKeyStore(RootCertsResourceName);
        TrustManager[] trustManagers = SSLConfig.createTrustManagers(trustedCertKeyStore);
        SSLContext sslContext = SSLConfig.createSSLContext(trustManagers);
        return new SSLSocketFactoryWrapper(sslContext.getSocketFactory());
    }

    private static SSLContext createSSLContext(TrustManager[] trustManagers) {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException ex) {
            throw LangUtil.mkAssert("Couldn't create SSLContext", ex);
        }
        try {
            sslContext.init(null, trustManagers, null);
        }
        catch (KeyManagementException ex) {
            throw LangUtil.mkAssert("Couldn't initialize SSLContext", ex);
        }
        return sslContext;
    }

    private static TrustManager[] createTrustManagers(KeyStore trustedCertKeyStore) {
        TrustManagerFactory tmf;
        try {
            tmf = TrustManagerFactory.getInstance("X509");
        }
        catch (NoSuchAlgorithmException ex) {
            throw LangUtil.mkAssert("Unable to create TrustManagerFactory", ex);
        }
        try {
            tmf.init(trustedCertKeyStore);
        }
        catch (KeyStoreException ex) {
            throw LangUtil.mkAssert("Unable to initialize TrustManagerFactory with key store", ex);
        }
        return tmf.getTrustManagers();
    }

    private static KeyStore loadKeyStore(String jksFileResourceName) {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance("JKS");
        }
        catch (KeyStoreException ex) {
            throw LangUtil.mkAssert("Couldn't initialize JKS key store", ex);
        }
        InputStream in = SSLConfig.class.getResourceAsStream(jksFileResourceName);
        if (in == null) {
            throw new AssertionError((Object)("Couldn't find resource \"" + jksFileResourceName + "\""));
        }
        try {
            keyStore.load(in, null);
        }
        catch (CertificateException ex) {
            throw LangUtil.mkAssert("Error loading from \"" + jksFileResourceName + "\"", ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw LangUtil.mkAssert("Error loading from \"" + jksFileResourceName + "\"", ex);
        }
        catch (IOException ex) {
            throw LangUtil.mkAssert("Error loading from \"" + jksFileResourceName + "\"", ex);
        }
        finally {
            IOUtil.closeInput(in);
        }
        return keyStore;
    }

    private static final class SSLSocketFactoryWrapper
    extends SSLSocketFactory {
        private final SSLSocketFactory mBase;

        public SSLSocketFactoryWrapper(SSLSocketFactory base) {
            this.mBase = base;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.mBase.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.mBase.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            Socket socket = this.mBase.createSocket(host, port);
            SSLConfig.limitProtocolsAndCiphers((SSLSocket)socket);
            return socket;
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            Socket socket = this.mBase.createSocket(host, port);
            SSLConfig.limitProtocolsAndCiphers((SSLSocket)socket);
            return socket;
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            Socket socket = this.mBase.createSocket(host, port, localHost, localPort);
            SSLConfig.limitProtocolsAndCiphers((SSLSocket)socket);
            return socket;
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            Socket socket = this.mBase.createSocket(address, port, localAddress, localPort);
            SSLConfig.limitProtocolsAndCiphers((SSLSocket)socket);
            return socket;
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            Socket socket = this.mBase.createSocket(s, host, port, autoClose);
            SSLConfig.limitProtocolsAndCiphers((SSLSocket)socket);
            return socket;
        }
    }

    private static final class CipherSuiteFilterationResults {
        public final String[] supported;
        public final String[] enabled;

        private CipherSuiteFilterationResults(String[] supported, String[] enabled) {
            this.supported = supported;
            this.enabled = enabled;
        }
    }
}

