/* ###
 * IP: GHIDRA
 * REVIEWED: YES
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.javaclass.format.attributes;

public final class AttributesConstants {

	public final static String ConstantValue = "ConstantValue";
	public final static String Code = "Code";
	public final static String StackMapTable = "StackMapTable";
	public final static String Exceptions = "Exceptions";
	public final static String InnerClasses = "InnerClasses";
	public final static String EnclosingMethod = "EnclosingMethod";
	public final static String Synthetic = "Synthetic";
	public final static String Signature = "Signature";
	public final static String SourceFile = "SourceFile";
	public final static String SourceDebugExtension = "SourceDebugExtension";
	public final static String LineNumberTable = "LineNumberTable";
	public final static String LocalVariableTable = "LocalVariableTable";
	public final static String LocalVariableTypeTable = "LocalVariableTypeTable";
	public final static String Deprecated = "Deprecated";
	public final static String RuntimeVisibleAnnotations = "RuntimeVisibleAnnotations";
	public final static String RuntimeInvisibleAnnotations = "RuntimeInvisibleAnnotations";
	public final static String RuntimeVisibleParameterAnnotations = "RuntimeVisibleParameterAnnotations";
	public final static String RuntimeInvisibleParameterAnnotations = "RuntimeInvisibleParameterAnnotations";
	public final static String AnnotationDefault = "AnnotationDefault";
	public final static String BootstrapMethods = "BootstrapMethods";

}
