"""Generated message classes for iamassist version v1alpha2.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'iamassist'


class GoogleIamAssistV1alpha2AccessTuple(_messages.Message):
  r"""AccessTuple defines information required for checking an access attempt.
  In other words, this is the tuple given to `CheckAccess`.

  Fields:
    conditionContext: OPTIONAL: The Cloud IAM condition context under which
      defines the kind of access being explained. ExplainAccess would explain
      if and why the principal has the queried permission on the resource
      specified in full_resource_name under this context
    fullResourceName: REQUIRED: A full resource name according to http://go
      /resource-names. This is the full resource name of the resource that
      access is checked against.
    permission: REQUIRED: The Cloud IAM permission under which defines the
      kind of access being explained. Example: "resourcemanager.projects.get"
      would explain if and why the principal has the
      resourcemanager.projects.get permission on the resource specified in
      full_resource_name declared in this structure. See
      https://cloud.google.com/iam/docs/testing-permissions
    principal: REQUIRED: The principal on behalf of who the access is
      explained for. The format is the one of the principal's email addresses
      associated with its gaia account. It must be an account that can appear
      as an actor. For example groups are not supported. Currently, service
      accounts are partially supported.
  """

  conditionContext = _messages.MessageField('GoogleRpcContextAttributeContext', 1)
  fullResourceName = _messages.StringField(2)
  permission = _messages.StringField(3)
  principal = _messages.StringField(4)


class GoogleIamAssistV1alpha2BindingExplanation(_messages.Message):
  r"""Binding Explanation.

  Enums:
    AccessValueValuesEnum: REQUIRED: Access decision for this binding.
    RolePermissionValueValuesEnum: Whether the role of this binding contains
      the checked permission

  Messages:
    MembershipsValue: For each member in the binding, provides information
      whether or not the principal from the request is included in the member
      by which the CheckResult is keyed. May indicate that the caller has no
      access to this information.

  Fields:
    access: REQUIRED: Access decision for this binding.
    condition: The condition which needs to be satisfied in order for this
      binding to grant the role to the principal.
    conditionExplanation: Condition evaluation state for this binding.
    memberships: For each member in the binding, provides information whether
      or not the principal from the request is included in the member by which
      the CheckResult is keyed. May indicate that the caller has no access to
      this information.
    role: The role that this binding grants in the policy.
    rolePermission: Whether the role of this binding contains the checked
      permission
  """

  class AccessValueValuesEnum(_messages.Enum):
    r"""REQUIRED: Access decision for this binding.

    Values:
      ACCESS_STATE_UNSPECIFIED: Reserved
      GRANTED: The access is granted due to one or multiple bindings found.
      NOT_GRANTED: The access is not granted by the policy.
      UNKNOWN_CONDITIONAL: At least one binding was found but it is
        conditional. undecided, undetermined ,uncertain, open, tentative,
        contingent
      UNKNOWN_INFO_DENIED: Indicating that lack of access to the underlying
        information causes the result to be undetermined. This can be due to
        1) The caller has no access to the policy. In this case
        ExplainedPolicy    will have not policy set.  2) The caller has no
        access to some of the items referenced in the policy.    In this case
        the policy in ExplainedPolicy will be set but the    explanations
        field will contain at least one inconclusive element.
    """
    ACCESS_STATE_UNSPECIFIED = 0
    GRANTED = 1
    NOT_GRANTED = 2
    UNKNOWN_CONDITIONAL = 3
    UNKNOWN_INFO_DENIED = 4

  class RolePermissionValueValuesEnum(_messages.Enum):
    r"""Whether the role of this binding contains the checked permission

    Values:
      ROLE_PERMISSION_UNSPECIFIED: Reserved
      ROLE_PERMISSION_INCLUDED: Permission is included in the role.
      ROLE_PERMISSION_NOT_INCLUDED: Permission is included in the role.
      ROLE_PERMISSION_UNKNOWN_INFO_DENIED: Calling principal has no access to
        the role permission relation.
    """
    ROLE_PERMISSION_UNSPECIFIED = 0
    ROLE_PERMISSION_INCLUDED = 1
    ROLE_PERMISSION_NOT_INCLUDED = 2
    ROLE_PERMISSION_UNKNOWN_INFO_DENIED = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MembershipsValue(_messages.Message):
    r"""For each member in the binding, provides information whether or not
    the principal from the request is included in the member by which the
    CheckResult is keyed. May indicate that the caller has no access to this
    information.

    Messages:
      AdditionalProperty: An additional property for a MembershipsValue
        object.

    Fields:
      additionalProperties: Additional properties of type MembershipsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MembershipsValue object.

      Enums:
        ValueValueValuesEnum:

      Fields:
        key: Name of the additional property.
        value: A ValueValueValuesEnum attribute.
      """

      class ValueValueValuesEnum(_messages.Enum):
        r"""ValueValueValuesEnum enum type.

        Values:
          MEMBERSHIP_UNSPECIFIED: <no description>
          MEMBERSHIP_INCLUDED: <no description>
          MEMBERSHIP_NOT_INCLUDED: <no description>
          MEMBERSHIP_UNKNOWN_INFO_DENIED: <no description>
          MEMBERSHIP_UNKNOWN_UNSUPPORTED: <no description>
        """
        MEMBERSHIP_UNSPECIFIED = 0
        MEMBERSHIP_INCLUDED = 1
        MEMBERSHIP_NOT_INCLUDED = 2
        MEMBERSHIP_UNKNOWN_INFO_DENIED = 3
        MEMBERSHIP_UNKNOWN_UNSUPPORTED = 4

      key = _messages.StringField(1)
      value = _messages.EnumField('ValueValueValuesEnum', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  access = _messages.EnumField('AccessValueValuesEnum', 1)
  condition = _messages.MessageField('GoogleTypeExpr', 2)
  conditionExplanation = _messages.MessageField('GoogleIamAssistV1alpha2ConditionExplanation', 3)
  memberships = _messages.MessageField('MembershipsValue', 4)
  role = _messages.StringField(5)
  rolePermission = _messages.EnumField('RolePermissionValueValuesEnum', 6)


class GoogleIamAssistV1alpha2CheckAccessRequest(_messages.Message):
  r"""CheckAccessRequest is the request for CheckAccess

  Messages:
    PolicyOverlayValue: Mapping from full resource names to simulated
      policies.

  Fields:
    accessTuple: Required. The tuple to check access for.
    policyOverlay: Mapping from full resource names to simulated policies.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PolicyOverlayValue(_messages.Message):
    r"""Mapping from full resource names to simulated policies.

    Messages:
      AdditionalProperty: An additional property for a PolicyOverlayValue
        object.

    Fields:
      additionalProperties: Additional properties of type PolicyOverlayValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PolicyOverlayValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleIamV1Policy attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleIamV1Policy', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  accessTuple = _messages.MessageField('GoogleIamAssistV1alpha2AccessTuple', 1)
  policyOverlay = _messages.MessageField('PolicyOverlayValue', 2)


class GoogleIamAssistV1alpha2CheckAccessResponse(_messages.Message):
  r"""CheckAccessResponse is the response from CheckAccess.

  Enums:
    AccessValueValuesEnum: Reflects whether the probed access was granted,
      denied or ultimately could not be decided from the caller's point of
      view.

  Fields:
    access: Reflects whether the probed access was granted, denied or
      ultimately could not be decided from the caller's point of view.
  """

  class AccessValueValuesEnum(_messages.Enum):
    r"""Reflects whether the probed access was granted, denied or ultimately
    could not be decided from the caller's point of view.

    Values:
      ACCESS_STATE_UNSPECIFIED: Reserved
      GRANTED: The access is granted due to one or multiple bindings found.
      NOT_GRANTED: The access is not granted by the policy.
      UNKNOWN_CONDITIONAL: At least one binding was found but it is
        conditional. undecided, undetermined ,uncertain, open, tentative,
        contingent
      UNKNOWN_INFO_DENIED: Indicating that lack of access to the underlying
        information causes the result to be undetermined. This can be due to
        1) The caller has no access to the policy. In this case
        ExplainedPolicy    will have not policy set.  2) The caller has no
        access to some of the items referenced in the policy.    In this case
        the policy in ExplainedPolicy will be set but the    explanations
        field will contain at least one inconclusive element.
    """
    ACCESS_STATE_UNSPECIFIED = 0
    GRANTED = 1
    NOT_GRANTED = 2
    UNKNOWN_CONDITIONAL = 3
    UNKNOWN_INFO_DENIED = 4

  access = _messages.EnumField('AccessValueValuesEnum', 1)


class GoogleIamAssistV1alpha2ConditionExplanation(_messages.Message):
  r"""Condition Explanation

  Fields:
    evaluationStates: List of evaluated states of non boolean expression in
      the condition
    value: Value of the condition
  """

  evaluationStates = _messages.MessageField('GoogleIamAssistV1alpha2ConditionExplanationEvaluationState', 1, repeated=True)
  value = _messages.MessageField('GoogleIamAssistV1alpha2ConditionExplanationValue', 2)


class GoogleIamAssistV1alpha2ConditionExplanationEvaluationState(_messages.Message):
  r"""Evaluated state of an expression

  Fields:
    end: End position of an expression in the original condition, by
      character, end included, for example: the end position of the first part
      of "a==b || c==d" would be 4
    start: Start position of an expression in the original condition, by
      character
    value: Value of this expression
  """

  end = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  start = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  value = _messages.MessageField('GoogleIamAssistV1alpha2ConditionExplanationValue', 3)


class GoogleIamAssistV1alpha2ConditionExplanationValue(_messages.Message):
  r"""Represents a condition expression value.

  Enums:
    NullValueValueValuesEnum: Null value.

  Fields:
    boolValue: Boolean value.
    nullValue: Null value.
  """

  class NullValueValueValuesEnum(_messages.Enum):
    r"""Null value.

    Values:
      NULL_VALUE: Null value.
    """
    NULL_VALUE = 0

  boolValue = _messages.BooleanField(1)
  nullValue = _messages.EnumField('NullValueValueValuesEnum', 2)


class GoogleIamAssistV1alpha2ExplainAccessRequest(_messages.Message):
  r"""ExplainAccessRequest is used in ExplainAccess

  Fields:
    conditionContext: OPTIONAL: The Cloud IAM condition context under which
      defines the kind of access being explained. ExplainAccess would explain
      if and why the principal has the queried permission on the resource
      specified in full_resource_name under this context
    fullResourceName: REQUIRED: A full resource name according to http://go
      /resource-names. This is the full resource name of the resource that
      access is checked against.
    permission: REQUIRED: The Cloud IAM permission under which defines the
      kind of access being explained. Example: "resourcemanager.projects.get"
      would explain if and why the principal has the
      resourcemanager.projects.get permission on the resource specified in
      full_resource_name declared in this structure. See
      https://cloud.google.com/iam/docs/testing-permissions
    principal: REQUIRED: The principal on behalf of who the access is
      explained for. The format is the one of the principal's email addresses
      associated with its gaia account. It must be an account that can appear
      as an actor. For example groups are not supported. Currently, service
      accounts are partially supported.
  """

  conditionContext = _messages.MessageField('GoogleRpcContextAttributeContext', 1)
  fullResourceName = _messages.StringField(2)
  permission = _messages.StringField(3)
  principal = _messages.StringField(4)


class GoogleIamAssistV1alpha2ExplainAccessResponse(_messages.Message):
  r"""ExplainAccessResponse is used in ExplainAccess.

  Enums:
    AccessValueValuesEnum: Reflects whether the probed access was granted,
      denied or ultimately could not be decided from the caller's point of
      view.

  Fields:
    access: Reflects whether the probed access was granted, denied or
      ultimately could not be decided from the caller's point of view.
    explainedPolicies: List of explained policies. Each explanation
      corresponds to one policy along the ancestry path.
  """

  class AccessValueValuesEnum(_messages.Enum):
    r"""Reflects whether the probed access was granted, denied or ultimately
    could not be decided from the caller's point of view.

    Values:
      ACCESS_STATE_UNSPECIFIED: Reserved
      GRANTED: The access is granted due to one or multiple bindings found.
      NOT_GRANTED: The access is not granted by the policy.
      UNKNOWN_CONDITIONAL: At least one binding was found but it is
        conditional. undecided, undetermined ,uncertain, open, tentative,
        contingent
      UNKNOWN_INFO_DENIED: Indicating that lack of access to the underlying
        information causes the result to be undetermined. This can be due to
        1) The caller has no access to the policy. In this case
        ExplainedPolicy    will have not policy set.  2) The caller has no
        access to some of the items referenced in the policy.    In this case
        the policy in ExplainedPolicy will be set but the    explanations
        field will contain at least one inconclusive element.
    """
    ACCESS_STATE_UNSPECIFIED = 0
    GRANTED = 1
    NOT_GRANTED = 2
    UNKNOWN_CONDITIONAL = 3
    UNKNOWN_INFO_DENIED = 4

  access = _messages.EnumField('AccessValueValuesEnum', 1)
  explainedPolicies = _messages.MessageField('GoogleIamAssistV1alpha2ExplainedPolicy', 2, repeated=True)


class GoogleIamAssistV1alpha2ExplainedPolicy(_messages.Message):
  r"""An explained IAM policy combines the raw policy in the context of the
  resource which it is attached to along with detailed evaluation on the
  evaluation parameters provided through the request.

  Enums:
    AccessValueValuesEnum: Access decision for this section of the resource's
      effective policy.

  Fields:
    access: Access decision for this section of the resource's effective
      policy.
    bindingExplanations: Detailed binding evaluation explanations provide
      information about how each binding contributes to the principal's access
      or the lack thereof.
    fullResourceName: Resource that this section of the effective policy
      attaches to.
    policy: The IAM policy attached to the resource.
  """

  class AccessValueValuesEnum(_messages.Enum):
    r"""Access decision for this section of the resource's effective policy.

    Values:
      ACCESS_STATE_UNSPECIFIED: Reserved
      GRANTED: The access is granted due to one or multiple bindings found.
      NOT_GRANTED: The access is not granted by the policy.
      UNKNOWN_CONDITIONAL: At least one binding was found but it is
        conditional. undecided, undetermined ,uncertain, open, tentative,
        contingent
      UNKNOWN_INFO_DENIED: Indicating that lack of access to the underlying
        information causes the result to be undetermined. This can be due to
        1) The caller has no access to the policy. In this case
        ExplainedPolicy    will have not policy set.  2) The caller has no
        access to some of the items referenced in the policy.    In this case
        the policy in ExplainedPolicy will be set but the    explanations
        field will contain at least one inconclusive element.
    """
    ACCESS_STATE_UNSPECIFIED = 0
    GRANTED = 1
    NOT_GRANTED = 2
    UNKNOWN_CONDITIONAL = 3
    UNKNOWN_INFO_DENIED = 4

  access = _messages.EnumField('AccessValueValuesEnum', 1)
  bindingExplanations = _messages.MessageField('GoogleIamAssistV1alpha2BindingExplanation', 2, repeated=True)
  fullResourceName = _messages.StringField(3)
  policy = _messages.MessageField('GoogleIamV1Policy', 4)


class GoogleIamAssistV1alpha2LogsMetadata(_messages.Message):
  r"""Metatdata about the logs used for replay.

  Fields:
    differenceCount: Number of analyzed log entries with a difference between
      baseline and simulated policies.
    newestTime: Timestamp of newest log entry queried.
    oldestTime: Timestamp of oldest log entry queried.
    uniqueLogCount: Number of unique log entries analyzed.
  """

  differenceCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  newestTime = _messages.StringField(2)
  oldestTime = _messages.StringField(3)
  uniqueLogCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleIamAssistV1alpha2ReplayDiff(_messages.Message):
  r"""The differences found between baseline and simulated policies for a
  single access tuple.

  Fields:
    accessDiff: The difference in AccessState between replays.
    accessTuple: The access tuple with a difference between replays.
  """

  accessDiff = _messages.MessageField('GoogleIamAssistV1alpha2ReplayDiffAccessStateDiff', 1)
  accessTuple = _messages.MessageField('GoogleIamAssistV1alpha2AccessTuple', 2)


class GoogleIamAssistV1alpha2ReplayDiffAccessStateDiff(_messages.Message):
  r"""A GoogleIamAssistV1alpha2ReplayDiffAccessStateDiff object.

  Enums:
    BaselineValueValuesEnum: The access state when replayed against the
      baseline policies.
    SimulatedValueValuesEnum: The access state when replayed against the
      simulated policies.

  Fields:
    baseline: The access state when replayed against the baseline policies.
    simulated: The access state when replayed against the simulated policies.
  """

  class BaselineValueValuesEnum(_messages.Enum):
    r"""The access state when replayed against the baseline policies.

    Values:
      ACCESS_STATE_UNSPECIFIED: Reserved
      GRANTED: The access is granted due to one or multiple bindings found.
      NOT_GRANTED: The access is not granted by the policy.
      UNKNOWN_CONDITIONAL: At least one binding was found but it is
        conditional. undecided, undetermined ,uncertain, open, tentative,
        contingent
      UNKNOWN_INFO_DENIED: Indicating that lack of access to the underlying
        information causes the result to be undetermined. This can be due to
        1) The caller has no access to the policy. In this case
        ExplainedPolicy    will have not policy set.  2) The caller has no
        access to some of the items referenced in the policy.    In this case
        the policy in ExplainedPolicy will be set but the    explanations
        field will contain at least one inconclusive element.
    """
    ACCESS_STATE_UNSPECIFIED = 0
    GRANTED = 1
    NOT_GRANTED = 2
    UNKNOWN_CONDITIONAL = 3
    UNKNOWN_INFO_DENIED = 4

  class SimulatedValueValuesEnum(_messages.Enum):
    r"""The access state when replayed against the simulated policies.

    Values:
      ACCESS_STATE_UNSPECIFIED: Reserved
      GRANTED: The access is granted due to one or multiple bindings found.
      NOT_GRANTED: The access is not granted by the policy.
      UNKNOWN_CONDITIONAL: At least one binding was found but it is
        conditional. undecided, undetermined ,uncertain, open, tentative,
        contingent
      UNKNOWN_INFO_DENIED: Indicating that lack of access to the underlying
        information causes the result to be undetermined. This can be due to
        1) The caller has no access to the policy. In this case
        ExplainedPolicy    will have not policy set.  2) The caller has no
        access to some of the items referenced in the policy.    In this case
        the policy in ExplainedPolicy will be set but the    explanations
        field will contain at least one inconclusive element.
    """
    ACCESS_STATE_UNSPECIFIED = 0
    GRANTED = 1
    NOT_GRANTED = 2
    UNKNOWN_CONDITIONAL = 3
    UNKNOWN_INFO_DENIED = 4

  baseline = _messages.EnumField('BaselineValueValuesEnum', 1)
  simulated = _messages.EnumField('SimulatedValueValuesEnum', 2)


class GoogleIamAssistV1alpha2ReplayOperationMetadata(_messages.Message):
  r"""Metadata about a ReplayAccessLogs operation.

  Fields:
    startTime: Time when the request was received.
  """

  startTime = _messages.StringField(1)


class GoogleIamAssistV1alpha2ReplayRecentAccessesRequest(_messages.Message):
  r"""Request for recent accesses replay.

  Messages:
    PolicyOverlayValue: Required. Mapping from full resource names to
      simulated policies.

  Fields:
    policyOverlay: Required. Mapping from full resource names to simulated
      policies.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PolicyOverlayValue(_messages.Message):
    r"""Required. Mapping from full resource names to simulated policies.

    Messages:
      AdditionalProperty: An additional property for a PolicyOverlayValue
        object.

    Fields:
      additionalProperties: Additional properties of type PolicyOverlayValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PolicyOverlayValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleIamV1Policy attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleIamV1Policy', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  policyOverlay = _messages.MessageField('PolicyOverlayValue', 1)


class GoogleIamAssistV1alpha2ReplayRecentAccessesResponse(_messages.Message):
  r"""Result of a ReplayRecentAccesses.

  Fields:
    diffs: List of differences found during replay.
    logsMetadata: Metadata about the replayed logs.
  """

  diffs = _messages.MessageField('GoogleIamAssistV1alpha2ReplayDiff', 1, repeated=True)
  logsMetadata = _messages.MessageField('GoogleIamAssistV1alpha2LogsMetadata', 2)


class GoogleIamV1AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted.  Example Policy with
  multiple AuditConfigs:      {       "audit_configs": [         {
  "service": "allServices"           "audit_log_configs": [             {
  "log_type": "DATA_READ",               "exempted_members": [
  "user:jose@example.com"               ]             },             {
  "log_type": "DATA_WRITE",             },             {
  "log_type": "ADMIN_READ",             }           ]         },         {
  "service": "sampleservice.googleapis.com"           "audit_log_configs": [
  {               "log_type": "DATA_READ",             },             {
  "log_type": "DATA_WRITE",               "exempted_members": [
  "user:aliya@example.com"               ]             }           ]         }
  ]     }  For sampleservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging,
  and aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('GoogleIamV1AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class GoogleIamV1AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:jose@example.com"           ]
  },         {           "log_type": "DATA_WRITE",         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  jose@example.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class GoogleIamV1Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. NOTE: An
      unsatisfied condition will not allow user access via current binding.
      Different bindings, including their conditions, are examined
      independently.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example,
      `alice@example.com` .   * `serviceAccount:{emailid}`: An email address
      that represents a service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.
      * `domain:{domain}`: The G Suite domain (primary) that represents all
      the    users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('GoogleTypeExpr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class GoogleIamV1Policy(_messages.Message):
  r"""Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  is a collection of `bindings`. A `binding` binds one or more `members` to a
  single `role`. Members can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions (defined by IAM or configured by users). A `binding` can
  optionally specify a `condition`, which is a logic expression that further
  constrains the role binding based on attributes about the request and/or
  target resource.  **JSON Example**      {       "bindings": [         {
  "role": "roles/resourcemanager.organizationAdmin",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-project-
  id@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/resourcemanager.organizationViewer",           "members":
  ["user:eve@example.com"],           "condition": {             "title":
  "expirable access",             "description": "Does not grant access after
  Sep 2020",             "expression": "request.time <
  timestamp('2020-10-01T00:00:00.000Z')",           }         }       ]     }
  **YAML Example**      bindings:     - members:       - user:mike@example.com
  - group:admins@example.com       - domain:google.com       - serviceAccount
  :my-project-id@appspot.gserviceaccount.com       role:
  roles/resourcemanager.organizationAdmin     - members:       -
  user:eve@example.com       role: roles/resourcemanager.organizationViewer
  condition:         title: expirable access         description: Does not
  grant access after Sep 2020         expression: request.time <
  timestamp('2020-10-01T00:00:00.000Z')  For a description of IAM and its
  features, see the [IAM developer's
  guide](https://cloud.google.com/iam/docs).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. Optionally may
      specify a `condition` that determines when binding is in effect.
      `bindings` with no members will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten. Due to blind-set semantics of an
      etag-less policy, 'setIamPolicy' will not fail even if either of
      incoming or stored policy does not meet the version requirements.
    version: Specifies the format of the policy.  Valid values are 0, 1, and
      3. Requests specifying an invalid value will be rejected.  Operations
      affecting conditional bindings must specify version 3. This can be
      either setting a conditional policy, modifying a conditional binding, or
      removing a conditional binding from the stored conditional policy.
      Operations on non-conditional policies may specify any valid value or
      leave the field unset.  If no etag is provided in the call to
      `setIamPolicy`, any version compliance checks on the incoming and/or
      stored policy is skipped.
  """

  auditConfigs = _messages.MessageField('GoogleIamV1AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('GoogleIamV1Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleRpcContextAttributeContext(_messages.Message):
  r"""This message defines the standard attribute vocabulary for Google APIs.
  An attribute is a piece of metadata that describes an activity on a network
  service. For example, the size of an HTTP request, or the status code of an
  HTTP response.  Each attribute has a type and a name, which is logically
  defined as a proto message field in `AttributeContext`. The field type
  becomes the attribute type, and the field path becomes the attribute name.
  For example, the attribute `source.ip` maps to field
  `AttributeContext.source.ip`.  This message definition is guaranteed not to
  have any wire breaking change. So you can use it directly for passing
  attributes across different systems.  NOTE: Different system may generate
  different subset of attributes. Please verify the system specification
  before relying on an attribute generated a system.

  Fields:
    api: Represents an API operation that is involved to a network activity.
    destination: The destination of a network activity, such as accepting a
      TCP connection. In a multi hop network activity, the destination
      represents the receiver of the last hop.
    origin: The origin of a network activity. In a multi hop network activity,
      the origin represents the sender of the first hop. For the first hop,
      the `source` and the `origin` must have the same content.
    request: Represents a network request, such as an HTTP request.
    resource: Represents a target resource that is involved with a network
      activity. If multiple resources are involved with an activity, this must
      be the primary one.
    response: Represents a network response, such as an HTTP response.
    source: The source of a network activity, such as starting a TCP
      connection. In a multi hop network activity, the source represents the
      sender of the last hop.
  """

  api = _messages.MessageField('GoogleRpcContextAttributeContextApi', 1)
  destination = _messages.MessageField('GoogleRpcContextAttributeContextPeer', 2)
  origin = _messages.MessageField('GoogleRpcContextAttributeContextPeer', 3)
  request = _messages.MessageField('GoogleRpcContextAttributeContextRequest', 4)
  resource = _messages.MessageField('GoogleRpcContextAttributeContextResource', 5)
  response = _messages.MessageField('GoogleRpcContextAttributeContextResponse', 6)
  source = _messages.MessageField('GoogleRpcContextAttributeContextPeer', 7)


class GoogleRpcContextAttributeContextApi(_messages.Message):
  r"""This message defines attributes associated with API operations, such as
  a network API request. The terminology is based on the conventions used by
  Google APIs, Istio, and OpenAPI.

  Fields:
    operation: The API operation name. For gRPC requests, it is the fully
      qualified API method name, such as "google.pubsub.v1.Publisher.Publish".
      For OpenAPI requests, it is the `operationId`, such as "getPet".
    protocol: The API protocol used for sending the request, such as "http",
      "https", "grpc", or "internal".
    service: The API service name. It is a logical identifier for a networked
      API, such as "pubsub.googleapis.com". The naming syntax depends on the
      API management system being used for handling the request.
    version: The API version associated with the API operation above, such as
      "v1" or "v1alpha1".
  """

  operation = _messages.StringField(1)
  protocol = _messages.StringField(2)
  service = _messages.StringField(3)
  version = _messages.StringField(4)


class GoogleRpcContextAttributeContextAuth(_messages.Message):
  r"""This message defines request authentication attributes. Terminology is
  based on the JSON Web Token (JWT) standard, but the terms also correlate to
  concepts in other standards.

  Messages:
    ClaimsValue: Structured claims presented with the credential. JWTs include
      `{key: value}` pairs for standard and private claims. The following is a
      subset of the standard required and optional claims that would typically
      be presented for a Google-based JWT:     {'iss': 'accounts.google.com',
      'sub': '113289723416554971153',     'aud': ['123456789012',
      'pubsub.googleapis.com'],     'azp':
      '123456789012.apps.googleusercontent.com',     'email':
      'jsmith@example.com',     'iat': 1353601026,     'exp': 1353604926}
      SAML assertions are similarly specified, but with an identity provider
      dependent structure.

  Fields:
    accessLevels: A list of access level resource names that allow resources
      to be accessed by authenticated requester. It is part of Secure GCP
      processing for the incoming request. An access level string has the
      format: "//{api_service_name}/accessPolicies/{policy_id}/accessLevels/{s
      hort_name}"  Example: "//accesscontextmanager.googleapis.com/accessPolic
      ies/MY_POLICY_ID/accessLevels/MY_LEVEL"
    audiences: The intended audience(s) for this authentication information.
      Reflects the audience (`aud`) claim within a JWT. The audience value(s)
      depends on the `issuer`, but typically include one or more of the
      following pieces of information:  *  The services intended to receive
      the credential such as    ["pubsub.googleapis.com",
      "storage.googleapis.com"] *  A set of service-based scopes. For example,
      ["https://www.googleapis.com/auth/cloud-platform"] *  The client id of
      an app, such as the Firebase project id for JWTs    from Firebase Auth.
      Consult the documentation for the credential issuer to determine the
      information provided.
    claims: Structured claims presented with the credential. JWTs include
      `{key: value}` pairs for standard and private claims. The following is a
      subset of the standard required and optional claims that would typically
      be presented for a Google-based JWT:     {'iss': 'accounts.google.com',
      'sub': '113289723416554971153',     'aud': ['123456789012',
      'pubsub.googleapis.com'],     'azp':
      '123456789012.apps.googleusercontent.com',     'email':
      'jsmith@example.com',     'iat': 1353601026,     'exp': 1353604926}
      SAML assertions are similarly specified, but with an identity provider
      dependent structure.
    presenter: The authorized presenter of the credential. Reflects the
      optional Authorized Presenter (`azp`) claim within a JWT or the OAuth
      client id. For example, a Google Cloud Platform client id looks as
      follows: "123456789012.apps.googleusercontent.com".
    principal: The authenticated principal. Reflects the issuer (`iss`) and
      subject (`sub`) claims within a JWT. The issuer and subject should be
      `/` delimited, with `/` percent-encoded within the subject fragment. For
      Google accounts, the principal format is:
      "https://accounts.google.com/{id}"
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ClaimsValue(_messages.Message):
    r"""Structured claims presented with the credential. JWTs include `{key:
    value}` pairs for standard and private claims. The following is a subset
    of the standard required and optional claims that would typically be
    presented for a Google-based JWT:     {'iss': 'accounts.google.com',
    'sub': '113289723416554971153',     'aud': ['123456789012',
    'pubsub.googleapis.com'],     'azp':
    '123456789012.apps.googleusercontent.com',     'email':
    'jsmith@example.com',     'iat': 1353601026,     'exp': 1353604926}  SAML
    assertions are similarly specified, but with an identity provider
    dependent structure.

    Messages:
      AdditionalProperty: An additional property for a ClaimsValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ClaimsValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  accessLevels = _messages.StringField(1, repeated=True)
  audiences = _messages.StringField(2, repeated=True)
  claims = _messages.MessageField('ClaimsValue', 3)
  presenter = _messages.StringField(4)
  principal = _messages.StringField(5)


class GoogleRpcContextAttributeContextPeer(_messages.Message):
  r"""This message defines attributes for a node that handles a network
  request. The node can be either a service or an application that sends,
  forwards, or receives the request. Service peers should fill in `principal`
  and `labels` as appropriate.

  Messages:
    LabelsValue: The labels associated with the peer.

  Fields:
    ip: The IP address of the peer.
    labels: The labels associated with the peer.
    port: The network port of the peer.
    principal: The identity of this peer. Similar to `Request.auth.principal`,
      but relative to the peer instead of the request. For example, the
      idenity associated with a load balancer that forwared the request.
    regionCode: The CLDR country/region code associated with the above IP
      address. If the IP address is private, the `region_code` should reflect
      the physical location where this peer is running.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels associated with the peer.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  ip = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  port = _messages.IntegerField(3)
  principal = _messages.StringField(4)
  regionCode = _messages.StringField(5)


class GoogleRpcContextAttributeContextRequest(_messages.Message):
  r"""This message defines attributes for an HTTP request. If the actual
  request is not an HTTP request, the runtime system should try to map the
  actual request to an equivalent HTTP request.

  Messages:
    HeadersValue: The HTTP request headers. If multiple headers share the same
      key, they must be merged according to the HTTP spec. All header keys
      must be lowercased, because HTTP header keys are case-insensitive.

  Fields:
    auth: The request authentication. May be absent for unauthenticated
      requests. Derived from the HTTP request `Authorization` header or
      equivalent.
    headers: The HTTP request headers. If multiple headers share the same key,
      they must be merged according to the HTTP spec. All header keys must be
      lowercased, because HTTP header keys are case-insensitive.
    host: The HTTP request `Host` header value.
    id: The unique ID for a request, which can be propagated to downstream
      systems. The ID should have low probability of collision within a single
      day for a specific service.
    method: The HTTP request method, such as `GET`, `POST`.
    path: The HTTP URL path.
    protocol: The network protocol used with the request, such as "http/1.1",
      "spdy/3", "h2", "h2c", "webrtc", "tcp", "udp", "quic". See
      https://www.iana.org/assignments/tls-extensiontype-values/tls-
      extensiontype-values.xhtml#alpn-protocol-ids for details.
    query: The HTTP URL query in the format of `name1=value`&name2=value2`, as
      it appears in the first line of the HTTP request. No decoding is
      performed.
    reason: A special parameter for request reason. It is used by security
      systems to associate auditing information with a request.
    scheme: The HTTP URL scheme, such as `http` and `https`.
    size: The HTTP request size in bytes. If unknown, it must be -1.
    time: The timestamp when the `destination` service receives the first byte
      of the request.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class HeadersValue(_messages.Message):
    r"""The HTTP request headers. If multiple headers share the same key, they
    must be merged according to the HTTP spec. All header keys must be
    lowercased, because HTTP header keys are case-insensitive.

    Messages:
      AdditionalProperty: An additional property for a HeadersValue object.

    Fields:
      additionalProperties: Additional properties of type HeadersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a HeadersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  auth = _messages.MessageField('GoogleRpcContextAttributeContextAuth', 1)
  headers = _messages.MessageField('HeadersValue', 2)
  host = _messages.StringField(3)
  id = _messages.StringField(4)
  method = _messages.StringField(5)
  path = _messages.StringField(6)
  protocol = _messages.StringField(7)
  query = _messages.StringField(8)
  reason = _messages.StringField(9)
  scheme = _messages.StringField(10)
  size = _messages.IntegerField(11)
  time = _messages.StringField(12)


class GoogleRpcContextAttributeContextResource(_messages.Message):
  r"""This message defines core attributes for a resource. A resource is an
  addressable (named) entity provided by the destination service. For example,
  a file stored on a network storage service.

  Messages:
    LabelsValue: The labels or tags on the resource, such as AWS resource tags
      and Kubernetes resource labels.

  Fields:
    labels: The labels or tags on the resource, such as AWS resource tags and
      Kubernetes resource labels.
    name: The stable identifier (name) of a resource on the `service`. A
      resource can be logically identified as
      "//{resource.service}/{resource.name}". The differences between a
      resource name and a URI are:  *   Resource name is a logical identifier,
      independent of network     protocol and API version. For example,
      `//pubsub.googleapis.com/projects/123/topics/news-feed`. *   URI often
      includes protocol and version information, so it can     be used
      directly by applications. For example,
      `https://pubsub.googleapis.com/v1/projects/123/topics/news-feed`.  See
      https://cloud.google.com/apis/design/resource_names for details.
    service: The name of the service that this resource belongs to, such as
      `pubsub.googleapis.com`. The service may be different from the DNS
      hostname that actually serves the request.
    type: The type of the resource. The syntax is platform-specific because
      different platforms define their resources differently.  For Google
      APIs, the type format must be "{service}/{kind}".
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels or tags on the resource, such as AWS resource tags and
    Kubernetes resource labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labels = _messages.MessageField('LabelsValue', 1)
  name = _messages.StringField(2)
  service = _messages.StringField(3)
  type = _messages.StringField(4)


class GoogleRpcContextAttributeContextResponse(_messages.Message):
  r"""This message defines attributes for a typical network response. It
  generally models semantics of an HTTP response.

  Messages:
    HeadersValue: The HTTP response headers. If multiple headers share the
      same key, they must be merged according to HTTP spec. All header keys
      must be lowercased, because HTTP header keys are case-insensitive.

  Fields:
    code: The HTTP response status code, such as `200` and `404`.
    headers: The HTTP response headers. If multiple headers share the same
      key, they must be merged according to HTTP spec. All header keys must be
      lowercased, because HTTP header keys are case-insensitive.
    size: The HTTP response size in bytes. If unknown, it must be -1.
    time: The timestamp when the `destination` service generates the first
      byte of the response.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class HeadersValue(_messages.Message):
    r"""The HTTP response headers. If multiple headers share the same key,
    they must be merged according to HTTP spec. All header keys must be
    lowercased, because HTTP header keys are case-insensitive.

    Messages:
      AdditionalProperty: An additional property for a HeadersValue object.

    Fields:
      additionalProperties: Additional properties of type HeadersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a HeadersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1)
  headers = _messages.MessageField('HeadersValue', 2)
  size = _messages.IntegerField(3)
  time = _messages.StringField(4)


class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details.  You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class GoogleTypeExpr(_messages.Message):
  r"""Represents an expression text. Example:      title: "User account
  presence"     description: "Determines whether the request has a user
  account"     expression: "size(request.user) > 0"

  Fields:
    description: An optional description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.  The application context of the containing message
      determines which well-known feature set of CEL is supported.
    location: An optional string indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: An optional title for the expression, i.e. a short string
      describing its purpose. This can be used e.g. in UIs which allow to
      enter the expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class IamassistOperationsGetRequest(_messages.Message):
  r"""A IamassistOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class IamassistOperationsListRequest(_messages.Message):
  r"""A IamassistOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
