/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.internal.xcodeproj;

import com.google.common.base.CharMatcher;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.gradle.api.Named;
import org.gradle.ide.xcode.internal.xcodeproj.PBXContainerItem;
import org.gradle.ide.xcode.internal.xcodeproj.XcodeprojSerializer;

public class PBXReference
extends PBXContainerItem
implements Named {
    private final String name;
    @Nullable
    private String path;
    private SourceTree sourceTree;

    public PBXReference(String name, @Nullable String path, SourceTree sourceTree) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.path = path;
        this.sourceTree = (SourceTree)((Object)Preconditions.checkNotNull((Object)((Object)sourceTree)));
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public void setPath(String v) {
        this.path = v;
    }

    public SourceTree getSourceTree() {
        return this.sourceTree;
    }

    public void setSourceTree(SourceTree v) {
        this.sourceTree = v;
    }

    @Override
    public String isa() {
        return "PBXReference";
    }

    @Override
    public int stableHash() {
        return this.name.hashCode();
    }

    @Override
    public void serializeInto(XcodeprojSerializer s) {
        super.serializeInto(s);
        s.addField("name", this.name);
        if (this.path != null) {
            s.addField("path", this.path);
        }
        s.addField("sourceTree", this.sourceTree.toString());
    }

    @Override
    public String toString() {
        return String.format("%s name=%s path=%s sourceTree=%s", new Object[]{super.toString(), this.getName(), this.getPath(), this.getSourceTree()});
    }

    public static enum SourceTree {
        GROUP("<group>"),
        ABSOLUTE("<absolute>"),
        BUILT_PRODUCTS_DIR("BUILT_PRODUCTS_DIR"),
        SDKROOT("SDKROOT"),
        SOURCE_ROOT("SOURCE_ROOT"),
        DEVELOPER_DIR("DEVELOPER_DIR");

        private final String rep;

        private SourceTree(String str) {
            this.rep = str;
        }

        public static Optional<SourceTree> fromBuildSetting(String buildSetting) {
            String data = CharMatcher.is((char)'$').trimLeadingFrom((CharSequence)buildSetting);
            if (data.equals("BUILT_PRODUCTS_DIR")) {
                return Optional.of((Object)((Object)BUILT_PRODUCTS_DIR));
            }
            if (data.equals("SDKROOT")) {
                return Optional.of((Object)((Object)SDKROOT));
            }
            if (data.equals("SOURCE_ROOT")) {
                return Optional.of((Object)((Object)SOURCE_ROOT));
            }
            if (data.equals("DEVELOPER_DIR")) {
                return Optional.of((Object)((Object)DEVELOPER_DIR));
            }
            return Optional.absent();
        }

        public String toString() {
            return this.rep;
        }
    }
}

